/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.seninp.util.UCRUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestUCRUtils {
    private static final String CBF_GOOD_FNAME = "src//resources//dataset/test_dataset_good.txt";
    private static final String CBF_BAD_FNAME = "src//resources//dataset/test_dataset_bad.txt";

    @Test
    public void testReadUCRData() {
        try {
            Map<String, List<double[]>> data = UCRUtils.readUCRData(CBF_GOOD_FNAME);
            Assert.assertEquals(data.keySet().size(), 3L);
            String stats = UCRUtils.datasetStats(data, "CBF_TRAIN ");
            Assert.assertTrue(stats.contains("series length min: 128, max: 128"));
            String prefix = "temp";
            String suffix = Long.toString(System.nanoTime());
            File temp = File.createTempFile("temp", suffix);
            UCRUtils.saveData(data, temp);
            Map<String, List<double[]>> data2 = UCRUtils.readUCRData(temp.getCanonicalPath());
            Assert.assertEquals(data2.keySet().size(), 3L);
        }
        catch (IOException | NumberFormatException e) {
            Assert.fail("Exception should not be thrown");
        }
    }

    @Test
    public void testReadUCRData2() {
        try {
            Map<String, List<double[]>> data = UCRUtils.readUCRData(CBF_BAD_FNAME);
            Assert.fail("should throw an exception");
        }
        catch (IOException | NumberFormatException exception) {
            // empty catch block
        }
    }
}

