/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.registry;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import net.seninp.jmotif.sax.registry.VisitRegistry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestVisitRegistry {
    private static final int REG_SIZE = 177;
    private static final int RANDOM_VISITS = 13;
    private VisitRegistry vr;

    @Before
    public void setUp() throws Exception {
        this.vr = new VisitRegistry(177);
    }

    @Test
    public void testInitCounters() {
        Assert.assertEquals("Test visit registry", 177L, this.vr.size());
        Assert.assertEquals("Test visit registry", 177L, this.vr.getUnvisited().size());
        Assert.assertTrue("Test visit registry", this.vr.getVisited().isEmpty());
    }

    @Test
    public void testMarkPointVisited() {
        int pos;
        Assert.assertEquals("Test visit registry", 177L, this.vr.size());
        ArrayList<Integer> shallBeVisited = new ArrayList<Integer>(13);
        for (int i = 0; i < 13; ++i) {
            pos = this.vr.getNextRandomUnvisitedPosition();
            shallBeVisited.add(pos);
            this.vr.markVisited(pos);
        }
        Assert.assertEquals("Test visit registry", 164L, this.vr.getUnvisited().size());
        Assert.assertEquals("Test visit registry", 13L, this.vr.getVisited().size());
        Iterator i = shallBeVisited.iterator();
        while (i.hasNext()) {
            pos = (Integer)i.next();
            Assert.assertFalse(this.vr.isNotVisited(pos));
            Assert.assertTrue(this.vr.isVisited(pos));
        }
        ArrayList<Integer> visited = this.vr.getVisited();
        for (int pos2 : visited) {
            Assert.assertTrue(shallBeVisited.contains(pos2));
        }
        ArrayList<Integer> unVisited = this.vr.getUnvisited();
        for (int pos3 : unVisited) {
            Assert.assertFalse(shallBeVisited.contains(pos3));
        }
        VisitRegistry vrTransfered = new VisitRegistry(177);
        vrTransfered.transferVisited(this.vr);
        for (Integer pos4 : vrTransfered.getVisited()) {
            Assert.assertTrue(shallBeVisited.contains(pos4));
        }
        for (int pos5 : vrTransfered.getUnvisited()) {
            Assert.assertFalse(shallBeVisited.contains(pos5));
        }
    }

    @Test
    public void testMarkIntervalVisited() {
        int i;
        int mark1Start = 3;
        int mark1End = 29;
        int mark2Start = this.vr.size() / 2;
        int mark2End = this.vr.size() - 17;
        this.vr.markVisited(mark1Start, mark1End);
        this.vr.markVisited(mark2Start, mark2End);
        for (i = 0; i < mark1Start; ++i) {
            Assert.assertTrue(this.vr.isNotVisited(i));
            Assert.assertFalse(this.vr.isVisited(i));
        }
        for (i = mark1Start; i < mark1End; ++i) {
            Assert.assertFalse(this.vr.isNotVisited(i));
            Assert.assertTrue(this.vr.isVisited(i));
        }
        for (i = mark1End; i < mark2Start; ++i) {
            Assert.assertTrue(this.vr.isNotVisited(i));
            Assert.assertFalse(this.vr.isVisited(i));
        }
        for (i = mark2Start; i < mark2End; ++i) {
            Assert.assertFalse(this.vr.isNotVisited(i));
            Assert.assertTrue(this.vr.isVisited(i));
        }
        for (i = mark2End; i < this.vr.size(); ++i) {
            Assert.assertTrue(this.vr.isNotVisited(i));
            Assert.assertFalse(this.vr.isVisited(i));
        }
        Assert.assertTrue(this.vr.isVisited(mark1Start, mark1End));
        Assert.assertTrue(this.vr.isVisited(mark1Start - 1, mark1End));
        Assert.assertTrue(this.vr.isVisited(mark1Start, mark1End + 1));
    }

    @Test
    public void testRandomizer() {
        HashSet<Integer> seq = new HashSet<Integer>();
        int i = -1;
        while (-1 != (i = this.vr.getNextRandomUnvisitedPosition())) {
            this.vr.markVisited(i);
            seq.add(i);
        }
        Assert.assertEquals(177L, this.vr.getVisited().size());
        Assert.assertEquals(seq.size(), this.vr.getVisited().size());
        Assert.assertTrue(this.vr.getUnvisited().isEmpty());
    }

    @Test
    public void testBounds() {
        try {
            this.vr.markVisited(-3);
            Assert.fail("exception was not thrown!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.vr.markVisited(180);
            Assert.fail("exception was not thrown!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.vr.markVisited(-3, 1);
            Assert.fail("exception was not thrown!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.vr.markVisited(1, 178);
            Assert.fail("exception was not thrown!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.vr.isVisited(178);
            Assert.fail("exception was not thrown!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.vr.isVisited(-1);
            Assert.fail("exception was not thrown!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.vr.isNotVisited(-1);
            Assert.fail("exception was not thrown!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.vr.isVisited(2, 178);
            Assert.fail("exception was not thrown!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.vr.isVisited(-2, 177);
            Assert.fail("exception was not thrown!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

