/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.parallel;

import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Callable;
import net.seninp.jmotif.sax.NumerosityReductionStrategy;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.jmotif.sax.alphabet.NormalAlphabet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAXWorker
implements Callable<HashMap<Integer, char[]>> {
    private final long id;
    private final double[] ts;
    private final int intervalStart;
    private final int intervalEnd;
    private final int saxWindowSize;
    private final int saxPAASize;
    private final int saxAlphabetSize;
    private final NumerosityReductionStrategy numerosityReductionStrategy;
    private final double normalizationThreshold;
    private static final Logger LOGGER = LoggerFactory.getLogger(SAXWorker.class);

    public SAXWorker(long id, double[] data, int intervalStart, int intervalEnd, int windowSize, int paaSize, int alphabetSize, NumerosityReductionStrategy nrs, double normalizationThreshold) {
        this.id = id;
        this.ts = data;
        this.intervalStart = intervalStart;
        this.intervalEnd = intervalEnd;
        this.saxWindowSize = windowSize;
        this.saxPAASize = paaSize;
        this.saxAlphabetSize = alphabetSize;
        this.numerosityReductionStrategy = nrs;
        this.normalizationThreshold = normalizationThreshold;
        LOGGER.debug("sax worker instance id {}, data {}, window {}, paa  {}, alphabet {}, nr {}, threshold: {}, start: {}, end: {}", new Object[]{this.id, this.ts.length, this.saxWindowSize, this.saxPAASize, this.saxAlphabetSize, this.numerosityReductionStrategy, normalizationThreshold, this.intervalStart, this.intervalEnd});
    }

    @Override
    public HashMap<Integer, char[]> call() throws Exception {
        NormalAlphabet na = new NormalAlphabet();
        TSProcessor tsp = new TSProcessor();
        HashMap<Integer, char[]> res = new HashMap<Integer, char[]>();
        res.put(-1, String.valueOf(this.id).toCharArray());
        char[] previousString = null;
        for (int i = this.intervalStart; i < this.intervalEnd - (this.saxWindowSize - 1); ++i) {
            double[] subSection = Arrays.copyOfRange(this.ts, i, i + this.saxWindowSize);
            subSection = tsp.znorm(subSection, this.normalizationThreshold);
            double[] paa = tsp.paa(subSection, this.saxPAASize);
            char[] currentString = tsp.ts2String(paa, na.getCuts(this.saxAlphabetSize));
            if (null != previousString && NumerosityReductionStrategy.EXACT.equals((Object)this.numerosityReductionStrategy) && Arrays.equals(previousString, currentString)) continue;
            previousString = currentString;
            res.put(i, currentString);
            LOGGER.trace(this.id + ", " + String.valueOf(currentString) + ", " + i);
            if (!Thread.currentThread().isInterrupted()) continue;
            LOGGER.info("SAXWorker was interrupted... returning NULL");
            return null;
        }
        return res;
    }
}

