/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.motif;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.seninp.jmotif.sax.SAXException;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.jmotif.sax.motif.EMMAImplementation;
import net.seninp.jmotif.sax.motif.MotifRecord;

public class TestMotifDiscoveryMotifletsPaper {
    private static final double ZNORM_THRESHOLD = 0.01;
    private static String path = "/Users/bzcschae/workspace/motif-lets/datasets/";

    public static double[] sampling(double[] series, int sampling) {
        if (series.length > sampling) {
            int factor = series.length / sampling;
            double[] resampled = new double[series.length / factor];
            System.out.println("Factor:" + factor + " " + resampled.length);
            for (int i = 0; i < resampled.length; ++i) {
                resampled[i] = series[i * factor];
            }
            return resampled;
        }
        return series;
    }

    public static Integer[] non_trivial_matches(ArrayList<Integer> offsets, int motif_length) {
        ArrayList<Integer> non_trivial = new ArrayList<Integer>(offsets.size());
        Collections.sort(offsets);
        int m_halve = motif_length / 2;
        int last = -2 * m_halve;
        for (int a : offsets) {
            if (a < last + m_halve) continue;
            non_trivial.add(a);
            last = a;
        }
        return non_trivial.toArray(new Integer[0]);
    }

    public static double[] parse(String s) {
        int length = (int)s.chars().filter(ch -> ch == 44).count() + 1;
        double[] output = new double[length];
        String listString = s.substring(1, s.length() - 1);
        int i = 0;
        for (String token : listString.split(",")) {
            output[i++] = Double.valueOf(token.trim());
        }
        return output;
    }

    public static void main(String[] args) {
        String path = "/Users/bzcschae/workspace/motiflets/datasets/";
        String file_name = path + "ecg-heartbeat-av.txt";
        int w = 125;
        double[] radii = new double[]{1.0, 11.0, 21.0, 31.0, 41.0, 51.0, 61.0, 71.0, 81.0, 91.0, 101.0};
        System.out.println("EMMA");
        if (args.length >= 1) {
            file_name = args[0];
        }
        if (args.length >= 2) {
            radii = TestMotifDiscoveryMotifletsPaper.parse(args[1]);
        }
        if (args.length >= 3) {
            w = Integer.valueOf(args[2]);
        }
        try {
            double[] series = TSProcessor.readFileColumn(file_name, 0, 0);
            series = TestMotifDiscoveryMotifletsPaper.sampling(series, 10000);
            System.out.println("[");
            for (double motif_range : radii) {
                MotifRecord motifsEMMA = EMMAImplementation.series2EMMAMotifs(series, w, Math.sqrt(motif_range), 8, 4, 0.01);
                Object[] filtered = TestMotifDiscoveryMotifletsPaper.non_trivial_matches(motifsEMMA.getOccurrences(), w);
                if (filtered.length <= 0) continue;
                System.out.println("\t" + Arrays.toString(filtered) + ",");
            }
            System.out.println("]");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

