/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.motif;

import java.util.Date;
import net.seninp.jmotif.sax.SAXProcessor;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.jmotif.sax.motif.BruteForceMotifImplementation;
import net.seninp.jmotif.sax.motif.EMMAImplementation;
import net.seninp.jmotif.sax.motif.MotifRecord;
import net.seninp.util.StackTrace;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMotifDiscovery {
    private static final String TEST_DATA_FNAME = "src/resources/test-data/ecg0606_1.csv";
    private static final int MOTIF_SIZE = 100;
    private static final double MOTIF_RANGE = 1.5;
    private static final double ZNORM_THRESHOLD = 0.01;
    private double[] series;

    @Before
    public void setUp() throws Exception {
        this.series = TSProcessor.readFileColumn(TEST_DATA_FNAME, 0, 0);
    }

    @Test
    public void testEMMA() {
        try {
            Date start = new Date();
            BruteForceMotifImplementation.distCounter = 0;
            BruteForceMotifImplementation.eaCounter = 0;
            MotifRecord motifsBF = BruteForceMotifImplementation.series2BruteForceMotifs(this.series, 100, 1.5, 0.01);
            System.out.println("brute force: " + SAXProcessor.timeToString(start.getTime(), new Date().getTime()) + " : " + motifsBF + ", dist calls: " + BruteForceMotifImplementation.distCounter + ", early abandoned: " + BruteForceMotifImplementation.eaCounter);
            EMMAImplementation.distCounter = 0;
            EMMAImplementation.eaCounter = 0;
            MotifRecord motifsEMMA = EMMAImplementation.series2EMMAMotifs(this.series, 100, 1.5, 6, 4, 0.01);
            System.out.println("emma: " + SAXProcessor.timeToString(start.getTime(), new Date().getTime()) + " : " + motifsEMMA + ", dist calls: " + EMMAImplementation.distCounter + ", early abandoned: " + EMMAImplementation.eaCounter);
            Assert.assertEquals("Asserting motif frequency", motifsBF.getFrequency(), motifsEMMA.getFrequency());
            for (Integer m : motifsBF.getOccurrences()) {
                Assert.assertTrue("Asserting motif locations", motifsEMMA.getOccurrences().contains(m));
                System.out.println("Offset: " + m);
            }
            for (Integer m : motifsEMMA.getOccurrences()) {
                System.out.println("Offset: " + m);
            }
        }
        catch (Exception e) {
            Assert.fail("It shouldnt fail, but failed with " + StackTrace.toString(e));
        }
    }
}

