/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.discord;

import java.util.Date;
import net.seninp.jmotif.distance.EuclideanDistance;
import net.seninp.jmotif.sax.SAXProcessor;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.jmotif.sax.discord.DiscordRecord;
import net.seninp.jmotif.sax.discord.DiscordRecords;
import net.seninp.jmotif.sax.registry.SlidingWindowMarkerAlgorithm;
import net.seninp.jmotif.sax.registry.VisitRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BruteForceDiscordImplementation {
    private static final Logger LOGGER = LoggerFactory.getLogger(BruteForceDiscordImplementation.class);
    private static TSProcessor tsProcessor = new TSProcessor();
    private static EuclideanDistance ed = new EuclideanDistance();

    public static DiscordRecords series2BruteForceDiscords(double[] series, Integer windowSize, int discordCollectionSize, SlidingWindowMarkerAlgorithm marker, double nThreshold) throws Exception {
        DiscordRecords discords = new DiscordRecords();
        VisitRegistry globalTrackVisitRegistry = new VisitRegistry(series.length);
        globalTrackVisitRegistry.markVisited(series.length - windowSize - 1, series.length);
        int discordCounter = 0;
        while (discords.getSize() < discordCollectionSize) {
            LOGGER.debug("currently known discords: {} out of {}", (Object)discords.getSize(), (Object)discordCollectionSize);
            Date start = new Date();
            DiscordRecord bestDiscord = BruteForceDiscordImplementation.findBestDiscordBruteForce(series, windowSize, globalTrackVisitRegistry, nThreshold);
            bestDiscord.setPayload("#" + discordCounter);
            Date end = new Date();
            if (bestDiscord.getNNDistance() == 0.0 || bestDiscord.getPosition() == -1) {
                LOGGER.debug("breaking the outer search loop, discords found: {} last seen discord: {}" + discords.getSize(), (Object)bestDiscord);
                break;
            }
            bestDiscord.setInfo("position " + bestDiscord.getPosition() + ", NN distance " + bestDiscord.getNNDistance() + ", elapsed time: " + SAXProcessor.timeToString(start.getTime(), end.getTime()) + ", " + bestDiscord.getInfo());
            LOGGER.debug("{}", (Object)bestDiscord.getInfo());
            discords.add(bestDiscord);
            marker.markVisited(globalTrackVisitRegistry, bestDiscord.getPosition(), windowSize);
            ++discordCounter;
        }
        return discords;
    }

    private static DiscordRecord findBestDiscordBruteForce(double[] series, Integer windowSize, VisitRegistry globalRegistry, double nThreshold) throws Exception {
        Date start = new Date();
        long distanceCallsCounter = 0L;
        double bestSoFarDistance = -1.0;
        int bestSoFarPosition = -1;
        VisitRegistry outerRegistry = globalRegistry.clone();
        int outerIdx = -1;
        while (-1 != (outerIdx = outerRegistry.getNextRandomUnvisitedPosition())) {
            int innerIdx;
            outerRegistry.markVisited(outerIdx);
            double[] candidateSeq = tsProcessor.znorm(tsProcessor.subseriesByCopy(series, outerIdx, outerIdx + windowSize), nThreshold);
            double nearestNeighborDistance = Double.MAX_VALUE;
            VisitRegistry innerRegistry = new VisitRegistry(series.length - windowSize);
            while (-1 != (innerIdx = innerRegistry.getNextRandomUnvisitedPosition())) {
                innerRegistry.markVisited(innerIdx);
                if (Math.abs(outerIdx - innerIdx) <= windowSize) continue;
                double[] currentSubsequence = tsProcessor.znorm(tsProcessor.subseriesByCopy(series, innerIdx, innerIdx + windowSize), nThreshold);
                double dist = ed.earlyAbandonedDistance(candidateSeq, currentSubsequence, nearestNeighborDistance);
                ++distanceCallsCounter;
                if (Double.isNaN(dist) || !(dist < nearestNeighborDistance)) continue;
                nearestNeighborDistance = dist;
            }
            if (Double.isInfinite(nearestNeighborDistance) || !(nearestNeighborDistance > bestSoFarDistance)) continue;
            bestSoFarDistance = nearestNeighborDistance;
            bestSoFarPosition = outerIdx;
            LOGGER.trace("discord updated: pos {}, dist {}", (Object)bestSoFarPosition, (Object)bestSoFarDistance);
        }
        Date firstDiscord = new Date();
        LOGGER.debug("best discord found at {}, best distance: {}, in {} distance calls: {}", bestSoFarPosition, bestSoFarDistance, SAXProcessor.timeToString(start.getTime(), firstDiscord.getTime()), distanceCallsCounter);
        DiscordRecord res = new DiscordRecord(bestSoFarPosition, bestSoFarDistance);
        res.setLength(windowSize);
        res.setInfo("distance calls: " + distanceCallsCounter);
        return res;
    }
}

