/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.datastructure;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.seninp.util.StackTrace;

public class DoublyLinkedSortedList<T> {
    private int maxSize;
    private Comparator<T> comparator;
    private Node<T> first = null;
    private int size = 0;

    public DoublyLinkedSortedList(int listSize, Comparator<T> comparator) {
        this.maxSize = listSize;
        this.comparator = comparator;
    }

    public void addElement(T data) {
        Node<T> newNode = new Node<T>(data);
        if (this.isEmpty()) {
            this.first = newNode;
            this.size = 1;
        } else if (this.comparator.compare(newNode.data, this.first.data) > 0) {
            Node<T> tmp = this.first;
            this.first = newNode;
            this.first.next = tmp;
            tmp.prev = this.first;
            ++this.size;
        } else {
            Node<T> prev = this.first;
            Node current = this.first.next;
            while (current != null) {
                if (this.comparator.compare(newNode.data, current.data) > 0) {
                    prev.next = newNode;
                    newNode.prev = prev;
                    current.prev = newNode;
                    newNode.next = current;
                    ++this.size;
                    break;
                }
                current = current.next;
                prev = prev.next;
            }
            if (null == current) {
                prev.next = newNode;
                newNode.prev = prev;
                ++this.size;
            }
            if (this.size > this.maxSize) {
                this.dropLastElement();
            }
        }
    }

    private void dropLastElement() {
        if (this.size >= 2) {
            Node<T> current = this.first;
            while (current.next.next != null) {
                current = current.next;
            }
            current.next.prev = null;
            current.next = null;
            --this.size;
        }
    }

    public Iterator<T> iterator() {
        return new MyIterator(this);
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    private static class Node<T> {
        protected T data;
        protected Node<T> next;
        protected Node<T> prev;

        public Node(T data) {
            this.data = data;
        }

        public String toString() {
            return this.data.toString();
        }
    }

    private class MyIterator
    implements Iterator<T> {
        private DoublyLinkedSortedList<T> list;
        private Node<T> current;

        public MyIterator(DoublyLinkedSortedList<T> doublyLinkedSortedList2) {
            this.list = doublyLinkedSortedList2;
        }

        @Override
        public boolean hasNext() {
            if (null == this.current) {
                return !this.list.isEmpty();
            }
            return null != this.current.next;
        }

        @Override
        public T next() {
            try {
                if (null == this.current) {
                    this.current = this.list.first;
                    return this.current.data;
                }
                this.current = this.current.next;
                return this.current.data;
            }
            catch (Exception e) {
                throw new NoSuchElementException("There was an exception thrown: " + StackTrace.toString(e));
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The remove is unsupported.");
        }
    }
}

