/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.distance;

import net.seninp.jmotif.distance.EuclideanDistance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestEuclideanDistance {
    private EuclideanDistance ed;
    private static final double[] testPoint1D1 = new double[]{0.545};
    private static final double[] testPoint1D2 = new double[]{0.845};
    private static final double[] testPoint3D1 = new double[]{0.545, 0.856, 0.856};
    private static final double[] testPoint3D2 = new double[]{0.845, 0.654, 0.986};
    private static final int[] testPoint3D1I = new int[]{545, 856, 856};
    private static final int[] testPoint3D2I = new int[]{845, 654, 986};
    private static final double[][] testSeries1 = new double[][]{{0.2, 0.6}, {0.3, 0.5}, {0.4, 0.4}, {0.5, 0.3}, {0.6, 0.2}};
    private static final double[][] testSeries2 = new double[][]{{1.0, 1.8}, {1.2, 1.6}, {1.4, 1.4}, {1.6, 1.2}, {1.8, 1.0}};
    private static final double[][] testSeries3 = new double[][]{{1.0, 1.8}, {1.2, 1.6}, {1.4, 1.4}, {1.6, 1.2}};
    private static final double DELTA = 1.0E-6;

    @Before
    public void setUp() {
        this.ed = new EuclideanDistance();
    }

    @Test
    public void testPointDistance() {
        Object[] badSeries2;
        try {
            double dd = Math.abs(testPoint1D2[0] - testPoint1D1[0]);
            Assert.assertEquals("test 1D distance", dd, this.ed.distance(testPoint1D1, testPoint1D2), 1.0E-6);
            Assert.assertEquals("test 1D distance", dd * dd, this.ed.distance2(testPoint1D1, testPoint1D2), 1.0E-6);
            Assert.assertEquals("test 1D distance", dd, this.ed.distance(testPoint1D1[0], testPoint1D2[0]), 1.0E-6);
            Assert.assertEquals("test 1D distance", dd * dd, this.ed.distance2(testPoint1D1[0], testPoint1D2[0]), 1.0E-6);
            int di = Math.abs(Double.valueOf(testPoint1D1[0] * 10.0).intValue() - Double.valueOf(testPoint1D2[0] * 10.0).intValue());
            Assert.assertEquals("test 1D distance", (double)di, this.ed.distance(Double.valueOf(testPoint1D1[0] * 10.0).intValue(), Double.valueOf(testPoint1D2[0] * 10.0).intValue()), 1.0E-6);
            Assert.assertEquals("test point distance", 0.3843228, this.ed.distance(testPoint3D1, testPoint3D2), 1.0E-6);
            Assert.assertEquals("test point distance", 0.147704, this.ed.distance2(testPoint3D1, testPoint3D2), 1.0E-6);
            Assert.assertEquals("test point distance", 384.322781, this.ed.distance(testPoint3D1I, testPoint3D2I), 1.0E-6);
            Assert.assertEquals("test point distance", 0.12810760000000002, this.ed.normalizedDistance(testPoint3D1, testPoint3D2), 1.0E-6);
        }
        catch (Exception e) {
            Assert.fail("Shouldn't throw any exception");
        }
        try {
            Assert.assertEquals("test point distance", 0.3843228, this.ed.distance(testPoint1D1, testPoint3D2), 1.0E-6);
            Assert.fail("Exception is not thrown!");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            badSeries2 = new int[]{15, 16};
            Assert.assertEquals("test point distance", 147704.0, (double)this.ed.distance2(testPoint3D1I, (int[])badSeries2), 1.0E-6);
            Assert.fail("Exception is not thrown!");
        }
        catch (Exception badSeries2) {
            // empty catch block
        }
        try {
            badSeries2 = new double[]{15.0, 16.0};
            Assert.assertEquals("test point distance", 147704.0, this.ed.earlyAbandonedDistance(testPoint3D1, (double[])badSeries2, 0.01), 1.0E-6);
            Assert.fail("Exception is not thrown!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSeriesDistance() {
        Double dist;
        try {
            dist = this.ed.seriesDistance(testSeries1, testSeries2);
            Assert.assertEquals("testing distance, ", 3.193743885, dist, 1.0E-6);
        }
        catch (Exception e) {
            Assert.fail("Should not throw any exception here.");
        }
        try {
            dist = this.ed.seriesDistance(testSeries1, testSeries3);
            Assert.fail("Should throw exception here.");
        }
        catch (Exception dist2) {
            // empty catch block
        }
        int[] x = new int[]{0, 0, 1, 1, 1, 1};
        int[] y = new int[]{1, 0, 1, 1, 0, 1};
        try {
            Assert.assertEquals(1.414214, this.ed.distance(x, y), 0.001);
        }
        catch (Exception e) {
            Assert.fail("should throw an exception");
        }
    }
}

