/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.cbf;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.seninp.jmotif.cbf.CBFGenerator;

public class TestCBFGenerator {
    private static final int SERIES_LENGTH = 128;
    private static final int REPEATS = 5;

    public static void main(String[] args) throws Exception {
        int[] t = new int[128];
        for (int i = 0; i < 128; ++i) {
            t[i] = i;
        }
        ArrayList<double[]> cylinders = new ArrayList<double[]>();
        for (int k = 0; k < 35; ++k) {
            double[] arr = new double[640];
            for (int i = 0; i < 5; ++i) {
                double[] c = CBFGenerator.cylinder(t);
                for (int j = 0; j < 128; ++j) {
                    arr[i * 128 + j] = c[j];
                }
            }
            cylinders.add(arr);
        }
        TestCBFGenerator.save("RCode/CBF_explorer/cylinder.csv", "1", cylinders);
        ArrayList<double[]> bells = new ArrayList<double[]>();
        for (int k = 0; k < 35; ++k) {
            double[] arr = new double[640];
            for (int i = 0; i < 5; ++i) {
                double[] c = CBFGenerator.bell(t);
                for (int j = 0; j < 128; ++j) {
                    arr[i * 128 + j] = c[j];
                }
            }
            bells.add(arr);
        }
        TestCBFGenerator.save("RCode/CBF_explorer/bell.csv", "2", bells);
        ArrayList<double[]> funnels = new ArrayList<double[]>();
        for (int k = 0; k < 35; ++k) {
            double[] arr = new double[640];
            for (int i = 0; i < 5; ++i) {
                double[] c = CBFGenerator.funnel(t);
                for (int j = 0; j < 128; ++j) {
                    arr[i * 128 + j] = c[j];
                }
            }
            funnels.add(arr);
        }
        TestCBFGenerator.save("RCode/CBF_explorer/funnel.csv", "3", funnels);
    }

    private static void save(String fname, String prefix, List<double[]> data) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(fname));
        for (double[] arr : data) {
            bw.write(prefix + " " + Arrays.toString(arr).replace("[", "").replace("]", "").replace(",", " ") + "\n");
        }
        bw.close();
    }
}

