/*
 * Decompiled with CFR 0.152.
 */
package org.happy.controllers.impl;

import com.google.common.base.Preconditions;
import org.happy.commons.patterns.executable.Executable_1x2;
import org.happy.commons.patterns.observer.event.ActionEventAfter_1x0;
import org.happy.commons.patterns.observer.listener.ActionListener_1x0;
import org.happy.controllers.Controller_1x3;
import org.happy.controllers.impl.AbstractController_1x3;

public class FloatProgressController_1x3<P, R>
extends AbstractController_1x3<Float, R> {
    Controller_1x3<P, R> adapted;

    public static <P, R> FloatProgressController_1x3<P, R> of(Controller_1x3<P, R> c) {
        return new FloatProgressController_1x3<P, R>(c);
    }

    public static <P, R> FloatProgressController_1x3<P, R> of(Controller_1x3<P, R> c, final Executable_1x2<Float, P> progressConverter) {
        Preconditions.checkNotNull(progressConverter);
        return new FloatProgressController_1x3<P, R>(c){

            @Override
            protected float convertProgressToFloat(P data) {
                Float progress = (Float)progressConverter.execute(data);
                Preconditions.checkNotNull((Object)progress, (Object)"ProgressConverter generated null, but a float value is expected!");
                Preconditions.checkNotNull((Object)(0.0f <= progress.floatValue() ? 1 : 0), (Object)("ProgressConverter generated invalid value! The value must exceed 0.0 but was " + progress + "."));
                Preconditions.checkNotNull((Object)(progress.floatValue() <= 1.0f ? 1 : 0), (Object)("ProgressConverter generated invalid value! The value must less then 1.0 but was " + progress + "."));
                return progress.floatValue();
            }
        };
    }

    public FloatProgressController_1x3(Controller_1x3<P, R> c) {
        Preconditions.checkNotNull(c);
        this.adapted = c;
    }

    @Override
    public R waitForFinish() {
        return this.adapted.waitForFinish();
    }

    @Override
    public Boolean start() {
        this.adapted.getOnProgressChanged().add(new ActionListener_1x0<ActionEventAfter_1x0<P>>(){

            @Override
            public void actionPerformedImpl(ActionEventAfter_1x0<P> event) {
                float progress = FloatProgressController_1x3.this.convertProgressToFloat(event.getData());
                Preconditions.checkState((0.0f <= progress && progress <= 1.0f ? 1 : 0) != 0, (Object)("progress should be 0<=progress<=1 but was progress=" + progress));
                FloatProgressController_1x3.this.setProgress(Float.valueOf(progress));
            }
        });
        this.adapted.getOnStateChanged().add(new ActionListener_1x0<ActionEventAfter_1x0<Controller_1x3.State_1x3>>(){

            @Override
            public void actionPerformedImpl(ActionEventAfter_1x0<Controller_1x3.State_1x3> event) {
                FloatProgressController_1x3.this.setState(event.getData());
            }
        });
        this.adapted.getOnErrorEvent().add(new ActionListener_1x0<ActionEventAfter_1x0<Throwable>>(){

            @Override
            public void actionPerformedImpl(ActionEventAfter_1x0<Throwable> event) {
                FloatProgressController_1x3.this.fireOnErrorEvent(event.getData());
            }
        });
        return this.adapted.start();
    }

    @Override
    public Boolean cancel() {
        return this.adapted.cancel();
    }

    protected float convertProgressToFloat(P data) {
        return 0.0f;
    }
}

