/*
 * Decompiled with CFR 0.152.
 */
package org.happy.controllers;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Semaphore;
import org.happy.commons.patterns.Factory_1x3;
import org.happy.commons.patterns.executable.Executable_1x2;
import org.happy.controllers.Controller_1x3;
import org.happy.controllers.decorators.ForkJoinPoolController_1x3;
import org.happy.controllers.decorators.SynchronizedController_1x3;
import org.happy.controllers.decorators.TaskLimiterController_1x3;
import org.happy.controllers.decorators.TimeLimiterController_1x3;
import org.happy.controllers.impl.ExecutableController_1x3;
import org.happy.controllers.impl.FloatProgressController_1x3;
import org.happy.controllers.impl.MockController_1x3;
import org.happy.controllers.impl.ProxyController_1x3;
import org.happy.controllers.impl.RetryController_1x3;
import org.happy.controllers.impl.StreamCopyController_1x3;

public final class Controllers_1x3 {
    private Controllers_1x3() {
    }

    public static <P, R> ForkJoinPoolController_1x3<P, R> forkJoinPoolController(Controller_1x3<P, R> c, ForkJoinPool forkJoinPool) {
        return ForkJoinPoolController_1x3.of(c, forkJoinPool);
    }

    public static <P, R> ForkJoinPoolController_1x3<P, R> forkJoinPoolController(Controller_1x3<P, R> c, ForkJoinPool forkJoinPool, Object lockObject) {
        return ForkJoinPoolController_1x3.of(c, forkJoinPool, lockObject);
    }

    public static <P, R> SynchronizedController_1x3<P, R> synchronizedController(Controller_1x3<P, R> c) {
        return SynchronizedController_1x3.of(c);
    }

    public static <P, R> SynchronizedController_1x3<P, R> synchronizedController(Controller_1x3<P, R> c, Object lockObject) {
        return SynchronizedController_1x3.of(c, lockObject);
    }

    public static <P, R> TaskLimiterController_1x3<P, R> taskLimiterController(Controller_1x3<P, R> c, Semaphore semaphore) {
        return TaskLimiterController_1x3.of(c, semaphore);
    }

    public static <P, R> TimeLimiterController_1x3<P, R> timeLimiterController(Controller_1x3<P, R> c, long maxExecutionTime) {
        return TimeLimiterController_1x3.of(c, maxExecutionTime);
    }

    public static <R> ExecutableController_1x3<R> executeableController(Executable_1x2<R, Void> executable, ExecutorService executor) {
        return ExecutableController_1x3.of(executable, executor);
    }

    public static <P, R> FloatProgressController_1x3<P, R> progressFloatController(Controller_1x3<P, R> c) {
        return FloatProgressController_1x3.of(c);
    }

    public static <P, R> FloatProgressController_1x3<P, R> progressFloatController(Controller_1x3<P, R> c, Executable_1x2<Float, P> progressConverter) {
        return FloatProgressController_1x3.of(c, progressConverter);
    }

    public static <P extends Number, R> FloatProgressController_1x3<P, R> progressFloatController(Controller_1x3<P, R> c, final P maxProgressValue) {
        Executable_1x2 progressConverter = new Executable_1x2<Float, P>(){

            @Override
            public Float execute(P parameter) {
                Float progress = new Float(((Number)parameter).doubleValue() / maxProgressValue.doubleValue());
                if (1.0f < progress.floatValue()) {
                    progress = Float.valueOf(1.0f);
                }
                return progress;
            }
        };
        return FloatProgressController_1x3.of(c, progressConverter);
    }

    public static <P, R> MockController_1x3<P, R> mockController(long delay) {
        return MockController_1x3.of(delay);
    }

    public static <P, R> MockController_1x3<P, R> mockController(long delay, Object lockObject) {
        return MockController_1x3.of(delay, lockObject);
    }

    public static <P, R> MockController_1x3<Integer, R> mockController(int startProgress, int endProgress, int deltaProgress, long eventDelay) {
        return MockController_1x3.of(startProgress, endProgress, deltaProgress, eventDelay);
    }

    public static <R> MockController_1x3<Integer, R> mockController(int startProgress, int endProgress, int deltaProgress, long eventDelay, Object lockObject) {
        return MockController_1x3.of(startProgress, endProgress, deltaProgress, eventDelay, lockObject);
    }

    public static <P, R> ProxyController_1x3<P, R> proxyController(Factory_1x3<Controller_1x3<P, R>> factory) {
        return ProxyController_1x3.of(factory);
    }

    public static <P, R> ProxyController_1x3<P, R> proxyController(Factory_1x3<Controller_1x3<P, R>> factory, Object lockObject) {
        return ProxyController_1x3.of(factory, lockObject);
    }

    public static <P, R> RetryController_1x3<P, R> retryController(int maxRetryNumber, long delayBeforeNextTry, Factory_1x3<Controller_1x3<P, R>> factory) {
        return RetryController_1x3.of(maxRetryNumber, delayBeforeNextTry, factory);
    }

    public static <P, R> RetryController_1x3<P, R> retryController(int maxRetryNumber, long delayBeforeNextTry, Factory_1x3<Controller_1x3<P, R>> factory, Object lockObject) {
        return RetryController_1x3.of(maxRetryNumber, delayBeforeNextTry, factory, lockObject);
    }

    public static StreamCopyController_1x3 streamCopyController(InputStream input, OutputStream output) {
        return StreamCopyController_1x3.of(input, output);
    }

    public static StreamCopyController_1x3 streamCopyController(InputStream input, OutputStream output, int fireEventAfterByteNumber) {
        return StreamCopyController_1x3.of(input, output, fireEventAfterByteNumber);
    }

    public static StreamCopyController_1x3 streamCopyController(InputStream input, OutputStream output, ExecutorService executor) {
        return StreamCopyController_1x3.of(input, output, executor);
    }

    public static StreamCopyController_1x3 streamCopyController(InputStream input, OutputStream output, ExecutorService executor, int fireEventAfterByteNumber) {
        return StreamCopyController_1x3.of(input, output, executor, fireEventAfterByteNumber);
    }
}

