/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.patterns.executable.decorators;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.happy.commons.patterns.executable.Executable_1x2;

public class ManyRetryExecutable_1x2<R, P>
implements Executable_1x2<R, P> {
    private int maxTryNumber;
    private ExecutableFactory_1x2<R, P> factory;
    private AtomicInteger tryCounter = new AtomicInteger(0);
    private long waitBeforeNextTry;

    public static void run(final Runnable r, int maxRetryNumber, long waitBeforeNextTry) {
        ManyRetryExecutable_1x2<Void, Void> e = ManyRetryExecutable_1x2.of(new Executable_1x2<Void, Void>(){

            @Override
            public Void execute(Void parameter) {
                r.run();
                return null;
            }
        }, maxRetryNumber, waitBeforeNextTry);
        e.execute(null);
    }

    public static <R, P> ManyRetryExecutable_1x2<R, P> of(final Executable_1x2<R, P> decorated, int maxRetryNumber, long waitBeforeNextTry) {
        return ManyRetryExecutable_1x2.of(new ExecutableFactory_1x2<R, P>(){

            @Override
            public Executable_1x2<R, P> createExeceutable() {
                return decorated;
            }
        }, maxRetryNumber, waitBeforeNextTry);
    }

    public static <R, P> ManyRetryExecutable_1x2<R, P> of(ExecutableFactory_1x2<R, P> fac, int maxRetryNumber, long waitBeforeNextTry) {
        return new ManyRetryExecutable_1x2<R, P>(fac, maxRetryNumber, waitBeforeNextTry);
    }

    protected ManyRetryExecutable_1x2(ExecutableFactory_1x2<R, P> factory, int maxTryNumber, long waitBeforeNextTry) {
        Preconditions.checkNotNull(factory);
        Preconditions.checkArgument((0 < maxTryNumber ? 1 : 0) != 0);
        Preconditions.checkArgument((0L <= waitBeforeNextTry ? 1 : 0) != 0);
        this.factory = factory;
        this.maxTryNumber = maxTryNumber;
        this.waitBeforeNextTry = waitBeforeNextTry;
    }

    @Override
    public R execute(P parameter) {
        ArrayList<Throwable> thrownExceptions = new ArrayList<Throwable>();
        while (true) {
            this.tryCounter.incrementAndGet();
            try {
                Executable_1x2<R, P> executable = this.factory.createExeceutable();
                return executable.execute(parameter);
            }
            catch (Throwable t) {
                thrownExceptions.add(t);
                if (this.maxTryNumber < this.tryCounter.get()) {
                    throw new ManyRetriesException("To Many Retries were done! maxRetries: " + this.maxTryNumber + "; made retries: " + this.tryCounter.get(), thrownExceptions);
                }
                if (0L >= this.waitBeforeNextTry) continue;
                try {
                    Thread.sleep(this.waitBeforeNextTry);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("Therad was interupted during sleeping inside ManyRetriesExecuteable", e);
                }
            }
        }
    }

    public int getTryNumber() {
        return this.tryCounter.get();
    }

    public int getMaxTryNumber() {
        return this.maxTryNumber;
    }

    public static class ManyRetriesException
    extends RuntimeException {
        private static final long serialVersionUID = 7733153035129661168L;
        private List<Throwable> thrownExceptionsList = new ArrayList<Throwable>();

        public ManyRetriesException(String message, List<Throwable> thrownExceptionsList) {
            super(message, thrownExceptionsList.get(thrownExceptionsList.size() - 1));
            this.thrownExceptionsList.addAll(thrownExceptionsList);
        }

        public ManyRetriesException() {
        }

        public ManyRetriesException(String message, boolean enableSuppression, boolean writableStackTrace) {
            super(message, null, enableSuppression, writableStackTrace);
        }

        public List<Throwable> getThrownExceptionsList() {
            return this.thrownExceptionsList;
        }

        @Override
        public void printStackTrace() {
            super.printStackTrace();
            System.err.println("coused by folowing exceptions:");
            for (Throwable t : this.thrownExceptionsList) {
                t.printStackTrace();
            }
        }
    }

    public static interface ExecutableFactory_1x2<R, P> {
        public Executable_1x2<R, P> createExeceutable();
    }
}

