/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.generators;

import java.util.Random;
import org.happy.commons.generators.RandomCharGenerator_1x0;
import org.happy.commons.generators.RandomIntegerGenerator_1x0;
import org.happy.commons.patterns.Generator_1x0;
import org.happy.commons.patterns.version.Version_1x0;

public class RandomNameGenerator_1x0
implements Generator_1x0<String>,
Version_1x0<Float> {
    private RandomCharGenerator_1x0 randomCharGenerator1;
    private RandomCharGenerator_1x0 randomCharGenerator2;
    private RandomCharGenerator_1x0 randomCharGenerator3;
    private RandomIntegerGenerator_1x0 randomIntegerGenerator;
    private RandomIntegerGenerator_1x0 randomIntegerGeneratorLegth;

    public RandomNameGenerator_1x0(int minNameLength, int maxNameLength) {
        this(minNameLength, maxNameLength, null);
    }

    public RandomNameGenerator_1x0(int minNameLength, int maxNameLength, Random random) {
        if (minNameLength < 0) {
            throw new IllegalArgumentException("minNameLength must be bigger as 0");
        }
        if (maxNameLength < minNameLength) {
            throw new IllegalArgumentException("minNameLength can't be smaller then maxNameLength!");
        }
        this.randomCharGenerator1 = new RandomCharGenerator_1x0('a', 'z', random);
        this.randomCharGenerator2 = new RandomCharGenerator_1x0('A', 'Z', random);
        this.randomCharGenerator3 = new RandomCharGenerator_1x0('0', '9', random);
        this.randomIntegerGenerator = new RandomIntegerGenerator_1x0(0, 2, random);
        this.randomIntegerGeneratorLegth = new RandomIntegerGenerator_1x0(minNameLength, maxNameLength, random);
    }

    @Override
    public String generate() {
        String name = "";
        int length = this.randomIntegerGeneratorLegth.generate();
        for (int i = 0; i < length; ++i) {
            int sw = this.randomIntegerGenerator.generate();
            Character ch = sw == 0 ? this.randomCharGenerator1.generate() : (sw == 1 ? this.randomCharGenerator2.generate() : this.randomCharGenerator3.generate());
            name = name + ch;
        }
        return name;
    }

    @Override
    public Float getVersion() {
        return Float.valueOf(1.0f);
    }

    public String toString() {
        return "RandomNameGenerator_1x0 [randomCharGenerator1=" + this.randomCharGenerator1 + ", randomCharGenerator2=" + this.randomCharGenerator2 + ", randomCharGenerator3=" + this.randomCharGenerator3 + ", randomIntegerGenerator=" + this.randomIntegerGenerator + ", randomIntegerGeneratorLegth=" + this.randomIntegerGeneratorLegth + "]";
    }
}

