/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.generators;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashSet;
import org.happy.commons.patterns.Generator_1x0;
import org.happy.commons.patterns.version.Version_1x0;

public class DoubleStepGenerator_1x0
implements Generator_1x0<ImmutableSet<Double>>,
Version_1x0<Float> {
    ImmutableSet<Double> immutableSet;

    public DoubleStepGenerator_1x0(Double start, Double end, int steps) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)start, (Object)"start value can't be null!");
        Preconditions.checkNotNull((Object)end, (Object)"end value can't be null!");
        Double delta = (end - start) / new Double(steps - 1);
        LinkedHashSet<Double> valuesSet = new LinkedHashSet<Double>();
        valuesSet.add(start);
        for (int i = 1; i < steps - 1; ++i) {
            Double v = start + (double)i * delta;
            valuesSet.add(v);
        }
        valuesSet.add(end);
        this.immutableSet = ImmutableSet.copyOf(valuesSet);
    }

    public DoubleStepGenerator_1x0(Double start, Double max, Double delta) throws IllegalArgumentException {
        Preconditions.checkArgument((0.0 < max - start && 0.0 < delta || max - start < 0.0 && delta < 0.0 ? 1 : 0) != 0, (Object)"the defined parameter can produce invinity in creating of elements!");
        Preconditions.checkNotNull((Object)start, (Object)"start value can't be null!");
        Preconditions.checkNotNull((Object)max, (Object)"end value can't be null!");
        Preconditions.checkNotNull((Object)delta, (Object)"delta value can't be null!");
        LinkedHashSet<Double> valuesSet = new LinkedHashSet<Double>();
        Double v = start;
        while (v <= max) {
            valuesSet.add(v);
            v = v + delta;
        }
        Preconditions.checkArgument((!valuesSet.isEmpty() ? 1 : 0) != 0, (Object)"no elements were generated!");
        this.immutableSet = ImmutableSet.copyOf(valuesSet);
    }

    public DoubleStepGenerator_1x0(int steps, Double start, Double delta) throws IllegalArgumentException {
        Preconditions.checkArgument((0 < steps ? 1 : 0) != 0, (Object)"steps must be bigger then zero!");
        Preconditions.checkNotNull((Object)start, (Object)"start value can't be null!");
        Preconditions.checkNotNull((Object)delta, (Object)"delta value can't be null!");
        LinkedHashSet<Double> valuesSet = new LinkedHashSet<Double>();
        valuesSet.add(start);
        Double v = start;
        for (int i = 1; i < steps; ++i) {
            v = v + delta;
            valuesSet.add(v);
        }
        this.immutableSet = ImmutableSet.copyOf(valuesSet);
    }

    @Override
    public ImmutableSet<Double> generate() {
        return this.immutableSet;
    }

    @Override
    public Float getVersion() {
        return Float.valueOf(1.0f);
    }

    public String toString() {
        return "DoubleStepGenerator_1x0 [immutableSet=" + this.immutableSet + "]";
    }
}

