/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections.maps.decorators;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.happy.collections.maps.decorators.EventMap_1x2;
import org.happy.collections.maps.decorators.MapDecorator_1x0;
import org.happy.collections.maps.decorators.SynchronizedMap_1x2;
import org.happy.commons.patterns.observer.event.ActionEventAfter_1x0;
import org.happy.commons.patterns.observer.listener.ActionListener_1x0;

public class TransientMap_1x2<K, V>
extends MapDecorator_1x0<K, V> {
    private Timer timer;
    private long maxAge;
    private Object lockObject = new Object();
    private Map<K, Long> ageMap;
    private long updatePeriod;
    private Map<K, V> decoratedInternal;
    Map<K, Long> unmoidfieableAgeMap;

    public static <K, V> TransientMap_1x2<K, V> of(Map<K, V> decorated, long maxAge, long updatePeriod) {
        return new TransientMap_1x2<K, V>(decorated, maxAge, updatePeriod);
    }

    public TransientMap_1x2(Map<K, V> decorated, long maxAge, long updatePeriod) {
        super(decorated);
        this.maxAge = maxAge;
        this.updatePeriod = updatePeriod;
        this.setDecorated(decorated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Timer updateTimer() {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.timer == null) {
                String name = TransientMap_1x2.class.getSimpleName() + "-Timer";
                boolean isDeamon = false;
                this.timer = new Timer(name, isDeamon);
                long startDelay = 0L;
                TimerTask task = new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = TransientMap_1x2.this.lockObject;
                        synchronized (object) {
                            TransientMap_1x2.this.cleanup();
                        }
                    }
                };
                this.timer.schedule(task, startDelay, this.updatePeriod);
            }
            return this.timer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.timer != null) {
                this.timer.cancel();
            }
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        Set<Map.Entry<K, Long>> entrySet = this.ageMap.entrySet();
        long currentTime = System.currentTimeMillis();
        Object decoratedMap = this.getDecorated();
        for (Map.Entry<K, Long> entry : entrySet) {
            Long valueTime = entry.getValue();
            Preconditions.checkNotNull((Object)valueTime);
            long lifeTime = currentTime - valueTime;
            Object object = this.lockObject;
            synchronized (object) {
                if (this.maxAge < lifeTime) {
                    decoratedMap.remove(entry.getKey());
                }
                if (decoratedMap.isEmpty() && this.timer != null) {
                    this.timer.cancel();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDecorated(Map<K, V> decorated) {
        Preconditions.checkNotNull(decorated);
        Object object = this.lockObject;
        synchronized (object) {
            this.ageMap = new HashMap<K, Long>();
            Long value = System.currentTimeMillis();
            for (K key : decorated.keySet()) {
                this.ageMap.put(key, value);
            }
            EventMap_1x2<K, V> eventMap = EventMap_1x2.of(decorated);
            eventMap.getOnAfterGetEvent().add(new ActionListener_1x0<ActionEventAfter_1x0<Map.Entry<K, V>>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformedImpl(ActionEventAfter_1x0<Map.Entry<K, V>> event) {
                    Object object = TransientMap_1x2.this.lockObject;
                    synchronized (object) {
                        Object key = event.getData().getKey();
                        Long value = System.currentTimeMillis();
                        TransientMap_1x2.this.ageMap.put(key, value);
                    }
                }
            });
            eventMap.getOnAfterPutEvent().add(new ActionListener_1x0<ActionEventAfter_1x0<Map.Entry<K, V>>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformedImpl(ActionEventAfter_1x0<Map.Entry<K, V>> event) {
                    Object object = TransientMap_1x2.this.lockObject;
                    synchronized (object) {
                        TransientMap_1x2.this.updateTimer();
                        Object key = event.getData().getKey();
                        Long value = System.currentTimeMillis();
                        TransientMap_1x2.this.ageMap.put(key, value);
                    }
                }
            });
            eventMap.getOnAfterRemoveEvent().add(new ActionListener_1x0<ActionEventAfter_1x0<Map.Entry<K, V>>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformedImpl(ActionEventAfter_1x0<Map.Entry<K, V>> event) {
                    Object key = event.getData().getKey();
                    TransientMap_1x2.this.ageMap.remove(key);
                    Object object = TransientMap_1x2.this.lockObject;
                    synchronized (object) {
                        if (TransientMap_1x2.this.ageMap.isEmpty() && TransientMap_1x2.this.timer != null) {
                            TransientMap_1x2.this.timer.cancel();
                        }
                    }
                }
            });
            SynchronizedMap_1x2<K, V> synchMap = SynchronizedMap_1x2.of(eventMap, this.lockObject);
            super.setDecorated(synchMap);
            this.decoratedInternal = decorated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, V> getDecorated() {
        Object object = this.lockObject;
        synchronized (object) {
            return this.decoratedInternal;
        }
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public long getUpdatePeriod() {
        return this.updatePeriod;
    }

    public Map<K, Long> getAgeMap() {
        if (this.unmoidfieableAgeMap == null) {
            this.unmoidfieableAgeMap = Collections.unmodifiableMap(SynchronizedMap_1x2.of(this.ageMap, this.lockObject));
        }
        return this.unmoidfieableAgeMap;
    }
}

