/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections.lists.decorators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.happy.collections.lists.decorators.EventList_1x0;
import org.happy.collections.lists.decorators.ListDecorator_1x0;
import org.happy.commons.patterns.observer.Delegate_1x0;
import org.happy.commons.patterns.observer.event.ActionEventAfter_1x0;
import org.happy.commons.patterns.observer.event.ActionEventBefore_1x0;
import org.happy.commons.patterns.observer.listener.ActionListener_1x0;

public class SetList_1x0<E>
extends ListDecorator_1x0<E, List<E>>
implements Set<E> {
    private boolean isSet;
    private EventList_1x0<E> eventList;

    public static <T> SetList_1x0<T> of(List<T> list, boolean isSet) {
        return new SetList_1x0<T>(list, isSet);
    }

    public SetList_1x0(List<E> list, boolean isSet) {
        super(list, true);
        if (!list.isEmpty() && isSet) {
            this.removeDuplicates(list);
        }
        this.isSet = isSet;
        this.eventList = new EventList_1x0<E>(list);
        this.eventList.getOnBeforeAddEvent().add(new ActionListener_1x0<ActionEventBefore_1x0<E>>(){

            @Override
            public void actionPerformedImpl(ActionEventBefore_1x0<E> event) {
                if (SetList_1x0.this.isSet) {
                    Object elem = event.getData();
                    if (SetList_1x0.this.eventList.contains(elem)) {
                        event.setCanceled(true);
                    }
                }
            }
        });
        super.setDecorated(this.eventList);
    }

    private void removeDuplicates(List<E> list) {
        ArrayList<E> set = new ArrayList<E>();
        Iterator<E> it = list.iterator();
        while (it.hasNext()) {
            E e = it.next();
            if (!set.contains(e)) {
                set.add(e);
                continue;
            }
            it.remove();
        }
    }

    public boolean isSet() {
        return this.isSet;
    }

    public void setSet(boolean isSet) {
        boolean changed = false;
        if (isSet != this.isSet) {
            changed = true;
        }
        this.isSet = isSet;
        if (changed) {
            this.removeDuplicates(this.eventList);
        }
    }

    @Override
    public boolean add(E o) {
        return this.eventList.add(o);
    }

    @Override
    public void add(int index, E o) {
        this.eventList.add(index, o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.eventList.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.eventList.addAll(index, c);
    }

    @Override
    public void clear() {
        this.eventList.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.eventList.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.eventList.containsAll(c);
    }

    @Override
    public E get(int index) {
        return this.eventList.get(index);
    }

    @Override
    public List<E> getDecorated() {
        return (List)this.eventList.getDecorated();
    }

    public Delegate_1x0<ActionEventAfter_1x0<E>> getOnAfterAddEvent() {
        return this.eventList.getOnAfterAddEvent();
    }

    public Delegate_1x0<ActionEventAfter_1x0<Collection<E>>> getOnAfterClearEvent() {
        return this.eventList.getOnAfterClearEvent();
    }

    public Delegate_1x0<ActionEventAfter_1x0<E>> getOnAfterGetEvent() {
        return this.eventList.getOnAfterGetEvent();
    }

    public Delegate_1x0<ActionEventAfter_1x0<E>> getOnAfterModifyEvent() {
        return this.eventList.getOnAfterModifyEvent();
    }

    public Delegate_1x0<ActionEventAfter_1x0<E>> getOnAfterRemoveEvent() {
        return this.eventList.getOnAfterRemoveEvent();
    }

    public Delegate_1x0<ActionEventBefore_1x0<E>> getOnBeforeAddEvent() {
        return this.eventList.getOnBeforeAddEvent();
    }

    public Delegate_1x0<ActionEventBefore_1x0<Collection<E>>> getOnBeforeClearEvent() {
        return this.eventList.getOnBeforeClearEvent();
    }

    public Delegate_1x0<ActionEventBefore_1x0<E>> getOnBeforeGetEvent() {
        return this.eventList.getOnBeforeGetEvent();
    }

    public Delegate_1x0<ActionEventBefore_1x0<E>> getOnBeforeModifyEvent() {
        return this.eventList.getOnBeforeModifyEvent();
    }

    public Delegate_1x0<ActionEventBefore_1x0<E>> getOnBeforeRemoveEvent() {
        return this.eventList.getOnBeforeRemoveEvent();
    }

    @Override
    public Float getVersion() {
        return this.eventList.getVersion();
    }

    @Override
    public int hashCode() {
        return this.eventList.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.eventList.indexOf(o);
    }

    @Override
    public boolean isDecorateIterators() {
        return this.eventList.isDecorateIterators();
    }

    @Override
    public boolean isEmpty() {
        return this.eventList.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.eventList.iterator();
    }

    @Override
    public int lastIndexOf(Object index) {
        return this.eventList.lastIndexOf(index);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.eventList.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(E elem) {
        return this.eventList.listIterator(elem);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.eventList.listIterator(index);
    }

    @Override
    public E remove(int index) {
        return this.eventList.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.eventList.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.eventList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.eventList.retainAll(c);
    }

    @Override
    public E set(int index, E o) {
        return this.eventList.set(index, o);
    }

    @Override
    public void setDecorated(Collection<E> decorated) {
        this.eventList.setDecorated(decorated);
    }

    @Override
    public void setDecorateIterators(boolean decorateIterators) {
        this.eventList.setDecorateIterators(decorateIterators);
    }

    @Override
    public int size() {
        return this.eventList.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.eventList.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.eventList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.eventList.toArray(a);
    }

    @Override
    public String toString() {
        return this.eventList.toString();
    }

    @Override
    protected ListIterator<E> listIteratorImpl(int index) {
        throw new IllegalStateException("listIteratorImpl-method is not used");
    }

    @Override
    protected Iterator<E> iteratorImpl() {
        throw new IllegalStateException("iteratorImpl-method is not used");
    }
}

