/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections.lists.decorators;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.happy.collections.decorators.CollectionDecorator_1x0;
import org.happy.collections.lists.List_1x0;
import org.happy.commons.patterns.version.Version_1x0;

public abstract class ListDecorator_1x0<E, D extends List<E>>
extends CollectionDecorator_1x0<E, D>
implements List_1x0<E>,
Version_1x0<Float> {
    private boolean avoidLoop;

    public ListDecorator_1x0(D list) {
        this(list, true);
    }

    public ListDecorator_1x0(D list, boolean decorateIterators) {
        super(list);
        if (list == null) {
            throw new IllegalArgumentException("the decorated list can't be null");
        }
    }

    @Override
    public D getDecorated() {
        return (D)((List)super.getDecorated());
    }

    @Override
    public void setDecorated(D decorated) {
        super.setDecorated(decorated);
    }

    @Override
    public boolean add(E arg0) {
        return ((List)this.decorated).add(arg0);
    }

    @Override
    public void add(int arg0, E arg1) {
        ((List)this.decorated).add(arg0, arg1);
    }

    @Override
    public boolean addAll(Collection<? extends E> arg0) {
        return ((List)this.decorated).addAll(arg0);
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends E> arg1) {
        return ((List)this.decorated).addAll(arg0, arg1);
    }

    @Override
    public void clear() {
        ((List)this.decorated).clear();
    }

    @Override
    public boolean contains(Object arg0) {
        return ((List)this.decorated).contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return ((List)this.decorated).containsAll(arg0);
    }

    @Override
    public E get(int arg0) {
        return ((List)this.decorated).get(arg0);
    }

    @Override
    public int indexOf(Object arg0) {
        return ((List)this.decorated).indexOf(arg0);
    }

    @Override
    public boolean isEmpty() {
        return ((List)this.decorated).isEmpty();
    }

    @Override
    public int lastIndexOf(Object arg0) {
        return ((List)this.decorated).lastIndexOf(arg0);
    }

    @Override
    public ListIterator<E> listIterator() {
        if (this.isDecorateIterators()) {
            return this.listIterator(false);
        }
        return ((List)this.decorated).listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        ListIterator it = null;
        if (this.isDecorateIterators() && !this.avoidLoop) {
            this.avoidLoop = true;
            it = this.listIteratorImpl(index);
            this.avoidLoop = false;
        } else {
            it = ((List)this.decorated).listIterator(index);
        }
        return it;
    }

    @Override
    public ListIterator<E> listIterator(E elem) {
        int i = 0;
        ListIterator it = ((List)this.decorated).listIterator();
        while (it.hasNext()) {
            if (elem.equals(it.next())) {
                return this.listIterator((E)i);
            }
            ++i;
        }
        return null;
    }

    protected abstract ListIterator<E> listIteratorImpl(int var1);

    @Override
    public E remove(int index) {
        return ((List)this.decorated).remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return ((List)this.decorated).remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return ((List)this.decorated).removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return ((List)this.decorated).retainAll(c);
    }

    @Override
    public E set(int index, E element) {
        return ((List)this.decorated).set(index, element);
    }

    @Override
    public int size() {
        return ((List)this.decorated).size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return ((List)this.decorated).subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return ((List)this.decorated).toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return ((List)this.decorated).toArray(a);
    }

    @Override
    public Float getVersion() {
        return Float.valueOf(1.0f);
    }

    @Override
    public String toString() {
        return ((List)this.decorated).toString();
    }
}

