/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections.decorators;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.happy.collections.decorators.CollectionDecorator_1x0;
import org.happy.collections.decorators.UnmodifiableStrategy_1x0;
import org.happy.collections.decorators.iterators.IteratorDecorator_1x0;
import org.happy.collections.maps.decorators.UnmodifiableMap_1x0;
import org.happy.commons.patterns.Cacheable_1x2;

public class CacheCollection_1x0<E>
extends CollectionDecorator_1x0<E, Collection<E>>
implements Cacheable_1x2 {
    private float cacheSizePercent;
    private int cleanFaktor = 2;
    private int startCacheIndex = 0;
    protected Map<E, Integer> cache = new HashMap<E, Integer>();
    protected int cacheCounter = 0;
    private UnmodifiableMap_1x0<E, Integer> unmodifieableCacheDecorator = null;

    public static <E> CacheCollection_1x0<E> of(float cacheSize, Collection<E> c) {
        return new CacheCollection_1x0<E>(cacheSize, c);
    }

    public CacheCollection_1x0(float cacheSize, Collection<E> decorateable) {
        super(decorateable);
        this.cacheSizePercent = cacheSize;
    }

    protected boolean cacheElement(E e) {
        float cacheElementsNumber = this.cacheSizePercent * (float)((Collection)this.decorated).size();
        if ((float)this.cache.size() < cacheElementsNumber) {
            this.cleanCache();
        }
        boolean found = false;
        ++this.cacheCounter;
        Integer cacheCounterReturened = this.cache.remove(e);
        if (cacheCounterReturened != null) {
            found = true;
        }
        this.cache.put(e, this.cacheCounter);
        return found;
    }

    private void cleanCache() {
        int minNumber = this.startCacheIndex + (int)(this.cacheSizePercent * (float)this.cache.size()) / this.cleanFaktor;
        Iterator<Integer> it = this.cache.values().iterator();
        while (it.hasNext()) {
            Integer number = it.next();
            if (number >= minNumber) continue;
            it.remove();
        }
    }

    @Override
    public boolean add(E e) {
        this.cacheElement(e);
        return ((Collection)this.decorated).add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E e : c) {
            this.cacheElement(e);
        }
        return ((Collection)this.decorated).addAll(c);
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.cacheCounter = 0;
        ((Collection)this.decorated).clear();
    }

    @Override
    public boolean contains(Object o) {
        if (this.cache.containsKey(o)) {
            ++this.cacheCounter;
            this.cache.put(o, this.cacheCounter);
            return true;
        }
        if (((Collection)this.decorated).contains(o)) {
            this.cacheElement(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean foundAll = false;
        for (Object e : c) {
            if (foundAll = foundAll || this.cacheElement(e)) continue;
            break;
        }
        if (foundAll) {
            return true;
        }
        return super.containsAll(c);
    }

    @Override
    public boolean remove(Object o) {
        this.cache.remove(o);
        return ((Collection)this.decorated).remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object e : c) {
            this.cache.remove(e);
        }
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.cache.clear();
        for (Object e : c) {
            this.cacheElement(e);
        }
        return super.retainAll(c);
    }

    @Override
    protected Iterator<E> iteratorImpl() {
        IteratorDecorator_1x0 it = new IteratorDecorator_1x0<E>(((Collection)this.decorated).iterator()){
            private E current;
            {
                this.current = null;
            }

            @Override
            public E next() {
                this.current = super.next();
                if (CacheCollection_1x0.this.isDecorateIterators()) {
                    CacheCollection_1x0.this.cacheElement(this.current);
                }
                return this.current;
            }

            @Override
            public void remove() {
                CacheCollection_1x0.this.cache.remove(this.current);
                super.remove();
            }
        };
        return it;
    }

    public float getCacheSize() {
        return this.cacheSizePercent;
    }

    public void setCacheSize(float cacheSize) {
        Preconditions.checkArgument((0.0f <= cacheSize && cacheSize <= 1.0f ? 1 : 0) != 0);
        this.cacheSizePercent = cacheSize;
    }

    public Map<E, Integer> getCache() {
        if (this.unmodifieableCacheDecorator == null) {
            this.unmodifieableCacheDecorator = new UnmodifiableMap_1x0<E, Integer>(this.cache, UnmodifiableStrategy_1x0.RemoveAllowed);
        }
        return this.unmodifieableCacheDecorator;
    }

    @Override
    public boolean refresh() {
        this.getCache().clear();
        return true;
    }
}

