/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections;

import java.util.Collection;
import java.util.Iterator;

public class EmptyCollection_1x0<E>
implements Collection<E> {
    private boolean returnOnAdd;
    private boolean returnOnRemove;
    private boolean returnOnContains;
    private boolean throwException = false;

    public EmptyCollection_1x0() {
        this(false, false, false);
        this.throwException = true;
    }

    public EmptyCollection_1x0(boolean returnOnAdd, boolean returnOnRemove, boolean returnOnContains) {
        this.returnOnAdd = returnOnAdd;
        this.returnOnRemove = returnOnRemove;
        this.returnOnContains = returnOnContains;
    }

    protected boolean onAdd(E elem) {
        return this.returnOnAdd;
    }

    protected boolean onRemove(E elem) {
        return this.returnOnRemove;
    }

    protected boolean returnOnContains(E o) {
        return this.returnOnContains;
    }

    @Override
    public int size() {
        if (this.throwException) {
            throw new UnsupportedOperationException();
        }
        return 0;
    }

    @Override
    public boolean isEmpty() {
        if (this.throwException) {
            throw new UnsupportedOperationException();
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        if (this.throwException) {
            throw new UnsupportedOperationException();
        }
        return this.returnOnContains(o);
    }

    @Override
    public Iterator<E> iterator() {
        if (this.throwException) {
            throw new UnsupportedOperationException();
        }
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public E next() {
                return null;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public Object[] toArray() {
        if (this.throwException) {
            throw new UnsupportedOperationException();
        }
        return new Object[0];
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (this.throwException) {
            throw new UnsupportedOperationException();
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        if (this.throwException) {
            throw new UnsupportedOperationException();
        }
        return this.onAdd(e);
    }

    @Override
    public boolean remove(Object o) {
        if (this.throwException) {
            throw new UnsupportedOperationException();
        }
        return this.onRemove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (this.throwException) {
            throw new UnsupportedOperationException();
        }
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (this.throwException) {
            throw new UnsupportedOperationException();
        }
        boolean changed = false;
        for (E obj : c) {
            changed = changed || this.add(obj);
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.throwException) {
            throw new UnsupportedOperationException();
        }
        boolean changed = false;
        for (Object obj : c) {
            changed = changed || this.remove(obj);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.throwException) {
            throw new UnsupportedOperationException();
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.throwException) {
            throw new UnsupportedOperationException();
        }
    }

    public boolean isThrowException() {
        return this.throwException;
    }

    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    public boolean isReturnOnAdd() {
        return this.returnOnAdd;
    }

    public void setReturnOnAdd(boolean returnOnAdd) {
        this.returnOnAdd = returnOnAdd;
    }

    public boolean isReturnOnRemove() {
        return this.returnOnRemove;
    }

    public void setReturnOnRemove(boolean returnOnRemove) {
        this.returnOnRemove = returnOnRemove;
    }

    public boolean isReturnOnContains() {
        return this.returnOnContains;
    }

    public void setReturnOnContains(boolean returnOnContains) {
        this.returnOnContains = returnOnContains;
    }
}

