/*
 * Decompiled with CFR 0.152.
 */
package org.happy.controllers.impl;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.happy.commons.concurrent.ConcurrentUtils_1x2;
import org.happy.controllers.Controller_1x3;
import org.happy.controllers.impl.AbstractController_1x3;

public class StreamCopyController_1x3
extends AbstractController_1x3<Long, Long> {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private InputStream input;
    private OutputStream output;
    private int eventAfterByteNumber;
    private boolean isExecutorCreated = false;
    private ExecutorService executor;
    private CountDownLatch finishedLatch = new CountDownLatch(1);
    private AtomicBoolean isCanceled = new AtomicBoolean(false);

    public static StreamCopyController_1x3 of(InputStream input, OutputStream output) {
        return new StreamCopyController_1x3(input, output);
    }

    public static StreamCopyController_1x3 of(InputStream input, OutputStream output, int fireEventAfterByteNumber) {
        return new StreamCopyController_1x3(input, output, fireEventAfterByteNumber);
    }

    public static StreamCopyController_1x3 of(InputStream input, OutputStream output, ExecutorService executor) {
        return new StreamCopyController_1x3(input, output, executor);
    }

    public static StreamCopyController_1x3 of(InputStream input, OutputStream output, ExecutorService executor, int fireEventAfterByteNumber) {
        return new StreamCopyController_1x3(input, output, executor, fireEventAfterByteNumber);
    }

    public StreamCopyController_1x3(InputStream input, OutputStream output) {
        this(input, output, 4096);
    }

    public StreamCopyController_1x3(InputStream input, OutputStream output, int fireEventAfterByteNumber) {
        this(input, output, ConcurrentUtils_1x2.createFixedExecutorService(1, StreamCopyController_1x3.class.getCanonicalName()), fireEventAfterByteNumber);
        this.isExecutorCreated = true;
    }

    public StreamCopyController_1x3(InputStream input, OutputStream output, ExecutorService executor) {
        this(input, output, executor, 4096);
    }

    public StreamCopyController_1x3(InputStream input, OutputStream output, ExecutorService executor, int fireEventAfterByteNumber) {
        Preconditions.checkNotNull((Object)input);
        Preconditions.checkNotNull((Object)output);
        Preconditions.checkNotNull((Object)executor);
        Preconditions.checkArgument((0 < fireEventAfterByteNumber ? 1 : 0) != 0, (Object)"eventAfterByteNumber should be greater then 0!");
        this.input = input;
        this.output = output;
        this.eventAfterByteNumber = fireEventAfterByteNumber;
        this.executor = executor;
    }

    @Override
    public Long waitForFinish() {
        try {
            this.finishedLatch.await();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        return (Long)this.getResult();
    }

    @Override
    public Boolean start() {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    long count = StreamCopyController_1x3.this.copyLarge(StreamCopyController_1x3.this.input, StreamCopyController_1x3.this.output);
                    StreamCopyController_1x3.this.setResult(count);
                    StreamCopyController_1x3.this.setProgress(count);
                    StreamCopyController_1x3.this.setState(Controller_1x3.State_1x3.Finished);
                }
                catch (Throwable e) {
                    StreamCopyController_1x3.this.fireOnErrorEvent(e);
                    StreamCopyController_1x3.this.setResult(-1L);
                }
                finally {
                    StreamCopyController_1x3.this.finishedLatch.countDown();
                }
                if (StreamCopyController_1x3.this.isExecutorCreated) {
                    StreamCopyController_1x3.this.executor.shutdown();
                }
            }
        });
        this.setState(Controller_1x3.State_1x3.Started);
        return true;
    }

    private long copyLarge(InputStream input, OutputStream output) throws IOException {
        long delta = 0L;
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer)) && !this.isCanceled.get()) {
            output.write(buffer, 0, n);
            count += (long)n;
            if ((long)this.eventAfterByteNumber >= (delta += (long)n)) continue;
            this.fireOnProgressChangedEvent(count);
            delta = 0L;
        }
        return count;
    }

    @Override
    public Boolean cancel() {
        this.setState(Controller_1x3.State_1x3.Canceled);
        this.isCanceled.set(true);
        return true;
    }

    @Override
    protected void setState(Controller_1x3.State_1x3 state) {
        super.setState(state);
        if (Controller_1x3.State_1x3.Canceled.equals((Object)state) || Controller_1x3.State_1x3.Finished.equals((Object)state)) {
            try {
                if (this.input != null) {
                    this.input.close();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                if (this.output != null) {
                    this.output.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

