/*
 * Decompiled with CFR 0.152.
 */
package org.happy.controllers.impl;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.happy.commons.patterns.Lockable_1x0;
import org.happy.commons.patterns.observer.event.ActionEventAfter_1x0;
import org.happy.commons.patterns.observer.listener.ActionListener_1x0;
import org.happy.controllers.Controller_1x3;
import org.happy.controllers.impl.AbstractController_1x3;

public class MockController_1x3<P, R>
extends AbstractController_1x3<P, R>
implements Lockable_1x0 {
    private Timer timer;
    private Map<Controller_1x3.State_1x3, R> stateResultMap;
    private long delay;
    private boolean throwException = false;
    private AtomicBoolean finished = new AtomicBoolean(false);
    private Object lockObject;

    public static <P, R> MockController_1x3<P, R> of(long delay) {
        return new MockController_1x3<P, R>(delay);
    }

    public static <P, R> MockController_1x3<P, R> of(long delay, Object lockObject) {
        return new MockController_1x3<P, R>(delay, lockObject);
    }

    public static <R> MockController_1x3<Integer, R> of(int startProgress, int endProgress, int deltaProgress, long eventDelay) {
        return MockController_1x3.of(startProgress, endProgress, deltaProgress, eventDelay, new Object());
    }

    public static <R> MockController_1x3<Integer, R> of(int startProgress, final int endProgress, final int deltaProgress, final long eventDelay, Object lockObject) {
        Preconditions.checkNotNull((Object)startProgress);
        Preconditions.checkNotNull((Object)startProgress);
        Preconditions.checkArgument((startProgress < endProgress ? 1 : 0) != 0, (Object)"start progress must be smaller as the endProgress!");
        Preconditions.checkNotNull((Object)deltaProgress);
        Preconditions.checkNotNull((Object)(0 < deltaProgress ? 1 : 0));
        Preconditions.checkNotNull((Object)(0L < eventDelay ? 1 : 0));
        final MockController_1x3 c = new MockController_1x3(-1L, lockObject);
        final AtomicReference timerRef = new AtomicReference();
        final AtomicInteger currentProgress = new AtomicInteger(startProgress);
        c.getOnStateChanged().add(new ActionListener_1x0<ActionEventAfter_1x0<Controller_1x3.State_1x3>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformedImpl(ActionEventAfter_1x0<Controller_1x3.State_1x3> event) {
                Timer timer;
                Controller_1x3.State_1x3 s = event.getData();
                if (Controller_1x3.State_1x3.Started.equals((Object)s)) {
                    AtomicReference atomicReference = timerRef;
                    synchronized (atomicReference) {
                        Preconditions.checkState((timerRef.get() == null ? 1 : 0) != 0, (Object)"timer was already initialized and can be initialized the second time!");
                        final Timer timer2 = new Timer(MockController_1x3.class.getSimpleName() + " id=" + c.getID());
                        timerRef.set(timer2);
                        timer2.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                int p = currentProgress.addAndGet(deltaProgress);
                                if (endProgress <= p) {
                                    p = endProgress;
                                    timer2.cancel();
                                }
                                c.setProgress(p);
                                if (endProgress <= p) {
                                    c.finish();
                                }
                            }
                        }, eventDelay, eventDelay);
                    }
                } else if ((Controller_1x3.State_1x3.Canceled.equals((Object)s) || Controller_1x3.State_1x3.Finished.equals((Object)s)) && (timer = (Timer)timerRef.get()) != null) {
                    timer.cancel();
                }
            }
        });
        return c;
    }

    public MockController_1x3(long delay) {
        this(delay, new Object());
    }

    public MockController_1x3(long delay, Object lockObject) {
        Preconditions.checkNotNull((Object)lockObject);
        this.delay = delay;
        this.lockObject = lockObject;
        this.timer = new Timer(this.getClass().getName() + " timer, id=" + this.getID(), true);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R waitForFinish() {
        this.tryToThrowException();
        if (Controller_1x3.State_1x3.Created.equals((Object)this.getState())) {
            throw new IllegalStateException("controller was not yet started!");
        }
        if (Controller_1x3.State_1x3.Started.equals((Object)this.getState())) {
            try {
                AtomicBoolean atomicBoolean = this.finished;
                synchronized (atomicBoolean) {
                    while (!this.finished.get()) {
                        this.finished.wait();
                        this.tryToThrowException();
                    }
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.getResult();
    }

    @Override
    public Boolean start() {
        this.tryToThrowException();
        this.setState(Controller_1x3.State_1x3.Started);
        if (0L <= this.delay) {
            this.timer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object object = MockController_1x3.this.lockObject;
                        synchronized (object) {
                            if (Controller_1x3.State_1x3.Started.equals((Object)MockController_1x3.this.getState())) {
                                MockController_1x3.this.finish();
                            } else if (Controller_1x3.State_1x3.Created.equals((Object)MockController_1x3.this.getState())) {
                                MockController_1x3.this.fireOnErrorEvent(new IllegalStateException("the state of " + MockController_1x3.class.getCanonicalName() + " was: " + (Object)((Object)Controller_1x3.State_1x3.Created) + ", but it is not posible at this state!"));
                            }
                        }
                    }
                    catch (Exception e) {
                        MockController_1x3.this.fireOnErrorEvent(e);
                    }
                }
            }, this.delay);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean cancel() {
        Object object = this.lockObject;
        synchronized (object) {
            try {
                this.tryToThrowException();
                if (Controller_1x3.State_1x3.Finished.equals((Object)this.getState())) {
                    Boolean bl = false;
                    return bl;
                }
                this.setState(Controller_1x3.State_1x3.Canceled);
            }
            finally {
                AtomicBoolean atomicBoolean = this.finished;
                synchronized (atomicBoolean) {
                    this.finished.set(true);
                    this.finished.notifyAll();
                }
            }
            this.tryToThrowException();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        Object object = this.lockObject;
        synchronized (object) {
            try {
                this.tryToThrowException();
                if (Controller_1x3.State_1x3.Canceled.equals((Object)this.getState())) {
                    return;
                }
                this.setState(Controller_1x3.State_1x3.Finished);
            }
            finally {
                AtomicBoolean atomicBoolean = this.finished;
                synchronized (atomicBoolean) {
                    this.finished.set(true);
                    this.finished.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail() {
        Object object = this.lockObject;
        synchronized (object) {
            this.throwException = true;
            AtomicBoolean atomicBoolean = this.finished;
            synchronized (atomicBoolean) {
                this.finished.set(true);
                this.finished.notifyAll();
            }
        }
        this.fireOnErrorEvent(new RuntimeException("TestException of " + MockController_1x3.class.getCanonicalName()));
    }

    @Override
    public void setResult(R result) {
        super.setResult(result);
    }

    public boolean isThrowException() {
        return this.throwException;
    }

    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToThrowException() {
        if (this.throwException) {
            try {
                this.throwException();
            }
            finally {
                if (this.timer != null) {
                    this.timer.cancel();
                }
            }
        }
    }

    private void throwException() {
        RuntimeException e = new RuntimeException("TestException of " + MockController_1x3.class.getCanonicalName());
        this.fireOnErrorEvent(e);
        throw e;
    }

    public Map<Controller_1x3.State_1x3, R> getStateResultMap() {
        if (this.stateResultMap == null) {
            this.stateResultMap = new HashMap<Controller_1x3.State_1x3, R>();
        }
        return this.stateResultMap;
    }

    @Override
    protected void setState(Controller_1x3.State_1x3 state) {
        Preconditions.checkNotNull((Object)((Object)state));
        if (this.stateResultMap != null && this.stateResultMap.containsKey((Object)state)) {
            this.setResult(this.stateResultMap.get((Object)state));
        }
        super.setState(state);
        if (Controller_1x3.State_1x3.Canceled.equals((Object)state) || Controller_1x3.State_1x3.Finished.equals((Object)state)) {
            this.timer.cancel();
        }
    }

    @Override
    public String toString() {
        return "MockController_1x3 [delay=" + this.delay + ", getID()=" + this.getID() + ", getState()=" + (Object)((Object)this.getState()) + ", getResult()=" + this.getResult() + ", getData()=" + this.getData() + "]";
    }

    @Override
    public Object getLockObject() {
        return this.lockObject;
    }

    @Override
    public void setLockObject(Object lockObject) {
        throw new UnsupportedOperationException();
    }

    public long getDelay() {
        return this.delay;
    }
}

