/*
 * Decompiled with CFR 0.152.
 */
package org.happy.controllers.decorators;

import com.google.common.base.Preconditions;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.happy.commons.patterns.observer.event.ActionEventAfter_1x0;
import org.happy.controllers.Controller_1x3;
import org.happy.controllers.decorators.ControllerDecorator_1x3;

public class TimeLimiterController_1x3<P, R>
extends ControllerDecorator_1x3<P, R> {
    private long maxExecutionTime;
    private ExecutorService executor;
    private AtomicBoolean finishedLock = new AtomicBoolean(false);
    private AtomicBoolean failed = new AtomicBoolean(false);
    private Timer timer;
    private static final AtomicInteger idGenerator = new AtomicInteger(0);
    private boolean isStarted = false;
    private AtomicReference<Throwable> exceptionThrown = new AtomicReference<Object>(null);

    public static <P, R> TimeLimiterController_1x3<P, R> of(Controller_1x3<P, R> decorated, long maxExecutionTime) {
        Preconditions.checkNotNull(decorated);
        Preconditions.checkState((0L < maxExecutionTime ? 1 : 0) != 0, (Object)"The maxExecutionTime must be bigger then zero!");
        return new TimeLimiterController_1x3<P, R>(decorated, maxExecutionTime);
    }

    public TimeLimiterController_1x3(Controller_1x3<P, R> decorated, long maxExecutionTime) {
        super(decorated);
        Preconditions.checkNotNull(decorated);
        Preconditions.checkState((0L < maxExecutionTime ? 1 : 0) != 0, (Object)"The maxExecutionTime must be bigger then zero!");
        this.maxExecutionTime = maxExecutionTime;
    }

    protected void finalize() throws Throwable {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean start() {
        this.isStarted = true;
        ThreadFactory fac = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, TimeLimiterController_1x3.this.getClass().getSimpleName() + ":" + idGenerator.incrementAndGet());
            }
        };
        this.executor = Executors.newSingleThreadExecutor(fac);
        Boolean res = false;
        try {
            res = super.start();
        }
        catch (Throwable e) {
            this.exceptionThrown.set(e);
            AtomicBoolean atomicBoolean = this.finishedLock;
            synchronized (atomicBoolean) {
                this.finishedLock.set(true);
                this.finishedLock.notifyAll();
            }
        }
        if (!this.finishedLock.get()) {
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        TimeLimiterController_1x3.super.waitForFinish();
                    }
                    catch (Exception e) {
                        TimeLimiterController_1x3.this.getOnErrorEvent().fire(new ActionEventAfter_1x0<Exception>((Object)TimeLimiterController_1x3.this, idGenerator.incrementAndGet(), "Error in TimeLimmiterController", e));
                        TimeLimiterController_1x3.this.exceptionThrown.set(e);
                    }
                    finally {
                        AtomicBoolean atomicBoolean = TimeLimiterController_1x3.this.finishedLock;
                        synchronized (atomicBoolean) {
                            TimeLimiterController_1x3.this.finishedLock.set(true);
                            if (TimeLimiterController_1x3.this.timer != null) {
                                TimeLimiterController_1x3.this.timer.cancel();
                            }
                            TimeLimiterController_1x3.this.finishedLock.notifyAll();
                        }
                    }
                }
            });
        }
        this.executor.shutdown();
        AtomicBoolean atomicBoolean = this.finishedLock;
        synchronized (atomicBoolean) {
            if (!this.finishedLock.get()) {
                this.timer = new Timer(TimeLimiterController_1x3.class.getSimpleName() + idGenerator.incrementAndGet());
                this.timer.schedule(new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        AtomicBoolean atomicBoolean = TimeLimiterController_1x3.this.finishedLock;
                        synchronized (atomicBoolean) {
                            if (!TimeLimiterController_1x3.this.finishedLock.get()) {
                                TimeLimiterController_1x3.super.cancel();
                                String msg = "the decorated controller was not finished during defined maxTime:" + TimeLimiterController_1x3.this.maxExecutionTime;
                                TimeoutException exception = new TimeoutException(msg);
                                ActionEventAfter_1x0<TimeoutException> event = new ActionEventAfter_1x0<TimeoutException>((Object)TimeLimiterController_1x3.this, idGenerator.incrementAndGet(), msg, exception);
                                TimeLimiterController_1x3.super.getOnErrorEvent().fire(event);
                                TimeLimiterController_1x3.this.failed.set(true);
                            }
                            if (TimeLimiterController_1x3.this.timer != null) {
                                TimeLimiterController_1x3.this.timer.cancel();
                            }
                            TimeLimiterController_1x3.this.finishedLock.set(true);
                            TimeLimiterController_1x3.this.finishedLock.notifyAll();
                        }
                    }
                }, this.maxExecutionTime);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R waitForFinish() {
        Controller_1x3.State_1x3 state = this.getState();
        if (Controller_1x3.State_1x3.Canceled.equals((Object)state) || Controller_1x3.State_1x3.Finished.equals((Object)state)) {
            return super.waitForFinish();
        }
        if (!this.isStarted) {
            throw new IllegalStateException("The controller " + this.getClass().getSimpleName() + " was not started, thus you can' wait for finish!");
        }
        try {
            AtomicBoolean atomicBoolean = this.finishedLock;
            synchronized (atomicBoolean) {
                while (!this.finishedLock.get()) {
                    this.finishedLock.wait();
                }
                if (this.failed.get()) {
                    throw new RuntimeException(new TimeoutException("the decorated controller was not finished during defined maxTime:" + this.maxExecutionTime));
                }
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        if (this.exceptionThrown.get() != null) {
            throw new IllegalStateException(this.exceptionThrown.get());
        }
        Object res = super.waitForFinish();
        Controller_1x3.State_1x3 finalState = this.getState();
        Preconditions.checkState((Controller_1x3.State_1x3.Finished.equals((Object)finalState) || Controller_1x3.State_1x3.Canceled.equals((Object)finalState) ? 1 : 0) != 0, (Object)("state was " + (Object)((Object)finalState)));
        return res;
    }

    public long getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    public void setMaxExecutionTime(long maxExecutionTime) {
        if (this.isStarted) {
            throw new IllegalStateException("the controller was already started, thus the ma execution time can't be seted anymore!");
        }
        this.maxExecutionTime = maxExecutionTime;
    }
}

