/*
 * Decompiled with CFR 0.152.
 */
package org.happy.controllers.decorators;

import com.google.common.base.Preconditions;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.happy.commons.patterns.observer.event.ActionEventAfter_1x0;
import org.happy.commons.patterns.observer.listener.ActionListener_1x0;
import org.happy.controllers.Controller_1x3;
import org.happy.controllers.decorators.ControllerDecorator_1x3;

public class TaskLimiterController_1x3<P, R>
extends ControllerDecorator_1x3<P, R> {
    private Semaphore semaphore;
    private boolean isStarted = false;
    private AtomicBoolean semaphorReleased = new AtomicBoolean(false);
    private AtomicBoolean decoratedStarted = new AtomicBoolean(false);

    public static <P, R> TaskLimiterController_1x3<P, R> of(Controller_1x3<P, R> decorated, Semaphore semaphore) {
        return new TaskLimiterController_1x3<P, R>(decorated, semaphore);
    }

    public TaskLimiterController_1x3(Controller_1x3<P, R> decorated, Semaphore semaphore) {
        super(decorated);
        Preconditions.checkNotNull((Object)semaphore);
        this.semaphore = semaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean start() {
        if (this.isStarted) {
            return false;
        }
        this.isStarted = true;
        ((Controller_1x3)this.decorated).getOnErrorEvent().add(new ActionListener_1x0<ActionEventAfter_1x0<Throwable>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformedImpl(ActionEventAfter_1x0<Throwable> event) {
                AtomicBoolean atomicBoolean = TaskLimiterController_1x3.this.semaphorReleased;
                synchronized (atomicBoolean) {
                    if (!TaskLimiterController_1x3.this.semaphorReleased.get()) {
                        TaskLimiterController_1x3.this.semaphore.release();
                        TaskLimiterController_1x3.this.semaphorReleased.set(true);
                    }
                }
            }
        });
        ((Controller_1x3)this.decorated).getOnStateChanged().add(new ActionListener_1x0<ActionEventAfter_1x0<Controller_1x3.State_1x3>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformedImpl(ActionEventAfter_1x0<Controller_1x3.State_1x3> event) {
                Controller_1x3.State_1x3 state = ((Controller_1x3)TaskLimiterController_1x3.this.decorated).getState();
                if (!Controller_1x3.State_1x3.Canceled.equals((Object)state) && !Controller_1x3.State_1x3.Finished.equals((Object)state)) {
                    return;
                }
                AtomicBoolean atomicBoolean = TaskLimiterController_1x3.this.semaphorReleased;
                synchronized (atomicBoolean) {
                    if (!TaskLimiterController_1x3.this.semaphorReleased.get()) {
                        TaskLimiterController_1x3.this.semaphore.release();
                        TaskLimiterController_1x3.this.semaphorReleased.set(true);
                    }
                }
            }
        });
        try {
            this.semaphore.acquire();
            Controller_1x3.State_1x3 state = ((Controller_1x3)this.decorated).getState();
            if (Controller_1x3.State_1x3.Canceled.equals((Object)state)) {
                return false;
            }
        }
        catch (Exception e) {
            ActionEventAfter_1x0<Exception> event = new ActionEventAfter_1x0<Exception>((Object)this, UUID.randomUUID().clockSequence(), "Exception", e);
            this.getOnErrorEvent().fire(event);
        }
        Boolean result = false;
        try {
            result = ((Controller_1x3)this.decorated).start();
        }
        finally {
            AtomicBoolean atomicBoolean = this.decoratedStarted;
            synchronized (atomicBoolean) {
                this.decoratedStarted.set(true);
                this.decoratedStarted.notifyAll();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R waitForFinish() {
        try {
            AtomicBoolean atomicBoolean = this.decoratedStarted;
            synchronized (atomicBoolean) {
                while (!this.decoratedStarted.get()) {
                    this.decoratedStarted.wait();
                }
            }
        }
        catch (Exception e) {
            ActionEventAfter_1x0<Exception> event = new ActionEventAfter_1x0<Exception>((Object)this, UUID.randomUUID().clockSequence(), "Exception", e);
            this.getOnErrorEvent().fire(event);
        }
        return super.waitForFinish();
    }
}

