/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.patterns.observer.decorators;

import com.google.common.base.Preconditions;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.happy.commons.patterns.Lockable_1x0;
import org.happy.commons.patterns.observer.Delegate_1x0;
import org.happy.commons.patterns.observer.decorators.DelegateDecorator_1x0;
import org.happy.commons.patterns.observer.listener.ActionListener_1x0;

public class SynchronizedDelegate_1x0<A extends ActionEvent>
extends DelegateDecorator_1x0<A>
implements Lockable_1x0 {
    private AtomicBoolean copyListenersOnFire;
    private Object lockObejct;

    public static <A extends ActionEvent> SynchronizedDelegate_1x0<A> of(Delegate_1x0<A> d) {
        return new SynchronizedDelegate_1x0<A>(d);
    }

    public static <A extends ActionEvent> SynchronizedDelegate_1x0<A> of(Delegate_1x0<A> d, boolean copyListenersOnFire) {
        return new SynchronizedDelegate_1x0<A>(d, copyListenersOnFire, true);
    }

    public static <A extends ActionEvent> SynchronizedDelegate_1x0<A> of(Delegate_1x0<A> d, Object lockObject) {
        return new SynchronizedDelegate_1x0<A>(d, true, lockObject);
    }

    public static <A extends ActionEvent> SynchronizedDelegate_1x0<A> of(Delegate_1x0<A> d, boolean copyListenersOnFire, Object lockObject) {
        return new SynchronizedDelegate_1x0<A>(d, copyListenersOnFire, lockObject);
    }

    public SynchronizedDelegate_1x0(Delegate_1x0<A> decorateable) {
        this(decorateable, true, new Object());
    }

    public SynchronizedDelegate_1x0(Delegate_1x0<A> decorateable, boolean copyListenersOnFire) {
        this(decorateable, copyListenersOnFire, new Object());
    }

    public SynchronizedDelegate_1x0(Delegate_1x0<A> decorateable, boolean copyListenersOnFire, Object lock) {
        super(decorateable);
        Preconditions.checkNotNull((Object)lock);
        this.lockObejct = lock;
        this.copyListenersOnFire = new AtomicBoolean(copyListenersOnFire);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(ActionListener listener) {
        Object object = this.lockObejct;
        synchronized (object) {
            return super.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(ActionListener_1x0<A> listener) {
        Object object = this.lockObejct;
        synchronized (object) {
            return super.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(ActionListener l) {
        Object object = this.lockObejct;
        synchronized (object) {
            return super.contains(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fire(A e) {
        HashSet<ActionListener> listeners = null;
        if (this.copyListenersOnFire.get()) {
            Object object = this.lockObejct;
            synchronized (object) {
                listeners = new HashSet<ActionListener>(((Delegate_1x0)this.decorated).getListeners());
            }
            for (ActionListener listener : listeners) {
                listener.actionPerformed((ActionEvent)e);
            }
        } else {
            Object object = this.lockObejct;
            synchronized (object) {
                for (ActionListener listener : ((Delegate_1x0)this.decorated).getListeners()) {
                    listener.actionPerformed((ActionEvent)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getListenerCount() {
        Object object = this.lockObejct;
        synchronized (object) {
            return super.getListenerCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ActionListener> int getListenerCount(Class<T> t) {
        Object object = this.lockObejct;
        synchronized (object) {
            return super.getListenerCount(t);
        }
    }

    @Override
    public <T extends ActionListener> Set<T> getListeners(Class<T> t) {
        return Collections.synchronizedSet(super.getListeners(t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Float getVersion() {
        Object object = this.lockObejct;
        synchronized (object) {
            return super.getVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(ActionListener listener) {
        Object object = this.lockObejct;
        synchronized (object) {
            return super.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        Object object = this.lockObejct;
        synchronized (object) {
            super.removeAll();
        }
    }

    public boolean getCopyListenersOnFire() {
        return this.copyListenersOnFire.get();
    }

    public void setCopyListenersOnFire(boolean copyListenersOnFire) {
        this.copyListenersOnFire.set(copyListenersOnFire);
    }

    @Override
    public Object getLockObject() {
        return this.lockObejct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLockObject(Object lockObject) {
        Object object = this.lockObejct;
        synchronized (object) {
            this.lockObejct = lockObject;
        }
    }
}

