/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.io.streams.decorators;

import java.io.IOException;
import java.io.InputStream;
import org.happy.commons.io.streams.decorators.InputStreamDecorator_1x2;
import org.happy.commons.patterns.Cancelable_1x0;

public class CancelableInputStream_1x2
extends InputStreamDecorator_1x2
implements Cancelable_1x0<Boolean> {
    boolean isCanceled = false;

    public static CancelableInputStream_1x2 of(InputStream decorated) {
        return new CancelableInputStream_1x2(decorated);
    }

    public CancelableInputStream_1x2(InputStream is) {
        super(is);
    }

    @Override
    public Boolean cancel() {
        this.isCanceled = true;
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.isCanceled) {
            throw new IOException("The input stream was cacneled, thus you can't read any bytes anymore!");
        }
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.isCanceled) {
            throw new IOException("The input stream was cacneled, thus you can't read any bytes anymore!");
        }
        return super.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.isCanceled) {
            throw new IOException("The input stream was cacneled, thus you can't read any bytes anymore!");
        }
        return super.read(b);
    }
}

