/*
 * Decompiled with CFR 0.152.
 */
package lm;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.happy.commons.concurrent.loops.ForEachTask_1x0;
import org.happy.commons.concurrent.loops.Parallel_1x0;

public class LearnMotifs {
    public double[][] S;
    public double[][] M;
    public ArrayList<ArrayList<Integer>> Mpos;
    public int J;
    public int K;
    public int L;
    public double[][] nabla;
    public double eta;
    public int maxIter;
    public double T;
    public double alpha;
    public double bestF = -1.0;
    public double[][] bestM = null;
    double[][] perSegmentFrequencies;
    double[][] phi;
    double c_F;
    double c_V;
    Random rand = new Random();

    public static double[] sampling(double[] series, int sampling) {
        if (series.length > sampling) {
            int factor = series.length / sampling;
            double[] resampled = new double[series.length / factor];
            System.out.println("Factor:" + factor + " " + resampled.length);
            for (int i = 0; i < resampled.length; ++i) {
                resampled[i] = series[i * factor];
            }
            return resampled;
        }
        return series;
    }

    public double[] ZNormalizeSegment(double[] ts, int pos, int w) {
        int itr;
        double[] segment = new double[w];
        for (int i = 0; i < w; ++i) {
            segment[i] = ts[pos + i];
        }
        double mean = 0.0;
        for (int itr2 = 0; itr2 < segment.length; ++itr2) {
            mean += segment[itr2];
        }
        mean /= (double)segment.length;
        double stdDev = 0.0;
        for (itr = 0; itr < segment.length; ++itr) {
            stdDev += segment[itr] * segment[itr];
        }
        stdDev /= (double)segment.length;
        stdDev -= mean * mean;
        stdDev = Math.sqrt(stdDev);
        for (itr = 0; itr < segment.length; ++itr) {
            segment[itr] = (segment[itr] - mean) / stdDev;
        }
        return segment;
    }

    public void LoadSegments(String segmentsFile, int w, int sampling) {
        this.Mpos = new ArrayList();
        for (int i = 0; i < this.K; ++i) {
            this.Mpos.add(new ArrayList());
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(segmentsFile));
            int tsLength = 0;
            while ((line = br.readLine()) != null) {
                ++tsLength;
            }
            br.close();
            double[] ts = new double[tsLength];
            this.J = ts.length - w + 1;
            this.L = w;
            br = new BufferedReader(new FileReader(segmentsFile));
            int lineCount = 0;
            while ((line = br.readLine()) != null) {
                for (int l = 0; l < this.L; ++l) {
                    ts[lineCount] = Double.parseDouble(line);
                }
                ++lineCount;
            }
            br.close();
            ts = LearnMotifs.sampling(ts, sampling);
            this.J = ts.length - w + 1;
            this.S = new double[this.J][this.L];
            for (int j = 0; j < this.J; ++j) {
                this.S[j] = this.ZNormalizeSegment(ts, j, w);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void InitializeMethod() {
        this.M = new double[this.K][this.L];
        this.nabla = new double[this.K][this.L];
        double dist = 0.0;
        for (int k = 0; k < this.K; ++k) {
            boolean isDiverse = true;
            int selectedSegmentIdx = 0;
            int numTrials = 0;
            int maxNumTrials = 1000;
            do {
                selectedSegmentIdx = this.rand.nextInt(this.J);
                isDiverse = true;
                for (int q = 0; q < k; ++q) {
                    dist = 0.0;
                    for (int l = 0; l < this.L; ++l) {
                        dist += (this.S[selectedSegmentIdx][l] - this.M[q][l]) * (this.S[selectedSegmentIdx][l] - this.M[q][l]);
                    }
                    if (!(dist < 2.0 * this.T)) continue;
                    isDiverse = false;
                }
            } while (!isDiverse && ++numTrials < maxNumTrials);
            for (int l = 0; l < this.L; ++l) {
                this.M[k][l] = this.S[selectedSegmentIdx][l];
                this.nabla[k][l] = 0.0;
            }
        }
        this.perSegmentFrequencies = new double[this.K][this.J];
        this.phi = new double[this.K][this.K];
        this.c_F = -2.0 * this.alpha / ((double)this.J * (double)this.K * this.T);
        this.c_V = 2.0 / ((double)this.K * (double)(this.K - 1) * (this.T * this.T));
    }

    public double ComputeFrequencyPerSegment(int k, int j) {
        double dist_kj = 0.0;
        double err = 0.0;
        for (int l = 0; l < this.L; ++l) {
            err = this.M[k][l] - this.S[j][l];
            dist_kj += err * err;
        }
        return Math.exp(-this.alpha / this.T * dist_kj);
    }

    public double ComputeFrequencyPerSegment(double[][] motifs, int k, int j) {
        double dist_kj = 0.0;
        double err = 0.0;
        for (int l = 0; l < this.L; ++l) {
            err = motifs[k][l] - this.S[j][l];
            dist_kj += err * err;
        }
        return Math.exp(-this.alpha / this.T * dist_kj);
    }

    public double ComputeFrequency() {
        double score = 0.0;
        for (int k = 0; k < this.K; ++k) {
            for (int j = 0; j < this.J; ++j) {
                score += this.perSegmentFrequencies[k][j];
            }
        }
        return score / ((double)this.J * (double)this.K);
    }

    public double ComputeFrequency(double[] motifPerSegmentFrequencies) {
        double score = 0.0;
        for (int j = 0; j < this.J; ++j) {
            score += motifPerSegmentFrequencies[j];
        }
        return score;
    }

    public void PreComputePerSegmentFrequencies() {
        for (int k = 0; k < this.K; ++k) {
            for (int j = 0; j < this.J; ++j) {
                this.perSegmentFrequencies[k][j] = this.ComputeFrequencyPerSegment(k, j);
            }
        }
    }

    public void PreComputePairwiseMotifDistance() {
        double err = 0.0;
        for (int k = 0; k < this.K; ++k) {
            for (int q = 0; q < this.K; ++q) {
                this.phi[k][q] = 0.0;
                for (int l = 0; l < this.L; ++l) {
                    err = this.M[k][l] - this.M[q][l];
                    double[] dArray = this.phi[k];
                    int n = q;
                    dArray[n] = dArray[n] + err * err;
                }
            }
        }
    }

    public int ComputeHardFrequency(double[] motifCandidate) {
        int hardFrequency = 0;
        double dist = 0.0;
        int lastMatchIndex = -2;
        for (int j = 0; j < this.J; ++j) {
            dist = 0.0;
            for (int l = 0; l < this.L; ++l) {
                dist += (motifCandidate[l] - this.S[j][l]) * (motifCandidate[l] - this.S[j][l]);
            }
            if (!(dist <= this.T)) continue;
            if (Math.abs(j - lastMatchIndex) > this.L / 2) {
                ++hardFrequency;
            }
            lastMatchIndex = j;
        }
        return hardFrequency;
    }

    public void PrintHardLocations(double[] motifCandidate) {
        double dist = 0.0;
        int lastMatchIndex = -2;
        System.out.print("\t[");
        for (int j = 0; j < this.J; ++j) {
            dist = 0.0;
            for (int l = 0; l < this.L; ++l) {
                dist += (motifCandidate[l] - this.S[j][l]) * (motifCandidate[l] - this.S[j][l]);
            }
            if (!(dist <= this.T)) continue;
            if (Math.abs(j - lastMatchIndex) > this.L / 2) {
                System.out.print(j + ",");
            }
            lastMatchIndex = j;
        }
        System.out.print("],");
        System.out.println("");
    }

    public int ComputeHardFrequency(double[][] M) {
        int hardFrequency = 0;
        for (int k = 0; k < this.K; ++k) {
            hardFrequency += this.ComputeHardFrequency(M[k]);
        }
        return hardFrequency;
    }

    public DescriptiveStatistics SegmentDistancesStats() {
        DescriptiveStatistics stat = new DescriptiveStatistics();
        double dist = 0.0;
        for (int j = 0; j < this.J; ++j) {
            for (int q = 0; q < this.J; ++q) {
                if (j == q || this.rand.nextDouble() > 1000.0 / (double)this.J) continue;
                dist = 0.0;
                for (int l = 0; l < this.L; ++l) {
                    dist += (this.S[j][l] - this.S[q][l]) * (this.S[j][l] - this.S[q][l]);
                }
                stat.addValue(dist);
            }
        }
        return stat;
    }

    public double ComputeViolations() {
        double V = 0.0;
        for (int k = 0; k < this.K; ++k) {
            for (int p = k + 1; p < this.K; ++p) {
                if (!(this.phi[k][p] < 2.0 * this.T)) continue;
                V += (1.0 - this.phi[k][p] / (2.0 * this.T)) * (1.0 - this.phi[k][p] / (2.0 * this.T));
            }
        }
        return V *= this.c_V;
    }

    public double Learn() {
        double F_grad_kl = 0.0;
        double V_grad_kl = 0.0;
        double O_grad_kl = 0.0;
        this.InitializeMethod();
        for (int iterIdx = 0; iterIdx < this.maxIter; ++iterIdx) {
            this.PreComputePerSegmentFrequencies();
            this.PreComputePairwiseMotifDistance();
            for (int k = 0; k < this.K; ++k) {
                for (int l = 0; l < this.L; ++l) {
                    F_grad_kl = 0.0;
                    for (int j = 0; j < this.J; ++j) {
                        F_grad_kl += (this.M[k][l] - this.S[j][l]) * this.perSegmentFrequencies[k][j];
                    }
                    F_grad_kl *= this.c_F;
                    V_grad_kl = 0.0;
                    for (int q = 0; q < this.K; ++q) {
                        if (!(this.phi[k][q] < 2.0 * this.T)) continue;
                        V_grad_kl += (this.phi[k][q] - 2.0 * this.T) * (this.M[k][l] - this.M[q][l]);
                    }
                    O_grad_kl = F_grad_kl - (V_grad_kl *= this.c_V);
                    double[] dArray = this.nabla[k];
                    int n = l;
                    dArray[n] = dArray[n] + O_grad_kl * O_grad_kl;
                    double[] dArray2 = this.M[k];
                    int n2 = l;
                    dArray2[n2] = dArray2[n2] + this.eta / Math.sqrt(this.nabla[k][l]) * O_grad_kl;
                }
            }
        }
        return this.ComputeHardFrequency(this.M);
    }

    public double RunParallelRandomRestarts(int numRandomRestarts) {
        ArrayList<Integer> restartIdxs = new ArrayList<Integer>();
        for (int restartIdx = 0; restartIdx < numRandomRestarts; ++restartIdx) {
            restartIdxs.add(restartIdx);
        }
        Parallel_1x0.ForEach(restartIdxs, new ForEachTask_1x0<Integer>(){

            @Override
            public void iteration(Integer restartIdx) {
                LearnMotifs lm = new LearnMotifs();
                lm.S = LearnMotifs.this.S;
                lm.J = LearnMotifs.this.J;
                lm.L = LearnMotifs.this.L;
                lm.K = LearnMotifs.this.K;
                lm.maxIter = LearnMotifs.this.maxIter;
                lm.eta = LearnMotifs.this.eta;
                lm.alpha = LearnMotifs.this.alpha;
                lm.T = LearnMotifs.this.T;
                double F = lm.Learn();
                if (F > LearnMotifs.this.bestF) {
                    LearnMotifs.this.bestF = F;
                    LearnMotifs.this.bestM = lm.M;
                }
            }
        });
        return this.bestF;
    }
}

