API_URL = "https://m.airzonecloud.com/api/v1"

MODES_CONVERTER = {
    "0": {
        "name": "stop",
        "generic": "stop",
        "description": "Stop mode",
        "range_key_prefix": "range_sp_stop_air_",
        "setpoint_key": "setpoint_air_stop",
    },
    "1": {
        "name": "auto",
        "generic": "auto",
        "description": "Automatic mode",
        "range_key_prefix": "range_sp_auto_air_",
        "setpoint_key": "setpoint_air_auto",
    },
    "2": {
        "name": "cooling",
        "generic": "cooling",
        "description": "Cooling mode",
        "range_key_prefix": "range_sp_cool_air_",
        "setpoint_key": "setpoint_air_cool",
    },
    "3": {
        "name": "heating",
        "generic": "heating",
        "description": "Heating mode",
        "range_key_prefix": "range_sp_hot_air_",
        "setpoint_key": "setpoint_air_heat",
    },
    "4": {
        "name": "ventilation",
        "generic": "ventilation",
        "description": "Ventilation mode",
        "range_key_prefix": "range_sp_vent_air_",
        "setpoint_key": "setpoint_air_vent",
    },
    "5": {
        "name": "dehumidify",
        "generic": "dehumidify",
        "description": "Dehumidifier / Dry mode",
        "range_key_prefix": "range_sp_dry_air_",
        "setpoint_key": "setpoint_air_dry",
    },
    "6": {
        "name": "emergency-heating",
        "generic": "emergency",
        "description": "Emergency heat mode",
        "range_key_prefix": "range_sp_emerheat_air_",
        "setpoint_key": "setpoint_air_emerheat",
    },
    "7": {
        "name": "air-heating",
        "generic": "heating",
        "description": "Heat air mode (only compatible systems)",
        "range_key_prefix": "range_sp_hot_air_",
        "setpoint_key": "setpoint_air_heat",
    },
    "8": {
        "name": "radiant-heating",
        "generic": "heating",
        "description": "Heat radiant mode (only compatible systems)",
        "range_key_prefix": "range_sp_hot_air_",
        "setpoint_key": "setpoint_air_heat",
    },
    "9": {
        "name": "combined-heating",
        "generic": "heating",
        "description": "Heat combined mode (only compatible systems)",
        "range_key_prefix": "range_sp_hot_air_",
        "setpoint_key": "setpoint_air_heat",
    },
    "10": {
        "name": "air-cooling",
        "generic": "cooling",
        "description": "Cooling air mode (only compatible systems)",
        "range_key_prefix": "range_sp_cool_air_",
        "setpoint_key": "setpoint_air_cool",
    },
    "11": {
        "name": "radiant-cooling",
        "generic": "cooling",
        "description": "Cooling radiant mode (only compatible systems)",
        "range_key_prefix": "range_sp_cool_air_",
        "setpoint_key": "setpoint_air_cool",
    },
    "12": {
        "name": "combined-cooling",
        "generic": "cooling",
        "description": "Cooling combined mode (only compatible systems)",
        "range_key_prefix": "range_sp_cool_air_",
        "setpoint_key": "setpoint_air_cool",
    },
}
