import enum

# TODO costs should not be hardcoded
# TODO users should be able to choose cheaper regions
cloud_instances = [
  {
    "service_provider": "Amazon",
    "instance_types": [
      # For Intel / AMD, this configuration assumes following
      # 1. No hyperthreading, for it could decrease performance
      # 2. Single process is assumed. Multi-process may squeeze out more perf in some cases
      {
        "type": "c5.large",
        "class": "c5",
        "hw" : "Intel Xeon",
        "cores" : 2,
        "hyperthreading": True,
        "usd_per_hr" : 0.085,
        "predictor_target": "c5.2xlarge",
        "predictor_num_threads": 4,
        "predictor_latency_scaling_factor": 4.0 / 1.0,
        "ram" : 4
      },
      {
        "type": "c5.xlarge",
        "class": "c5",
        "hw" : "Intel Xeon",
        "cores" : 4,
        "hyperthreading": True,
        "usd_per_hr" : 0.170,
        "predictor_target": "c5.2xlarge",
        "predictor_num_threads": 4,
        "predictor_latency_scaling_factor": 4.0 / 2.0,
        "ram": 8
      },
      {
        "type": "c5.2xlarge",
        "class": "c5",
        "hw" : "Intel Xeon",
        "cores" : 8,
        "hyperthreading": True,
        "usd_per_hr" : 0.340,
        "predictor_target": "c5.2xlarge",
        "predictor_num_threads": 4,
        "predictor_latency_scaling_factor": 1.0,
        "ram": 16
      },
      {
        "type": "c5.4xlarge",
        "class": "c5",
        "hw" : "Intel Xeon",
        "cores" : 16,
        "hyperthreading": True,
        "usd_per_hr" : 0.680,
        "predictor_target": "c5.4xlarge",
        "predictor_num_threads": 8,
        "predictor_latency_scaling_factor": 1.0,
        "ram" : 32
      },
      {
        "type": "c5.9xlarge",
        "class": "c5",
        "hw" : "Intel Xeon",
        "cores" : 36,
        "hyperthreading": True,
        "usd_per_hr" : 1.530,
        "predictor_target": "c5.9xlarge",
        "predictor_num_threads": 18,
        "predictor_latency_scaling_factor": 1.0,
        "ram": 72
      },
      {
        "type": "c5.12xlarge",
        "class": "c5",
        "hw" : "Intel Xeon",
        "cores" : 48,
        "hyperthreading": True,
        "usd_per_hr" : 2.040,
        "predictor_target": "c5.12xlarge",
        "predictor_num_threads": 24,
        "predictor_latency_scaling_factor": 1.0,
        "ram": 96
      },
      {
        "type": "c5.18xlarge",
        "class": "c5",
        "hw" : "Intel Xeon",
        "cores" : 72,
        "hyperthreading": True,
        "usd_per_hr" : 3.060,
        "predictor_target": "c5.18xlarge",
        "predictor_num_threads": 36,
        "predictor_latency_scaling_factor": 1.0,
        "ram": 144
      },
      {
        "type": "c5.24xlarge",
        "class": "c5",
        "hw" : "Intel Xeon",
        "cores" : 96,
        "hyperthreading": True,
        "usd_per_hr" : 4.080,
        "predictor_target": "c5.24xlarge",
        "predictor_num_threads": 48,
        "predictor_latency_scaling_factor": 1.0,
        "ram": 192
      },
      {
        "type": "c5a.large",
        "class": "c5a",
        "hw" : "AMD EPYC",
        "cores" : 2,
        "hyperthreading": True,
        "usd_per_hr" : 0.077,
        "predictor_target": "c5a.4xlarge",
        "predictor_num_threads": 8,
        "predictor_latency_scaling_factor": 8.0 / 1.0,
        "ram" : 4
      },
      {
        "type": "c5a.xlarge",
        "class": "c5a",
        "hw" : "AMD EPYC",
        "cores" : 4,
        "hyperthreading": True,
        "usd_per_hr" : 0.154,
        "predictor_target": "c5a.4xlarge",
        "predictor_num_threads": 8,
        "predictor_latency_scaling_factor": 8.0 / 2.0,
        "ram" : 8
      },
      {
        "type": "c5a.2xlarge",
        "class": "c5a",
        "hw" : "AMD EPYC",
        "cores" : 8,
        "hyperthreading": True,
        "usd_per_hr" : 0.308,
        "predictor_target": "c5a.4xlarge",
        "predictor_num_threads": 8,
        "predictor_latency_scaling_factor": 8.0 / 4.0,
        "ram" : 16
      },
      {
        "type": "c5a.4xlarge",
        "class": "c5a",
        "hw" : "AMD EPYC",
        "cores" : 16,
        "hyperthreading": True,
        "usd_per_hr" : 0.616,
        "predictor_target": "c5a.4xlarge",
        "predictor_num_threads": 8,
        "predictor_latency_scaling_factor": 1.0,
        "ram" : 32
      },
      {
        "type": "c5a.8xlarge",
        "class": "c5a",
        "hw" : "AMD EPYC",
        "cores" :  32,
        "hyperthreading": True,
        "usd_per_hr" : 1.232,
        "predictor_target": "c5a.8xlarge",
        "predictor_num_threads": 16,
        "predictor_latency_scaling_factor": 1.0,
        "ram" : 64
      },
      {
        "type": "c5a.12xlarge",
        "class": "c5a",
        "hw" : "AMD EPYC",
        "cores" :  48,
        "hyperthreading": True,
        "usd_per_hr" : 1.848,
        "predictor_target": "c5a.12xlarge",
        "predictor_num_threads": 24,
        "predictor_latency_scaling_factor": 1.0,
        "ram" : 96
      },
      {
        "type": "c5a.16xlarge",
        "class": "c5a",
        "hw" : "AMD EPYC",
        "cores" :  64,
        "hyperthreading": True,
        "usd_per_hr" : 2.464,
        "predictor_target": "c5a.16xlarge",
        "predictor_num_threads": 32,
        "predictor_latency_scaling_factor": 1.0,
        "ram" : 128
      },
      {
        "type": "c5a.24xlarge",
        "class": "c5a",
        "hw" : "AMD EPYC",
        "cores" :  96,
        "hyperthreading": True,
        "usd_per_hr" : 3.696,
        "predictor_target": "c5a.24xlarge",
        "predictor_num_threads": 48,
        "predictor_latency_scaling_factor": 1.0,
        "ram" : 192
      },
      {
        "type": "c6g.medium",
        "class": "c6g",
        "hw" : "Amazon Graviton2",
        "cores" : 1,
        "hyperthreading": False,
        "usd_per_hr" : 0.034,
        "predictor_target": "c6g.2xlarge",
        "predictor_num_threads": 8,
        "predictor_latency_scaling_factor": 8.0 / 1.0,
        "ram" : 2
      },
      {
        "type": "c6g.large",
        "class": "c6g",
        "hw" : "Amazon Graviton2",
        "cores" : 2,
        "hyperthreading": False,
        "usd_per_hr" : 0.068,
        "predictor_target": "c6g.2xlarge",
        "predictor_num_threads": 8,
        "predictor_latency_scaling_factor": 8.0 / 2.0,
        "ram" : 4
      },
      {
        "type": "c6g.xlarge",
        "class": "c6g",
        "hw" : "Amazon Graviton2",
        "cores" : 4,
        "hyperthreading": False,
        "usd_per_hr" : 0.136,
        "predictor_target": "c6g.2xlarge",
        "predictor_num_threads": 8,
        "predictor_latency_scaling_factor": 8.0 / 4.0,
        "ram" : 8
      },
      {
        "type": "c6g.2xlarge",
        "class": "c6g",
        "hw" : "Amazon Graviton2",
        "cores" : 8,
        "hyperthreading": False,
        "usd_per_hr" : 0.272,
        "predictor_target": "c6g.2xlarge",
        "predictor_num_threads": 8,
        "predictor_latency_scaling_factor": 1.0,
        "ram" : 16
      },
      {
        "type": "c6g.4xlarge",
        "class": "c6g",
        "hw" : "Amazon Graviton2",
        "cores" : 16,
        "hyperthreading": False,
        "usd_per_hr" : 0.544,
        "predictor_target": "c6g.4xlarge",
        "predictor_num_threads": 16,
        "predictor_latency_scaling_factor": 1.0,
        "ram" : 32
      },
      {
        "type": "c6g.8xlarge",
        "class": "c6g",
        "hw" : "Amazon Graviton2",
        "cores" : 32,
        "hyperthreading": False,
        "usd_per_hr" : 1.088,
        "predictor_target": "c6g.8xlarge",
        "predictor_num_threads": 32,
        "predictor_latency_scaling_factor": 1.0,
        "ram" : 64
      },
      {
        "type": "c6g.12xlarge",
        "class": "c6g",
        "hw" : "Amazon Graviton2",
        "cores" : 48,
        "hyperthreading": False,
        "usd_per_hr" : 1.632,
        "predictor_target": "c6g.12xlarge",
        "predictor_num_threads": 48,
        "predictor_latency_scaling_factor": 1.0,
        "ram" : 96
      },
      {
        "type": "c6g.16xlarge",
        "class": "c6g",
        "hw" : "Amazon Graviton2",
        "cores" : 64,
        "hyperthreading": False,
        "usd_per_hr" : 2.176,
        "predictor_target": "c6g.16xlarge",
        "predictor_num_threads": 64,
        "predictor_latency_scaling_factor": 1.0,
        "ram" : 128
      },
      {
        "type": "g4ad.2xlarge", #judging from declared number of cores this was from that instance
        "class": "g4ad",
        "hw" : "NVIDIA T4 GPUs",
        "cores" : 8,
        "hyperthreading": False,
        "usd_per_hr" : 0.752,
        "predictor_target": "T4",
        "predictor_num_threads": 8,
        "predictor_latency_scaling_factor": 1.0,
        "ram" : 32,
        "gpuram" : 16
      },
      {
        "type": "p3.2xlarge",
        "class": "p3",
        "hw" : "NVIDIA V100 GPUs",
        "cores" : 8,
        "hyperthreading": False,
        "usd_per_hr" : 3.06,
        "predictor_target": "v100",
        "predictor_num_threads": 8,
        "predictor_latency_scaling_factor": 1.0,
        "ram" : 61,
        "gpuram" : 32
      },
      {
        "type": "g3s.xlarge",
        "class": "g3s",
        "hw" : "NVIDIA Tesla M60 GPU",
        "cores" : 2,
        "hyperthreading": False,
        "usd_per_hr" : 0.75,
        "predictor_target": "g3s.xlarge",
        "predictor_num_threads": 4,
        "predictor_latency_scaling_factor": 1.0,
        "ram" : 30.5,
        "gpuram" : 16
      },
    ],
  },
  {
    "service_provider": "Oracle",
    "instance_types": [
      {
        "type": "VM.Standard.A1.Flex 2vCPU",
        "class": "VM.Standard.A1.Flex",
        "hw" : "Ampere Altra",
        "cores" : 2,
        "hyperthreading": False,
        "usd_per_hr" : 0.026,
        "predictor_target": "VM.Standard.A1.Flex",
        "predictor_num_threads": 2,
        "predictor_latency_scaling_factor": 1.0
      },
      {
        "type": "VM.Standard.A1.Flex 4vCPU",
        "class": "VM.Standard.A1.Flex",
        "hw" : "Ampere Altra",
        "cores" : 4,
        "hyperthreading": False,
        "usd_per_hr" : 0.052,
        "predictor_target": "VM.Standard.A1.Flex",
        "predictor_num_threads": 4,
        "predictor_latency_scaling_factor": 1.0
      },
      {
        "type": "VM.Standard.A1.Flex 8vCPU",
        "class": "VM.Standard.A1.Flex",
        "hw" : "Ampere Altra",
        "cores" : 8,
        "hyperthreading": False,
        "usd_per_hr" : 0.104,
        "predictor_target": "VM.Standard.A1.Flex",
        "predictor_num_threads": 8,
        "predictor_latency_scaling_factor": 1.0
      },
      {
        "type": "VM.Standard.A1.Flex 16vCPU",
        "class": "VM.Standard.A1.Flex",
        "hw" : "Ampere Altra",
        "cores" : 16,
        "hyperthreading": False,
        "usd_per_hr" : 0.208,
        "predictor_target": "VM.Standard.A1.Flex",
        "predictor_num_threads": 16,
        "predictor_latency_scaling_factor": 1.0
      },
      {
        "type": "VM.Standard.A1.Flex 32vCPU",
        "class": "VM.Standard.A1.Flex",
        "hw" : "Ampere Altra",
        "cores" : 32,
        "hyperthreading": False,
        "usd_per_hr" : 0.416,
        "predictor_target": "VM.Standard.A1.Flex",
        "predictor_num_threads": 32,
        "predictor_latency_scaling_factor": 1.0
      },
      {
        "type": "VM.Standard.A1.Flex 48vCPU",
        "class": "VM.Standard.A1.Flex",
        "hw" : "Ampere Altra",
        "cores" : 48,
        "hyperthreading": False,
        "usd_per_hr" : 0.624,
        "predictor_target": "VM.Standard.A1.Flex",
        "predictor_num_threads": 48,
        "predictor_latency_scaling_factor": 1.0
      },
      {
        "type": "VM.Standard.A1.Flex 64vCPU",
        "class": "VM.Standard.A1.Flex",
        "hw" : "Ampere Altra",
        "cores" : 64,
        "hyperthreading": False,
        "usd_per_hr" : 0.832,
        "predictor_target": "VM.Standard.A1.Flex",
        "predictor_num_threads": 64,
        "predictor_latency_scaling_factor": 1.0
      },
      {
        "type": "VM.Standard.A1.Flex 80vCPU",
        "class": "VM.Standard.A1.Flex",
        "hw" : "Ampere Altra",
        "cores" : 80,
        "hyperthreading": False,
        "usd_per_hr" : 1.040,
        "predictor_target": "VM.Standard.A1.Flex",
        "predictor_num_threads": 80,
        "predictor_latency_scaling_factor": 1.0
      }
    ]
  },
  {
    "service_provider": "Azure",
    "instance_types": [
      {
        "type": "Azure.StandardD2sv3",
        "class": "D2",
        "hw" : "Intel Xeon",
        "cores" : 2,
        "hyperthreading": False,
        "usd_per_hr" : 0.09,
        "predictor_target": "Azure.StandardD2sv3",
        "predictor_num_threads": 8,
        "predictor_latency_scaling_factor": 1.0,
        "ram" : 8,
        "gpuram" : 0
      },
       {
         "type": "Azure.StandardD2sv2",
         "class": "D2",
         "hw" : "Intel Xeon",
         "cores" : 2,
         "hyperthreading": False,
         "usd_per_hr" : 0.09,
         "predictor_target": "Azure.StandardDS2v2",
         "predictor_num_threads": 8,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 8,
         "gpuram" : 0
       },
       {
         "type": "Azure.StandardB2s",
         "class": "B2",
         "hw" : "Intel Xeon Platinum",
         "cores" : 2,
         "hyperthreading": False,
         "usd_per_hr" : 0.09,
         "predictor_target": "Azure.StandardB2s",
         "predictor_num_threads": 8,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 8,
         "gpuram" : 0
       },
       {
         "type": "Azure.StandardB2ms",
         "class": "B2",
         "hw" : "Intel Xeon Platinum",
         "cores" : 2,
         "hyperthreading": False,
         "usd_per_hr" : 0.09,
         "predictor_target": "Azure.StandardB2ms",
         "predictor_num_threads": 8,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 8,
         "gpuram" : 0
       },
       {
         "type": "Azure.StandardD2sv4",
         "class": "D2",
         "hw" : "Intel Xeon",
         "cores" : 2,
         "hyperthreading": False,
         "usd_per_hr" : 0.09,
         "predictor_target": "Azure.StandardD2sv4",
         "predictor_num_threads": 8,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 8,
         "gpuram" : 0
       },
       {
         "type": "Azure.StandardD2sv5",
         "class": "D2",
         "hw" : "Intel Xeon Platinum Ice Lake",
         "cores" : 2,
         "hyperthreading": False,
         "usd_per_hr" : 0.09,
         "predictor_target": "Azure.StandardD2sv5",
         "predictor_num_threads": 8,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 8,
         "gpuram" : 0
       },
       {
         "type": "Azure.StandardD1sv2",
         "class": "D1",
         "hw" : "Intel Xeon",
         "cores" : 1,
         "hyperthreading": False,
         "usd_per_hr" : 0.073,
         "predictor_target": "Azure.StandardDS1v2",
         "predictor_num_threads": 2,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 3.5,
         "gpuram" : 0
       },
       {
         "type": "Azure.StandardB4ms",
         "class": "B4",
         "hw" : "Intel Xeon Platinum",
         "cores" : 4,
         "hyperthreading": False,
         "usd_per_hr" : 0.166,
         "predictor_target": "Azure.StandardB4ms",
         "predictor_num_threads": 8,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 16,
         "gpuram" : 0
       },
       {
         "type": "Azure.StandardE2sv3",
         "class": "E2",
         "hw" : "Intel Xeon Platinum",
         "cores" : 2,
         "hyperthreading": False,
         "usd_per_hr" : 0.126,
         "predictor_target": "Azure.StandardE2sv3",
         "predictor_num_threads": 8,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 16,
         "gpuram" : 0
       },
       {
         "type": "Azure.StandardF2sv2",
         "class": "F2",
         "hw" : "Intel Xeon Platinum",
         "cores" : 2,
         "hyperthreading": False,
         "usd_per_hr" : 0.0846,
         "predictor_target": "Azure.StandardF2sv2",
         "predictor_num_threads": 8,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 4,
         "gpuram" : 0
       },
       {
         "type": "Azure.StandardDS11-1v2",
         "class": "DS11",
         "hw" : "Intel Xeon",
         "cores" : 1,
         "hyperthreading": False,
         "usd_per_hr" : 0.185,
         "predictor_target": "Azure.StandardDS11-1v2",
         "predictor_num_threads": 4,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 14,
         "gpuram" : 0
       },
       {
         "type": "Azure.StandardDS11v2",
         "class": "DS11",
         "hw" : "Intel Xeon",
         "cores" : 2,
         "hyperthreading": False,
         "usd_per_hr" : 0.185,
         "predictor_target": "Azure.StandardDS11v2",
         "predictor_num_threads": 4,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 14,
         "gpuram" : 0
       },
       {
         "type": "Azure.StandardE2sv4",
         "class": "E2",
         "hw" : "Intel Xeon Platinum",
         "cores" : 2,
         "hyperthreading": False,
         "usd_per_hr" : 0.126,
         "predictor_target": "Azure.StandardE2s_v4",
         "predictor_num_threads": 4,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 16,
         "gpuram" : 0
       },
       {
         "type": "Azure.StandardE2dsv4",
         "class": "E2",
         "hw" : "Intel Xeon Platinum",
         "cores" : 2,
         "hyperthreading": False,
         "usd_per_hr" : 0.144,
         "predictor_target": "Azure.StandardE2dsv4",
         "predictor_num_threads": 4,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 16,
         "gpuram" : 0
       },
       {
         "type": "Azure.StandardE2asv4",
         "class": "E2",
         "hw" : "Intel Xeon Platinum",
         "cores" : 2,
         "hyperthreading": False,
         "usd_per_hr" : 0.126,
         "predictor_target": "Azure.StandardE2asv4",
         "predictor_num_threads": 4,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 16,
         "gpuram" : 0
       },
       {
         "type": "Azure.StandardE2sv5",
         "class": "E2",
         "hw" : "Intel Xeon Platinum Ice Lake",
         "cores" : 2,
         "hyperthreading": False,
         "usd_per_hr" : 0.126,
         "predictor_target": "Azure.StandardE2sv5",
         "predictor_num_threads": 4,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 16,
         "gpuram" : 0
       },
       {
         "type": "Azure.StandardE2dsv5",
         "class": "E2",
         "hw" : "Intel Xeon Platinum Ice Lake",
         "cores" : 2,
         "hyperthreading": False,
         "usd_per_hr" : 0.144,
         "predictor_target": "Azure.StandardE2dsv5",
         "predictor_num_threads": 4,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 16,
         "gpuram" : 0
       },
       {
         "type": "Azure.StandardE2asv5",
         "class": "E2",
         "hw" : "Intel Xeon Platinum Ice Lake",
         "cores" : 2,
         "hyperthreading": False,
         "usd_per_hr" : 0.1129,
         "predictor_target": "Azure.StandardE2asv5",
         "predictor_num_threads": 4,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 16,
         "gpuram" : 0
       },
       {
         "type": "Azure.StandardE2adsv5",
         "class": "E2",
         "hw" : "Intel Xeon Platinum Ice Lake",
         "cores" : 2,
         "hyperthreading": False,
         "usd_per_hr" : 0.1309,
         "predictor_target": "Azure.StandardE2adsv5",
         "predictor_num_threads": 4,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 16,
         "gpuram" : 0
       },
       {
         "type": "Azure.StandardD2dsv4",
         "class": "D2",
         "hw" : "Intel Xeon Platinum",
         "cores" : 2,
         "hyperthreading": False,
         "usd_per_hr" : 0.1129,
         "predictor_target": "Azure.StandardD2dsv4",
         "predictor_num_threads": 4,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 8,
         "gpuram" : 0
       },
       {
         "type": "Azure.StandardD2asv4",
         "class": "D2",
         "hw" : "Intel Xeon Platinum",
         "cores" : 2,
         "hyperthreading": False,
         "usd_per_hr" : 0.096,
         "predictor_target": "Azure.StandardD2asv4",
         "predictor_num_threads": 4,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 8,
         "gpuram" : 0
       },
       {
         "type": "Azure.StandardD2dsv5",
         "class": "D2",
         "hw" : "Intel Xeon Platinum Ice Lake",
         "cores" : 2,
         "hyperthreading": False,
         "usd_per_hr" : 0.1129,
         "predictor_target": "Azure.StandardD2dsv5",
         "predictor_num_threads": 4,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 8,
         "gpuram" : 0
       },
       {
         "type": "Azure.StandardD2asv5",
         "class": "D2",
         "hw" : "Intel Xeon Platinum Ice Lake",
         "cores" : 2,
         "hyperthreading": False,
         "usd_per_hr" : 0.086,
         "predictor_target": "Azure.StandardD2asv5",
         "predictor_num_threads": 4,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 8,
         "gpuram" : 0
       },
       {
         "type": "Azure.StandardD2adsv5",
         "class": "D2",
         "hw" : "Intel Xeon Platinum Ice Lake",
         "cores" : 2,
         "hyperthreading": False,
         "usd_per_hr" : 0.103,
         "predictor_target": "Azure.StandardD2adsv5",
         "predictor_num_threads": 4,
         "predictor_latency_scaling_factor": 1.0,
         "ram" : 8,
         "gpuram" : 0
       },
    ]
  },
  {
     "service_provider": "Google Cloud Platform",
     "instance_types": [
        {
          "type": "C2 4 cores",
          "class": "C2",
          "hw" : "Intel Cascade Lake CPU",
          "cores" : 4,
          "hyperthreading": False,
          "usd_per_hr" : 0.17,
          "predictor_target": "gcp.C2",
          "predictor_num_threads": 8,
          "predictor_latency_scaling_factor": 1.0,
          "ram" : 16,
          "gpuram" : 0
        },
        {
          "type": "C2 8 cores",
          "class": "C2",
          "hw" : "Intel Cascade Lake CPU",
          "cores" : 8,
          "hyperthreading": False,
          "usd_per_hr" : 0.34,
          "predictor_target": "gcp.C2_8cores",
          "predictor_num_threads": 16,
          "predictor_latency_scaling_factor": 1.0,
          "ram" : 32,
          "gpuram" : 0
        },
        {
          "type": "E2 2 cores",
          "class": "E2",
          "hw" : "Intel Skylake CPU",
          "cores" : 2,
          "hyperthreading": False,
          "usd_per_hr" : 0.07,
          "predictor_target": "gcp.E2_2cores_8gb",
          "predictor_num_threads": 4,
          "predictor_latency_scaling_factor": 1.0,
          "ram" : 8,
          "gpuram" : 0
        },
        {
          "type": "E2 4 cores",
          "class": "E2",
          "hw" : "Intel Skylake CPU",
          "cores" : 4,
          "hyperthreading": False,
          "usd_per_hr" : 0.14,
          "predictor_target": "gcp.e2_4cores",
          "predictor_num_threads": 8,
          "predictor_latency_scaling_factor": 1.0,
          "ram" : 16,
          "gpuram" : 0
        },
        {
          "type": "E2 8 cores",
          "class": "E2",
          "hw" : "Intel Skylake CPU",
          "cores" : 8,
          "hyperthreading": False,
          "usd_per_hr" : 0.27,
          "predictor_target": "gcp.e2_8cores",
          "predictor_num_threads": 16,
          "predictor_latency_scaling_factor": 1.0,
          "ram" : 32,
          "gpuram" : 0
        }
     ]
  }
]

supported_hardwares = [
  {
    'name' : 'Ampere Altra',
    'vendor' : 'Ampere',
    'arch' : 'armv8.2+',
  },
  {
    'name' : 'Intel Xeon',
    'vendor' : 'Intel',
    'arch' : 'x86',
  },
  {
    'name' : 'Intel Xeon Platinum',
    'vendor' : 'Intel',
    'arch' : 'x86',
  },
  {
    'name' : 'AMD EPYC',
    'vendor' : 'AMD',
    'arch' : 'amd64',
  },
  {
    'name' : 'Amazon Graviton2',
    'vendor' : 'Amazon',
    'arch' : 'Arm64 Neoverse',
  },
  {
    'name' : 'NVIDIA T4 GPUs',
    'vendor' : 'NVIDIA T4 GPUs',
    'arch' : 'NVIDIA T4 GPUs',
  },
  {
    'name' : 'NVIDIA V100 GPUs',
    'vendor' : 'NVIDIA V100 GPUs',
    'arch' : 'NVIDIA V100 GPUs',
  },
]

supported_quants = [
  'FP32',
  'FP16',
  'INT8',
]

supported_frameworks = [
  'TENSORFLOW',
  'PYTORCH',
  'TFLITE',
  'ONNX',
]

supported_domains = [
  {
    'domain': "Computer Vision",
    'tasks': ["Classification", "Object Detection", "Image Segmentation", "Depth Estimation", "Pose Estimation" ]
  },
  {
    'domain': "NLP",
    'tasks': ["Translation", "Text Classification", "BERT" ]
  },
  {
    'domain': "Other",
    'tasks': ["Other"]
  }
]

supported_providers = ["Amazon", "Azure", "Oracle", "Google Cloud Platform"]

supported_batch_sizes = [1, 8, 16, 32, 64]

def is_domain_task_supported(domain, task):
  for supported_domain in supported_domains:
    if supported_domain["domain"] == domain:
      for supported_task in supported_domain["tasks"]:
          if supported_task == task:
            return True
  return False

def find_instances_with_config(hw, num_threads):
  instances_list = []
  for service in cloud_instances:
    for instance in service['instance_types']:
      num_cores = num_threads
      # Our prediction do not use hyperthreading(which is not efficient)
      # So, the num threads column refers to num of phyical cores used
      # Need to multiply it by 2 for looking up within instance table
      if instance['hyperthreading'] == True:
        num_cores = num_cores * 2

      if (instance['hw'] == hw and
          instance['cores'] == num_cores):
        ram = instance["ram"] if "ram" in instance else 0
        gpuram = instance["gpuram"] if "gpuram" in instance else 0
        instances_list.append((service['service_provider'], instance['type'], instance['usd_per_hr'], ram, gpuram ))
  return instances_list
