[![Run tests, lint and publish](https://github.com/Frojd/wagtail-geo-widget/actions/workflows/main.yml/badge.svg)](https://github.com/Frojd/wagtail-geo-widget/actions/workflows/main.yml) [![PyPI version](https://badge.fury.io/py/wagtailgeowidget.svg)](https://badge.fury.io/py/wagtailgeowidget)

# Wagtail-Geo-Widget

Wagtail-Geo-Widget is the complete map solution for your Wagtail site.

![Screen1](https://raw.githubusercontent.com/frojd/wagtail-geo-widget/develop/img/screen1.png)


## Features

- Supports Google Maps or any tile provider supported by Leaflet (such as Open Street Map or Mapbox)
- Real spatial support (with GeoDjango and PointField)
- Storing coordinates as strings (for no-GeoDjango setups)
- StreamField integration
- Searching with geocoding (supports Google Geocoding, Nominatim and Mapbox)
- Inline panel support
- Optional address search field
- Language support


## Documentation

- [Getting started with Google Maps](./docs/getting-started-with-google-maps.md)
- [Getting started with Leaflet](./docs/getting-started-with-leaflet.md)
- [Settings](./docs/settings.md)
- [Adding the widget to a Page](./docs/adding-to-a-page.md)
- [Integrating with GeoDjango](./docs/integrating-with-geodjango.md)
- [Adding to a StreamField](./docs/adding-to-a-streamfield.md)
- [Supported Geocoders](./docs/supported-geocoders.md)
- [FAQ](./docs/faq.md)


## Contribute

If you have ideas for improvement, please share your thoughts through an issue. We also welcome PR's

- Issue Tracker: [https://github.com/Frojd/wagtail-geo-widget/issues](https://github.com/Frojd/wagtail-geo-widget/issues)
- Source Code: [https://github.com/Frojd/wagtail-geo-widget](https://github.com/Frojd/wagtail-geo-widget)


## Security

If you believe you have found a security issue with any of our projects please email us at [security@frojd.se](security@frojd.se).


## License

Wagtail-Geo-Widget is released under the [MIT License](http://www.opensource.org/licenses/MIT).
