# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/07_tta.ipynb (unless otherwise specified).

__all__ = ['rot90', 'hflip', 'vflip', 'BaseTransform', 'HorizontalFlip', 'VerticalFlip', 'Rotate90', 'Chain',
           'Transformer', 'Compose']

# Cell
import torch
import itertools
from typing import List, Optional, Union
from fastcore.foundation import store_attr

# Cell
@torch.jit.script
def rot90(x:torch.Tensor, k:int=1):
    "rotate batch of images by 90 degrees k times"
    return torch.rot90(x, k, (2, 3))

@torch.jit.script
def hflip(x:torch.Tensor):
    "flip batch of images horizontally"
    return x.flip(3)

@torch.jit.script
def vflip(x:torch.Tensor):
    "flip batch of images vertically"
    return x.flip(2)

# Cell
class BaseTransform(torch.nn.Module):
    identity_param = None
    def __init__(self, pname: str, params: Union[list, tuple]):
        super(BaseTransform, self).__init__()
        store_attr()

# Cell
class HorizontalFlip(BaseTransform):
    "Flip images horizontally (left->right)"
    identity_param = False
    def __init__(self):
        super(HorizontalFlip, self).__init__("apply", [0, 1])

    def forward(self, x:torch.Tensor, apply:int=0, deaug:bool=False):
        if apply==1: x = hflip(x)
        return x

# Cell
class VerticalFlip(BaseTransform):
    "Flip images vertically (up->down)"
    identity_param = False
    def __init__(self):
        super().__init__("apply", [0, 1])

    def forward(self, x:torch.Tensor, apply:int=0, deaug:bool=False):
        if apply==1:
            x = vflip(x)
        return x

# Cell
class Rotate90(BaseTransform):
    "Rotate images 0/90/180/270 degrees (`angles`)"
    identity_param = 0
    def __init__(self, angles: List[int]):
        super().__init__("angle", angles)
        if self.identity_param not in angles:
            angles = [self.identity_param] + list(angles)

    @torch.jit.export
    def apply_aug_image(self, image:torch.Tensor, angle:int=0): #, **kwargs
        k = angle // 90 if angle >= 0 else (angle + 360) // 90
        #k = torch.div(angle, 90, rounding_mode='trunc') if angle >= 0 else torch.div((angle + 360), 90, rounding_mode='trunc')
        return rot90(image, k)

    def forward(self, x:torch.Tensor, angle:int=0, deaug:bool=False):
        return self.apply_aug_image(x, angle=-angle if deaug else angle)

# Cell
class Chain(torch.nn.Module):
    def __init__(self, transforms: List[BaseTransform]):
        super().__init__()
        self.transforms = torch.nn.ModuleList(transforms)

    def forward(self, x, args:List[int], deaug:bool=False):
        for i, t in enumerate(self.transforms):
            x = t(x, args[i], deaug)
        return x

# Cell
class Transformer(torch.nn.Module):
    def __init__(self, transforms: List[BaseTransform], args:List[int]):
        super(Transformer, self).__init__()
        self.aug_pipeline = Chain(transforms)
        self.deaug_pipeline = Chain(transforms[::-1])
        self.args = args

    @torch.jit.export
    def augment(self, image:torch.Tensor):
        return self.aug_pipeline(image, self.args, deaug=False)

    @torch.jit.export
    def deaugment(self, mask:torch.Tensor):
        return self.deaug_pipeline(mask, self.args[::-1], deaug=True)

# Cell
class Compose(torch.nn.Module):
    def __init__(self, aug_transforms: List[BaseTransform]):
        super(Compose, self).__init__()
        self.transform_parameters = list(itertools.product(*[t.params for t in aug_transforms]))
        self.items = torch.nn.ModuleList([Transformer(aug_transforms, args) for args in self.transform_parameters])