class Server:
    def __init__(self, json) -> None:
        self._json = json
        self.enabled = json["enabled"]
        self.lastSeen = json["lastSeen"]
        self.name = json["name"]
        self.priority = json["priority"]
        self.oldScore = json["oldScore"]
        self.avgFPS = json["avgFPS"]
        self.power = json["power"]
        self.status = json["status"]
        self.totalRendered = json["totalRendered"]
        self.renderingType = json["renderingType"]
        self.cpu = json["cpu"]
        self.gpu = json["gpu"]
        self.motionBlurCapable = json["motionBlurCapable"]
        self.usingOsuApi = json["usingOsuApi"]
        self.uhdCapable = json["uhdCapable"]
        self.avgRenderTime = json["avgRenderTime"]
        self.avgUploadTime = json["avgUploadTime"]
        self.totalAvgTime = json["totalAvgTime"]
        self.totalUploadedVideosSize = json["totalUploadedVideosSize"]

class Skin:
    def __init__(self, skinID:int, isCustomSkin:bool) -> None:
        self.id = skinID
        self.customSkin = isCustomSkin
    
    def get_skin(self, json):
        self._json = json
        self.skin = json["skin"]
        self.presentationName = json["presentationName"]
        self.url = json["url"]
        self.highResPreview = json["highResPreview"]
        self.lowResPreview = json["lowResPreview"]
        self.gridPreview = json["gridPreview"]
        self.id = json["id"]
        self.hasCursorMiddle = json["hasCursorMiddle"]
        self.author = json["author"]
        self.modified = json["modified"]
        self.version = json["version"]
        self.alphabeticalId = json["alphabeticalId"]
        self.timesUsed = json["timesUsed"]
        return self

class Render:
    def __init__(self, json, reduce) -> None:
        self._json = json
        self.date = json["date"]
        self.readableDate = json["readableDate"]
        self.renderID = json["renderID"]
        self.username = json["username"]
        self.progress = json["progress"]
        self.errorCode = json["errorCode"]
        self.removed = json["removed"]
        self.renderer = json["renderer"]
        self.description = json["description"]
        self.title = json["title"]
        if reduce == False:
            self.replayFilePath = json["replayFilePath"]
            self.replayMd5 = json["replayMd5"]
            self.videoUrl = json["videoUrl"]
            self.mapLink = json["mapLink"]
            self.mapTitle = json["mapTitle"]
            self.mapLength = json["mapLength"]
            self.drainTime = json["drainTime"]
            self.replayDifficulty = json["replayDifficulty"]
            self.replayUsername = json["replayUsername"]
            self.replayMods = json["replayMods"]
            self.mapID = json["mapID"]
            self.needToRedownload = json["needToRedownload"]
            self.resolution = json["resolution"]
            self.globalVolume = json["globalVolume"]
            self.musicVolume = json["musicVolume"]
            self.hitsoundVolume = json["hitsoundVolume"]
            self.useSkinHitsounds = json["useSkinHitsounds"]
            self.playNightcoreSamples = json["playNightcoreSamples"]
            self.showHitErrorMeter = json["showHitErrorMeter"]
            self.showUnstableRate = json["showUnstableRate"]
            self.showScore = json["showScore"]
            self.showHPBar = json["showHPBar"]
            self.showComboCounter = json["showComboCounter"]
            self.showPPCounter = json["showPPCounter"]
            self.showKeyOverlay = json["showKeyOverlay"]
            self.showScoreboard = json["showScoreboard"]
            self.showAvatarsOnScoreboard = json["showAvatarsOnScoreboard"]
            self.showBorders = json["showBorders"]
            self.showMods = json["showMods"]
            self.showResultScreen = json["showResultScreen"]
            self.showHitCounter = json["showHitCounter"]
            self.showAimErrorMeter = json["showAimErrorMeter"]
            self.customSkin = json["customSkin"]
            self.skin = json["skin"]
            self.hasCursorMiddle = json["hasCursorMiddle"]
            self.useSkinCursor = json["useSkinCursor"]
            self.useSkinColors = json["useSkinColors"]
            self.useBeatmapColors = json["useBeatmapColors"]
            self.cursorScaleToCS = json["cursorScaleToCS"]
            self.cursorRainbow = json["cursorRainbow"]
            self.cursorTrailGlow = json["cursorTrailGlow"]
            self.cursorSize = json["cursorSize"]
            self.cursorTrail = json["cursorTrail"]
            self.drawFollowPoints = json["drawFollowPoints"]
            self.drawComboNumbers = json["drawComboNumbers"]
            self.scaleToTheBeat = json["scaleToTheBeat"]
            self.sliderMerge = json["sliderMerge"]
            self.objectsRainbow = json["objectsRainbow"]
            self.objectsFlashToTheBeat = json["objectsFlashToTheBeat"]
            self.useHitCircleColor = json["useHitCircleColor"]
            self.seizureWarning = json["seizureWarning"]
            self.loadStoryboard = json["loadStoryboard"]
            self.loadVideo = json["loadVideo"]
            self.introBGDim = json["introBGDim"]
            self.inGameBGDim = json["inGameBGDim"]
            self.breakBGDim = json["breakBGDim"]
            self.BGParallax = json["BGParallax"]
            self.showDanserLogo = json["showDanserLogo"]
            self.motionBlur960fps = json["motionBlur960fps"]
            self.motionBlurForce = json["motionBlurForce"]
            self.skip = json["skip"]
            self.cursorRipples = json["cursorRipples"]
            self.sliderSnakingIn = json["sliderSnakingIn"]
            self.sliderSnakingOut = json["sliderSnakingOut"]
            self.isVerified = json["isVerified"]
            self.isBot = json["isBot"]
            self.renderStartTime = json["renderStartTime"]
            self.renderEndTime = json["renderEndTime"]
            self.renderTotalTime = json["renderTotalTime"]
            self.uploadEndTime = json["uploadEndTime"]
            self.uploadTotalTime = json["uploadTotalTime"]