"""ERRCODE data item."""
from .. import variables
from .base import DataItemBase


class ERRCODE(DataItemBase):
    """Code identifying an error.

    :Types:
       - :class:`I1 <secsgem.secs.variables.I1>`
       - :class:`I2 <secsgem.secs.variables.I2>`
       - :class:`I4 <secsgem.secs.variables.I4>`
       - :class:`I8 <secsgem.secs.variables.I8>`

    **Values**
        +-------------+---------------------------------------------------------------------+----------+
        | Value       | Description                                                         | Constant |
        +=============+=====================================================================+==========+
        | 0           | No error                                                            |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 1           | Unknown object in Object Specifier                                  |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 2           | Unknown target object type                                          |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 3           | Unknown object instance                                             |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 4           | Unknown attribute name                                              |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 5           | Read-only attribute - access denied                                 |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 6           | Unknown object type                                                 |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 7           | Invalid attribute value                                             |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 8           | Syntax error                                                        |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 9           | Verification error                                                  |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 10          | Validation error                                                    |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 11          | Object identifier in use                                            |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 12          | Parameters improperly specified                                     |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 13          | Insufficient parameters specified                                   |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 14          | Unsupported option requested                                        |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 15          | Busy                                                                |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 16          | Not available for processing                                        |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 17          | Command not valid for current state                                 |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 18          | No material altered                                                 |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 19          | Material partially processed                                        |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 20          | All material processed                                              |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 21          | Recipe specification related error                                  |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 22          | Failed during processing                                            |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 23          | Failed while not processing                                         |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 24          | Failed due to lack of material                                      |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 25          | Job aborted                                                         |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 26          | Job stopped                                                         |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 27          | Job cancelled                                                       |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 28          | Cannot change selected recipe                                       |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 29          | Unknown event                                                       |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 30          | Duplicate report ID                                                 |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 31          | Unknown data report                                                 |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 32          | Data report not linked                                              |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 33          | Unknown trace report                                                |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 34          | Duplicate trace ID                                                  |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 35          | Too many data reports                                               |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 36          | Sample period out of range                                          |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 37          | Group size too large                                                |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 38          | Recovery action currently invalid                                   |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 39          | Busy with another recovery currently unable to perform the recovery |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 40          | No active recovery action                                           |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 41          | Exception recovery failed                                           |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 42          | Exception recovery aborted                                          |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 43          | Invalid table element                                               |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 44          | Unknown table element                                               |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 45          | Cannot delete predefined                                            |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 46          | Invalid token                                                       |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 47          | Invalid parameter                                                   |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 48          | Load port does not exist                                            |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 49          | Load port already in use                                            |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 50          | Missing Carrier                                                     |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 51-63       | Reserved                                                            |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 64-32767    | User defined                                                        |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 32768       | Action will be performed at earliest opportunity                    |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 32769       | Action can not be performed now                                     |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 32770       | Action failed due to errors                                         |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 32771       | Invalid command                                                     |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 32772       | Client Already Connected                                            |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 32773       | Duplicate ClientID                                                  |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 32774       | Invalid ClientType                                                  |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 32775       | IncompatibleVersions                                                |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 32776       | Unrecognized ClientID (Client not currently connected)              |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 32777       | Failed (Completed Unsuccessfully)                                   |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 32778       | Failed (Unsafe) — External intervention required                    |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 32779       | Sensor-Detected Obstacle                                            |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 32780       | Material Not Sent                                                   |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 32781       | Material Not Received                                               |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 32782       | Material Lost                                                       |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 32783       | Hardware Failure                                                    |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 32784       | Transfer Cancelled                                                  |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 32785-32792 | reserved for future use                                             |          |
        +-------------+---------------------------------------------------------------------+----------+
        | 32793-65535 | Reserved                                                            |          |
        +-------------+---------------------------------------------------------------------+----------+

    **Used In Function**
        - :class:`SecsS03F18 <secsgem.secs.functions.SecsS03F18>`
        - :class:`SecsS05F14 <secsgem.secs.functions.SecsS05F14>`
        - :class:`SecsS05F15 <secsgem.secs.functions.SecsS05F15>`
        - :class:`SecsS05F18 <secsgem.secs.functions.SecsS05F18>`
        - :class:`SecsS14F02 <secsgem.secs.functions.SecsS14F02>`
        - :class:`SecsS14F04 <secsgem.secs.functions.SecsS14F04>`

    """

    __type__ = variables.Dynamic
    __allowedtypes__ = [
        variables.I1,
        variables.I2,
        variables.I4,
        variables.I8
    ]
