# SpectroscPy 0.3.1
# SpectroscPy is a script package developed by and containing contributions from

    # Karen Oda Hjorth Minde Dundas
    # Magnus Ringholm
    # Yann Cornation
    # Benedicte Ofstad

# The package is released under a LGPL licence.
# For questions, please contact on karen.o.dundas@uit.no

from spectroscpy import get_sorted, get_zero_padded_intensities, get_plot_values, get_x_fit
import numpy as np

a = [[1.15, 4, 6.1, 2.3, 9.8], [1.13, 4.15, 6.5, 2.4, 10], [1, 4.13, 6.11, 2.25, 10.1], \
     [1.1, 4.25, 6.2, 2.18, 10.05], [1.2, 4.16, 6.21, 2.32, 10.12]]
b = [[10, 3, 4, 2, 7], [11, 4, 5, 1, 8], [9, 2, 5, 1, 8], [10, 2, 5, 3, 6], [11, 2, 3, 3, 8]]

all_a = [ 1.15,  4.  ,  6.1 ,  2.3 ,  9.8 ,  1.13,  4.15,  6.5 ,  2.4 , 10.  ,  1.  ,  4.13,  6.11,  \
          2.25, 10.1 ,  1.1 , 4.25,  6.2 ,  2.18, 10.05,  1.2 ,  4.16,  6.21,  2.32, 10.12]
all_b = [10.,  3.,  4.,  2.,  7., 11.,  4.,  5.,  1.,  8.,  9.,  2.,  5., 1.,  8., 10.,  2.,  5.,  3.,  \
          6., 11.,  2.,  3.,  3.,  8.]

all_c = [0.02499999999999991, 0.015000000000000124, 0.04999999999999982, 0.03499999999999992, \
         0.04999999999999982, 0.02499999999999991, 0.015000000000000124, 0.04999999999999982, \
         0.03499999999999992, 0.04999999999999982, 0.02499999999999991, 0.015000000000000124, \
         0.04999999999999982, 0.03499999999999992, 0.04999999999999982, 0.02499999999999991, \
         0.015000000000000124, 0.04999999999999982, 0.03499999999999992, 0.04999999999999982, \
         0.02499999999999991, 0.015000000000000124, 0.04999999999999982, 0.03499999999999992, \
         0.04999999999999982]

s_a = [ 1.  ,  1.1 ,  1.13,  1.15,  1.2 ,  2.18,  2.25,  2.3 ,  2.32, 2.4 ,  4.  ,  4.13,  4.15,  4.16, \
        4.25, 6.1 ,  6.11,  6.2 , 6.21,  6.5 ,  9.8 , 10.  , 10.05, 10.1 , 10.12]
s_b = [ 9., 10., 11., 10., 11.,  3.,  1.,  2.,  3.,  1.,  3.,  2.,  4., 2.,  2.,  4.,  5.,  5.,  3.,  \
        5.,  7., 8.,  6.,  8.,  8.]
s_c = [0.02499999999999991, 0.02499999999999991, 0.02499999999999991, 0.02499999999999991, \
       0.02499999999999991, 0.03499999999999992, 0.03499999999999992, 0.03499999999999992, \
       0.03499999999999992, 0.03499999999999992, 0.015000000000000124, 0.015000000000000124, \
       0.015000000000000124, 0.015000000000000124, \
       0.015000000000000124,  0.04999999999999982 , 0.04999999999999982 , 0.04999999999999982 , \
       0.04999999999999982 , 0.04999999999999982 , 0.04999999999999982 , 0.04999999999999982 , \
       0.04999999999999982 , 0.04999999999999982 , 0.04999999999999982 ]

ref_x_fit = \
[ 0.9526     , 0.96183403,  0.97106807,  0.9803021 ,  0.98953614,  0.99877017,
  1.0080042  , 1.01723824,  1.02647227,  1.03570631,  1.04494034,  1.05417437,
  1.06340841 , 1.07264244,  1.08187648,  1.09111051,  1.10034454,  1.10957858,
  1.11881261 , 1.12804665,  1.13728068,  1.14651471,  1.15574875,  1.16498278,
  1.17421682 , 1.18345085,  1.19268488,  1.20191892,  1.21115295,  1.22038699,
  1.22962102 , 1.23885506 , 1.24808909,  1.25732312,  1.26655716,  1.27579119,
  1.28502523 , 1.29425926,  1.30349329,  1.31272733,  1.32196136,  1.3311954,
  1.34042943 , 1.34966346,  1.3588975 ,  1.36813153,  1.37736557,  1.3865996,
  1.39583363 , 1.40506767,  1.4143017 ,  1.42353574,  1.43276977,  1.4420038,
  1.45123784 , 1.46047187,  1.46970591,  1.47893994,  1.48817397,  1.49740801,
  1.50664204 , 1.51587608,  1.52511011,  1.53434414,  1.54357818,  1.55281221,
  1.56204625 , 1.57128028,  1.58051431,  1.58974835,  1.59898238,  1.60821642,
  1.61745045 , 1.62668448,  1.63591852,  1.64515255,  1.65438659,  1.66362062,
  1.67285465 , 1.68208869,  1.69132272,  1.70055676,  1.70979079,  1.71902482,
  1.72825886 , 1.73749289,  1.74672693,  1.75596096,  1.76519499,  1.77442903,
  1.78366306 , 1.7928971 ,  1.80213113,  1.81136517,  1.8205992 ,  1.82983323,
  1.83906727 , 1.8483013 ,  1.85753534,  1.86676937,  1.8760034 ,  1.88523744,
  1.89447147 , 1.90370551,  1.91293954,  1.92217357,  1.93140761,  1.94064164,
  1.94987568 , 1.95910971,  1.96834374,  1.97757778,  1.98681181,  1.99604585,
  2.00527988 , 2.01451391,  2.02374795,  2.03298198,  2.04221602,  2.05145005,
  2.06068408 , 2.06991812,  2.07915215,  2.08838619,  2.09762022,  2.10685425,
  2.11608829 , 2.12532232,  2.13455636,  2.14379039,  2.15302442,  2.16225846,
  2.17149249 , 2.18072653,  2.18996056,  2.19919459,  2.20842863,  2.21766266,
  2.2268967  , 2.23613073,  2.24536476,  2.2545988 ,  2.26383283,  2.27306687,
  2.2823009  , 2.29153493,  2.30076897,  2.310003  ,  2.31923704,  2.32847107,
  2.33770511 , 2.34693914,  2.35617317,  2.36540721,  2.37464124,  2.38387528,
  2.39310931 , 2.40234334,  2.41157738,  2.42081141,  2.43004545,  2.43927948,
  2.44851351 , 2.45774755,  2.46698158,  2.47621562,  2.48544965,  2.49468368,
  2.50391772 , 2.51315175,  2.52238579,  2.53161982,  2.54085385,  2.55008789,
  2.55932192 , 2.56855596,  2.57778999,  2.58702402,  2.59625806,  2.60549209,
  2.61472613 , 2.62396016,  2.63319419,  2.64242823,  2.65166226,  2.6608963,
  2.67013033 , 2.67936436,  2.6885984 ,  2.69783243,  2.70706647,  2.7163005,
  2.72553453 , 2.73476857,  2.7440026 ,  2.75323664,  2.76247067,  2.7717047,
  2.78093874 , 2.79017277,  2.79940681,  2.80864084,  2.81787487,  2.82710891,
  2.83634294 , 2.84557698,  2.85481101,  2.86404505,  2.87327908,  2.88251311,
  2.89174715 , 2.90098118,  2.91021522,  2.91944925,  2.92868328,  2.93791732,
  2.94715135 , 2.95638539,  2.96561942,  2.97485345,  2.98408749,  2.99332152,
  3.00255556 , 3.01178959,  3.02102362,  3.03025766,  3.03949169,  3.04872573,
  3.05795976 , 3.06719379,  3.07642783,  3.08566186,  3.0948959 ,  3.10412993,
  3.11336396 , 3.122598  ,  3.13183203,  3.14106607,  3.1503001 ,  3.15953413,
  3.16876817 , 3.1780022 ,  3.18723624,  3.19647027,  3.2057043 ,  3.21493834,
  3.22417237 , 3.23340641,  3.24264044,  3.25187447,  3.26110851,  3.27034254,
  3.27957658 , 3.28881061,  3.29804464,  3.30727868,  3.31651271,  3.32574675,
  3.33498078 , 3.34421481,  3.35344885,  3.36268288,  3.37191692,  3.38115095,
  3.39038498 , 3.39961902,  3.40885305,  3.41808709,  3.42732112,  3.43655516,
  3.44578919 , 3.45502322,  3.46425726,  3.47349129,  3.48272533,  3.49195936,
  3.50119339 , 3.51042743,  3.51966146,  3.5288955 ,  3.53812953,  3.54736356,
  3.5565976  , 3.56583163,  3.57506567,  3.5842997 ,  3.59353373,  3.60276777,
  3.6120018  , 3.62123584,  3.63046987,  3.6397039 ,  3.64893794,  3.65817197,
  3.66740601 , 3.67664004,  3.68587407,  3.69510811,  3.70434214,  3.71357618,
  3.72281021 , 3.73204424,  3.74127828,  3.75051231,  3.75974635,  3.76898038,
  3.77821441 , 3.78744845,  3.79668248,  3.80591652,  3.81515055,  3.82438458,
  3.83361862 , 3.84285265,  3.85208669,  3.86132072,  3.87055475,  3.87978879,
  3.88902282 , 3.89825686,  3.90749089,  3.91672492,  3.92595896,  3.93519299,
  3.94442703 , 3.95366106,  3.9628951 ,  3.97212913,  3.98136316,  3.9905972,
  3.99983123 , 4.00906527,  4.0182993 ,  4.02753333,  4.03676737,  4.0460014,
  4.05523544 , 4.06446947,  4.0737035 ,  4.08293754,  4.09217157,  4.10140561,
  4.11063964 , 4.11987367,  4.12910771,  4.13834174,  4.14757578,  4.15680981,
  4.16604384 , 4.17527788,  4.18451191,  4.19374595,  4.20297998,  4.21221401,
  4.22144805 , 4.23068208,  4.23991612,  4.24915015,  4.25838418,  4.26761822,
  4.27685225 , 4.28608629,  4.29532032,  4.30455435,  4.31378839,  4.32302242,
  4.33225646 , 4.34149049,  4.35072452,  4.35995856,  4.36919259,  4.37842663,
  4.38766066 , 4.39689469,  4.40612873,  4.41536276,  4.4245968 ,  4.43383083,
  4.44306486 , 4.4522989 ,  4.46153293,  4.47076697,  4.480001  ,  4.48923504,
  4.49846907 , 4.5077031 ,  4.51693714,  4.52617117,  4.53540521,  4.54463924,
  4.55387327 , 4.56310731,  4.57234134,  4.58157538,  4.59080941,  4.60004344,
  4.60927748 , 4.61851151,  4.62774555,  4.63697958,  4.64621361,  4.65544765,
  4.66468168 , 4.67391572,  4.68314975,  4.69238378,  4.70161782,  4.71085185,
  4.72008589 , 4.72931992,  4.73855395,  4.74778799,  4.75702202,  4.76625606,
  4.77549009 , 4.78472412,  4.79395816,  4.80319219,  4.81242623,  4.82166026,
  4.83089429 , 4.84012833,  4.84936236,  4.8585964 ,  4.86783043,  4.87706446,
  4.8862985  , 4.89553253,  4.90476657,  4.9140006 ,  4.92323463,  4.93246867,
  4.9417027  , 4.95093674,  4.96017077,  4.9694048 ,  4.97863884,  4.98787287,
  4.99710691 , 5.00634094,  5.01557497,  5.02480901,  5.03404304,  5.04327708,
  5.05251111 , 5.06174515,  5.07097918,  5.08021321,  5.08944725,  5.09868128,
  5.10791532 , 5.11714935,  5.12638338,  5.13561742,  5.14485145,  5.15408549,
  5.16331952 , 5.17255355,  5.18178759,  5.19102162,  5.20025566,  5.20948969,
  5.21872372 , 5.22795776,  5.23719179,  5.24642583,  5.25565986,  5.26489389,
  5.27412793 , 5.28336196,  5.292596  ,  5.30183003,  5.31106406,  5.3202981,
  5.32953213 , 5.33876617,  5.3480002  , 5.35723423,  5.36646827,  5.3757023,
  5.38493634 , 5.39417037,  5.4034044 ,  5.41263844,  5.42187247,  5.43110651,
  5.44034054 , 5.44957457,  5.45880861,  5.46804264,  5.47727668,  5.48651071,
  5.49574474 , 5.50497878,  5.51421281,  5.52344685,  5.53268088,  5.54191491,
  5.55114895 , 5.56038298,  5.56961702,  5.57885105,  5.58808509,  5.59731912,
  5.60655315 , 5.61578719,  5.62502122,  5.63425526,  5.64348929,  5.65272332,
  5.66195736 , 5.67119139,  5.68042543,  5.68965946,  5.69889349,  5.70812753,
  5.71736156 , 5.7265956 ,  5.73582963,  5.74506366,  5.7542977 ,  5.76353173,
  5.77276577 , 5.7819998 ,  5.79123383,  5.80046787,  5.8097019 ,  5.81893594,
  5.82816997 , 5.837404  ,  5.84663804,  5.85587207,  5.86510611,  5.87434014,
  5.88357417 , 5.89280821,  5.90204224,  5.91127628,  5.92051031,  5.92974434,
  5.93897838 , 5.94821241,  5.95744645,  5.96668048,  5.97591451,  5.98514855,
  5.99438258 , 6.00361662,  6.01285065,  6.02208468,  6.03131872,  6.04055275,
  6.04978679 , 6.05902082 , 6.06825485,  6.07748889,  6.08672292,  6.09595696,
  6.10519099 , 6.11442503,  6.12365906,  6.13289309,  6.14212713,  6.15136116,
  6.1605952  , 6.16982923,  6.17906326,  6.1882973 ,  6.19753133,  6.20676537,
  6.2159994  , 6.22523343,  6.23446747,  6.2437015 ,  6.25293554,  6.26216957,
  6.2714036  , 6.28063764,  6.28987167,  6.29910571,  6.30833974,  6.31757377,
  6.32680781 , 6.33604184,  6.34527588,  6.35450991,  6.36374394,  6.37297798,
  6.38221201 , 6.39144605,  6.40068008,  6.40991411,  6.41914815,  6.42838218,
  6.43761622 , 6.44685025,  6.45608428,  6.46531832,  6.47455235,  6.48378639,
  6.49302042 , 6.50225445,  6.51148849,  6.52072252,  6.52995656,  6.53919059,
  6.54842462 , 6.55765866,  6.56689269,  6.57612673,  6.58536076,  6.59459479,
  6.60382883 , 6.61306286,  6.6222969 ,  6.63153093,  6.64076496,  6.649999,
  6.65923303 , 6.66846707,  6.6777011 ,  6.68693514,  6.69616917,  6.7054032,
  6.71463724 , 6.72387127 , 6.73310531,  6.74233934,  6.75157337,  6.76080741,
  6.77004144 , 6.77927548 , 6.78850951,  6.79774354,  6.80697758,  6.81621161,
  6.82544565 , 6.83467968,  6.84391371,  6.85314775,  6.86238178,  6.87161582,
  6.88084985 , 6.89008388,  6.89931792,  6.90855195,  6.91778599,  6.92702002,
  6.93625405 , 6.94548809,  6.95472212,  6.96395616,  6.97319019,  6.98242422,
  6.99165826 , 7.00089229,  7.01012633,  7.01936036,  7.02859439,  7.03782843,
  7.04706246 , 7.0562965 ,  7.06553053,  7.07476456,  7.0839986 ,  7.09323263,
  7.10246667 , 7.1117007 ,  7.12093473,  7.13016877,  7.1394028 ,  7.14863684,
  7.15787087 , 7.1671049 ,  7.17633894,  7.18557297,  7.19480701,  7.20404104,
  7.21327508 , 7.22250911,  7.23174314,  7.24097718,  7.25021121,  7.25944525,
  7.26867928 , 7.27791331,  7.28714735,  7.29638138,  7.30561542,  7.31484945,
  7.32408348 , 7.33331752,  7.34255155,  7.35178559,  7.36101962,  7.37025365,
  7.37948769 , 7.38872172,  7.39795576,  7.40718979,  7.41642382,  7.42565786,
  7.43489189 , 7.44412593,  7.45335996,  7.46259399,  7.47182803,  7.48106206,
  7.4902961  , 7.49953013,  7.50876416,  7.5179982 ,  7.52723223,  7.53646627,
  7.5457003  , 7.55493433,  7.56416837,  7.5734024 ,  7.58263644,  7.59187047,
  7.6011045  , 7.61033854,  7.61957257,  7.62880661,  7.63804064,  7.64727467,
  7.65650871 , 7.66574274,  7.67497678,  7.68421081,  7.69344484,  7.70267888,
  7.71191291 , 7.72114695,  7.73038098,  7.73961502,  7.74884905,  7.75808308,
  7.76731712 , 7.77655115,  7.78578519,  7.79501922,  7.80425325,  7.81348729,
  7.82272132 , 7.83195536,  7.84118939,  7.85042342,  7.85965746,  7.86889149,
  7.87812553 , 7.88735956,  7.89659359,  7.90582763,  7.91506166,  7.9242957,
  7.93352973 , 7.94276376,  7.9519978 ,  7.96123183,  7.97046587,  7.9796999,
  7.98893393 , 7.99816797,  8.007402  ,  8.01663604,  8.02587007,  8.0351041,
  8.04433814 , 8.05357217 , 8.06280621,  8.07204024,  8.08127427,  8.09050831,
  8.09974234 , 8.10897638,  8.11821041,  8.12744444,  8.13667848,  8.14591251,
  8.15514655 , 8.16438058,  8.17361461,  8.18284865,  8.19208268,  8.20131672,
  8.21055075 , 8.21978478,  8.22901882,  8.23825285,  8.24748689,  8.25672092,
  8.26595495 , 8.27518899,  8.28442302,  8.29365706,  8.30289109,  8.31212513,
  8.32135916 , 8.33059319,  8.33982723,  8.34906126,  8.3582953 ,  8.36752933,
  8.37676336 , 8.3859974 ,  8.39523143,  8.40446547,  8.4136995 ,  8.42293353,
  8.43216757 , 8.4414016 ,  8.45063564,  8.45986967,  8.4691037 ,  8.47833774,
  8.48757177 , 8.49680581,  8.50603984,  8.51527387,  8.52450791,  8.53374194,
  8.54297598 , 8.55221001,  8.56144404,  8.57067808,  8.57991211,  8.58914615,
  8.59838018 , 8.60761421,  8.61684825,  8.62608228,  8.63531632,  8.64455035,
  8.65378438 , 8.66301842,  8.67225245,  8.68148649,  8.69072052,  8.69995455,
  8.70918859 , 8.71842262,  8.72765666,  8.73689069,  8.74612472,  8.75535876,
  8.76459279 , 8.77382683,  8.78306086,  8.79229489,  8.80152893,  8.81076296,
  8.819997   , 8.82923103,  8.83846507,  8.8476991 ,  8.85693313,  8.86616717,
  8.8754012  , 8.88463524,  8.89386927,  8.9031033 ,  8.91233734,  8.92157137,
  8.93080541 , 8.94003944,  8.94927347,  8.95850751,  8.96774154,  8.97697558,
  8.98620961 , 8.99544364,  9.00467768,  9.01391171,  9.02314575,  9.03237978,
  9.04161381 , 9.05084785,  9.06008188,  9.06931592,  9.07854995,  9.08778398,
  9.09701802 , 9.10625205,  9.11548609,  9.12472012,  9.13395415,  9.14318819,
  9.15242222 , 9.16165626,  9.17089029,  9.18012432,  9.18935836,  9.19859239,
  9.20782643 , 9.21706046,  9.22629449,  9.23552853,  9.24476256,  9.2539966,
  9.26323063 , 9.27246466,  9.2816987 ,  9.29093273,  9.30016677,  9.3094008,
  9.31863483 , 9.32786887,  9.3371029 ,  9.34633694,  9.35557097,  9.36480501,
  9.37403904 , 9.38327307,  9.39250711,  9.40174114,  9.41097518,  9.42020921,
  9.42944324 , 9.43867728,  9.44791131,  9.45714535,  9.46637938,  9.47561341,
  9.48484745 , 9.49408148,  9.50331552,  9.51254955,  9.52178358,  9.53101762,
  9.54025165 , 9.54948569,  9.55871972,  9.56795375,  9.57718779,  9.58642182,
  9.59565586 , 9.60488989,  9.61412392,  9.62335796,  9.63259199,  9.64182603,
  9.65106006 , 9.66029409,  9.66952813,  9.67876216,  9.6879962 ,  9.69723023,
  9.70646426 , 9.7156983 ,  9.72493233,  9.73416637,  9.7434004 ,  9.75263443,
  9.76186847 , 9.7711025 ,  9.78033654,  9.78957057,  9.7988046 ,  9.80803864,
  9.81727267 , 9.82650671,  9.83574074,  9.84497477,  9.85420881,  9.86344284,
  9.87267688 , 9.88191091,  9.89114494,  9.90037898,  9.90961301,  9.91884705,
  9.92808108 , 9.93731512,  9.94654915,  9.95578318,  9.96501722,  9.97425125,
  9.98348529 , 9.99271932, 10.00195335, 10.01118739, 10.02042142, 10.02965546,
 10.03888949 ,10.04812352, 10.05735756, 10.06659159, 10.07582563, 10.08505966,
 10.09429369 ,10.10352773, 10.11276176, 10.1219958 , 10.13122983, 10.14046386,
 10.1496979  ,10.15893193, 10.16816597, 10.1774    ]


def test_get_zero_padded_intensities():

    s_x = [ 1.13,  1.15,  2.3 ,  2.4 ,  4.  ,  4.15,  6.1 ,  6.5 ,  9.8 , 10.  ]
    s_y = [11., 10.,  2.,  1.,  3.,  4.,  4.,  5.,  7.,  8.]
    s_g = [0.025, 0.025, 0.035, 0.035, 0.015, 0.015, 0.05 , 0.05 , 0.05 , 0.05 ]

    x_fit = [ 1.13      ,  1.21959596,  1.30919192,  1.39878788,  1.48838384,
        1.5779798 ,  1.66757576,  1.75717172,  1.84676768,  1.93636364,
        2.0259596 ,  2.11555556,  2.20515152,  2.29474747,  2.38434343,
        2.47393939,  2.56353535,  2.65313131,  2.74272727,  2.83232323,
        2.92191919,  3.01151515,  3.10111111,  3.19070707,  3.28030303,
        3.36989899,  3.45949495,  3.54909091,  3.63868687,  3.72828283,
        3.81787879,  3.90747475,  3.99707071,  4.08666667,  4.17626263,
        4.26585859,  4.35545455,  4.44505051,  4.53464646,  4.62424242,
        4.71383838,  4.80343434,  4.8930303 ,  4.98262626,  5.07222222,
        5.16181818,  5.25141414,  5.3410101 ,  5.43060606,  5.52020202,
        5.60979798,  5.69939394,  5.7889899 ,  5.87858586,  5.96818182,
        6.05777778,  6.14737374,  6.2369697 ,  6.32656566,  6.41616162,
        6.50575758,  6.59535354,  6.68494949,  6.77454545,  6.86414141,
        6.95373737,  7.04333333,  7.13292929,  7.22252525,  7.31212121,
        7.40171717,  7.49131313,  7.58090909,  7.67050505,  7.76010101,
        7.84969697,  7.93929293,  8.02888889,  8.11848485,  8.20808081,
        8.29767677,  8.38727273,  8.47686869,  8.56646465,  8.65606061,
        8.74565657,  8.83525253,  8.92484848,  9.01444444,  9.1040404 ,
        9.19363636,  9.28323232,  9.37282828,  9.46242424,  9.5520202 ,
        9.64161616,  9.73121212,  9.82080808,  9.91040404, 10.        ]

    ref_p_x = [ 1.13      ,  1.15      ,  1.21959596,  1.30919192,  1.39878788,
        1.48838384,  1.5779798 ,  1.66757576,  1.75717172,  1.84676768,
        1.93636364,  2.0259596 ,  2.11555556,  2.20515152,  2.29474747,
        2.3       ,  2.38434343,  2.4       ,  2.47393939,  2.56353535,
        2.65313131,  2.74272727,  2.83232323,  2.92191919,  3.01151515,
        3.10111111,  3.19070707,  3.28030303,  3.36989899,  3.45949495,
        3.54909091,  3.63868687,  3.72828283,  3.81787879,  3.90747475,
        3.99707071,  4.        ,  4.08666667,  4.15      ,  4.17626263,
        4.26585859,  4.35545455,  4.44505051,  4.53464646,  4.62424242,
        4.71383838,  4.80343434,  4.8930303 ,  4.98262626,  5.07222222,
        5.16181818,  5.25141414,  5.3410101 ,  5.43060606,  5.52020202,
        5.60979798,  5.69939394,  5.7889899 ,  5.87858586,  5.96818182,
        6.05777778,  6.1       ,  6.14737374,  6.2369697 ,  6.32656566,
        6.41616162,  6.5       ,  6.50575758,  6.59535354,  6.68494949,
        6.77454545,  6.86414141,  6.95373737,  7.04333333,  7.13292929,
        7.22252525,  7.31212121,  7.40171717,  7.49131313,  7.58090909,
        7.67050505,  7.76010101,  7.84969697,  7.93929293,  8.02888889,
        8.11848485,  8.20808081,  8.29767677,  8.38727273,  8.47686869,
        8.56646465,  8.65606061,  8.74565657,  8.83525253,  8.92484848,
        9.01444444,  9.1040404 ,  9.19363636,  9.28323232,  9.37282828,
        9.46242424,  9.5520202 ,  9.64161616,  9.73121212,  9.8       ,
        9.82080808,  9.91040404, 10.        ]

    ref_p_y = [11., 10.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,
        0.,  0.,  2.,  0.,  1.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,
        0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  3.,  0.,  4.,
        0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,
        0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  4.,  0.,  0.,  0.,
        0.,  5.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,
        0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,
        0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,
        7.,  0.,  0.,  8.]

    ref_p_g = [0.025, 0.025, 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   ,
       0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.035, 0.   , 0.035,
       0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   ,
       0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   ,
       0.015, 0.   , 0.015, 0.   , 0.   , 0.   , 0.   , 0.   , 0.   ,
       0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   ,
       0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.05 , 0.   ,
       0.   , 0.   , 0.   , 0.05 , 0.   , 0.   , 0.   , 0.   , 0.   ,
       0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   ,
       0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   ,
       0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   ,
       0.   , 0.   , 0.   , 0.   , 0.   , 0.05 , 0.   , 0.   , 0.05 ]

    p_x, p_y, p_g = get_zero_padded_intensities(s_x, s_y, s_g, x_fit)

    assert np.allclose(ref_p_x, p_x)
    assert np.allclose(ref_p_y, p_y)
    assert np.allclose(ref_p_g, p_g)


def test_get_x_fit():

    x = [[1.15, 4, 6.1, 2.3, 9.8], [1.13, 4.15, 6.5, 2.4, 10]]
    s_x = [ 1.13,  1.15,  2.3 ,  2.4 ,  4.  ,  4.15,  6.1 ,  6.5 ,  9.8 , 10.  ]

    num_points = 1.0e3
    x_fit = get_x_fit(x, s_x, num_points)

    assert np.allclose(ref_x_fit, x_fit)


def test_get_sorted():

    sorted_a, sorted_b, sorted_c = get_sorted(all_a, all_b, all_c)

    assert np.allclose(s_a, sorted_a)
    assert np.allclose(s_b, sorted_b)
    assert np.allclose(s_c, sorted_c)

    c = [0.01]

    sorted_a, sorted_b, sorted_c = get_sorted(all_a, all_b, c)

    assert np.allclose(s_a, sorted_a)
    assert np.allclose(s_b, sorted_b)
    assert 1 == len(c)
    assert 0.01 == sorted_c[0]
