import opcodetools.cpu.base_cpu


OPCODES = [
    {"mnemonic": "ADC A,A",          "code": "8F",               "use": ""             },
    {"mnemonic": "ADC A,B",          "code": "88",               "use": ""             },
    {"mnemonic": "ADC A,C",          "code": "89",               "use": ""             },
    {"mnemonic": "ADC A,D",          "code": "8A",               "use": ""             },
    {"mnemonic": "ADC A,E",          "code": "8B",               "use": ""             },
    {"mnemonic": "ADC A,H",          "code": "8C",               "use": ""             },
    {"mnemonic": "ADC A,L",          "code": "8D",               "use": ""             },
    {"mnemonic": "ADC A,(HL)",       "code": "8E",               "use": ""             },
    {"mnemonic": "ADC A,(IX+i)",     "code": "DD8Eii",           "use": "i=const"      },
    {"mnemonic": "ADC A,(IY+i)",     "code": "FD8Eii",           "use": "i=const"      },
    {"mnemonic": "ADC HL,BC",        "code": "ED4A",             "use": ""             },
    {"mnemonic": "ADC HL,DE",        "code": "ED5A",             "use": ""             },
    {"mnemonic": "ADC HL,HL",        "code": "ED6A",             "use": ""             },
    {"mnemonic": "ADC HL,SP",        "code": "ED7A",             "use": ""             },
    {"mnemonic": "ADC b",            "code": "CEbb",             "use": "b=const"      },
    {"mnemonic": "ADD IX,BC",        "code": "DD09",             "use": ""             },
    {"mnemonic": "ADD IX,DE",        "code": "DD19",             "use": ""             },
    {"mnemonic": "ADD IX,IX",        "code": "DD29",             "use": ""             },
    {"mnemonic": "ADD IX,SP",        "code": "DD39",             "use": ""             },
    {"mnemonic": "ADD IY,BC",        "code": "FD09",             "use": ""             },
    {"mnemonic": "ADD IY,DE",        "code": "FD19",             "use": ""             },
    {"mnemonic": "ADD IY,IY",        "code": "FD29",             "use": ""             },
    {"mnemonic": "ADD IY,SP",        "code": "FD39",             "use": ""             },
    {"mnemonic": "ADD A,A",          "code": "87",               "use": ""             },
    {"mnemonic": "ADD A,B",          "code": "80",               "use": ""             },
    {"mnemonic": "ADD A,C",          "code": "81",               "use": ""             },
    {"mnemonic": "ADD A,D",          "code": "82",               "use": ""             },
    {"mnemonic": "ADD A,E",          "code": "83",               "use": ""             },
    {"mnemonic": "ADD A,H",          "code": "84",               "use": ""             },
    {"mnemonic": "ADD A,L",          "code": "85",               "use": ""             },
    {"mnemonic": "ADD A,IXL",        "code": "DD85",             "use": ""             },
    {"mnemonic": "ADD A,(HL)",       "code": "86",               "use": ""             },
    {"mnemonic": "ADD A,(IX+i)",     "code": "DD86ii",           "use": "i=const"      },
    {"mnemonic": "ADD A,(IY+i)",     "code": "FD86ii",           "use": "i=const"      },
    {"mnemonic": "ADD HL,BC",        "code": "09",               "use": ""             },
    {"mnemonic": "ADD HL,DE",        "code": "19",               "use": ""             },
    {"mnemonic": "ADD HL,HL",        "code": "29",               "use": ""             },
    {"mnemonic": "ADD HL,SP",        "code": "39",               "use": ""             },
    {"mnemonic": "ADD b",            "code": "C6bb",             "use": "b=const"      },
    {"mnemonic": "AND A",            "code": "A7",               "use": ""             },
    {"mnemonic": "AND B",            "code": "A0",               "use": ""             },
    {"mnemonic": "AND C",            "code": "A1",               "use": ""             },
    {"mnemonic": "AND D",            "code": "A2",               "use": ""             },
    {"mnemonic": "AND E",            "code": "A3",               "use": ""             },
    {"mnemonic": "AND H",            "code": "A4",               "use": ""             },
    {"mnemonic": "AND L",            "code": "A5",               "use": ""             },
    {"mnemonic": "AND (HL)",         "code": "A6",               "use": ""             },
    {"mnemonic": "AND (IX+i)",       "code": "DDA6ii",           "use": "i=const"      },
    {"mnemonic": "AND (IY+i)",       "code": "FDA6ii",           "use": "i=const"      },
    {"mnemonic": "AND b",            "code": "E6bb",             "use": "b=const"      },
    {"mnemonic": "OR A",             "code": "B7",               "use": ""             },
    {"mnemonic": "OR B",             "code": "B0",               "use": ""             },
    {"mnemonic": "OR C",             "code": "B1",               "use": ""             },
    {"mnemonic": "OR D",             "code": "B2",               "use": ""             },
    {"mnemonic": "OR E",             "code": "B3",               "use": ""             },
    {"mnemonic": "OR H",             "code": "B4",               "use": ""             },
    {"mnemonic": "OR L",             "code": "B5",               "use": ""             },
    {"mnemonic": "OR (HL)",          "code": "B6",               "use": ""             },
    {"mnemonic": "OR (IX+i)",        "code": "DDB6ii",           "use": "i=const"      },
    {"mnemonic": "OR (IY+i)",        "code": "FDB6ii",           "use": "i=const"      },
    {"mnemonic": "OR b",             "code": "F6bb",             "use": "b=const"      },
    {"mnemonic": "XOR A",            "code": "AF",               "use": ""             },
    {"mnemonic": "XOR B",            "code": "A8",               "use": ""             },
    {"mnemonic": "XOR C",            "code": "A9",               "use": ""             },
    {"mnemonic": "XOR D",            "code": "AA",               "use": ""             },
    {"mnemonic": "XOR E",            "code": "AB",               "use": ""             },
    {"mnemonic": "XOR H",            "code": "AC",               "use": ""             },
    {"mnemonic": "XOR L",            "code": "AD",               "use": ""             },
    {"mnemonic": "XOR (HL)",         "code": "AE",               "use": ""             },
    {"mnemonic": "XOR (IX+i)",       "code": "DDAEii",           "use": "i=const"      },
    {"mnemonic": "XOR (IY+i)",       "code": "FDAEii",           "use": "i=const"      },
    {"mnemonic": "XOR b",            "code": "EEbb",             "use": "b=const"      },
    {"mnemonic": "BIT 0,A",          "code": "CB47",             "use": ""             },
    {"mnemonic": "BIT 0,B",          "code": "CB40",             "use": ""             },
    {"mnemonic": "BIT 0,C",          "code": "CB41",             "use": ""             },
    {"mnemonic": "BIT 0,D",          "code": "CB42",             "use": ""             },
    {"mnemonic": "BIT 0,E",          "code": "CB43",             "use": ""             },
    {"mnemonic": "BIT 0,H",          "code": "CB44",             "use": ""             },
    {"mnemonic": "BIT 0,L",          "code": "CB45",             "use": ""             },
    {"mnemonic": "BIT 1,A",          "code": "CB4F",             "use": ""             },
    {"mnemonic": "BIT 1,B",          "code": "CB48",             "use": ""             },
    {"mnemonic": "BIT 1,C",          "code": "CB49",             "use": ""             },
    {"mnemonic": "BIT 1,D",          "code": "CB4A",             "use": ""             },
    {"mnemonic": "BIT 1,E",          "code": "CB4B",             "use": ""             },
    {"mnemonic": "BIT 1,H",          "code": "CB4C",             "use": ""             },
    {"mnemonic": "BIT 1,L",          "code": "CB4D",             "use": ""             },
    {"mnemonic": "BIT 2,A",          "code": "CB57",             "use": ""             },
    {"mnemonic": "BIT 2,B",          "code": "CB50",             "use": ""             },
    {"mnemonic": "BIT 2,C",          "code": "CB51",             "use": ""             },
    {"mnemonic": "BIT 2,D",          "code": "CB52",             "use": ""             },
    {"mnemonic": "BIT 2,E",          "code": "CB53",             "use": ""             },
    {"mnemonic": "BIT 2,H",          "code": "CB54",             "use": ""             },
    {"mnemonic": "BIT 2,L",          "code": "CB55",             "use": ""             },
    {"mnemonic": "BIT 3,A",          "code": "CB5F",             "use": ""             },
    {"mnemonic": "BIT 3,B",          "code": "CB58",             "use": ""             },
    {"mnemonic": "BIT 3,C",          "code": "CB59",             "use": ""             },
    {"mnemonic": "BIT 3,D",          "code": "CB5A",             "use": ""             },
    {"mnemonic": "BIT 3,E",          "code": "CB5B",             "use": ""             },
    {"mnemonic": "BIT 3,H",          "code": "CB5C",             "use": ""             },
    {"mnemonic": "BIT 3,L",          "code": "CB5D",             "use": ""             },
    {"mnemonic": "BIT 4,A",          "code": "CB67",             "use": ""             },
    {"mnemonic": "BIT 4,B",          "code": "CB60",             "use": ""             },
    {"mnemonic": "BIT 4,C",          "code": "CB61",             "use": ""             },
    {"mnemonic": "BIT 4,D",          "code": "CB62",             "use": ""             },
    {"mnemonic": "BIT 4,E",          "code": "CB63",             "use": ""             },
    {"mnemonic": "BIT 4,H",          "code": "CB64",             "use": ""             },
    {"mnemonic": "BIT 4,L",          "code": "CB65",             "use": ""             },
    {"mnemonic": "BIT 5,A",          "code": "CB6F",             "use": ""             },
    {"mnemonic": "BIT 5,B",          "code": "CB68",             "use": ""             },
    {"mnemonic": "BIT 5,C",          "code": "CB69",             "use": ""             },
    {"mnemonic": "BIT 5,D",          "code": "CB6A",             "use": ""             },
    {"mnemonic": "BIT 5,E",          "code": "CB6B",             "use": ""             },
    {"mnemonic": "BIT 5,H",          "code": "CB6C",             "use": ""             },
    {"mnemonic": "BIT 5,L",          "code": "CB6D",             "use": ""             },
    {"mnemonic": "BIT 6,A",          "code": "CB77",             "use": ""             },
    {"mnemonic": "BIT 6,B",          "code": "CB70",             "use": ""             },
    {"mnemonic": "BIT 6,C",          "code": "CB71",             "use": ""             },
    {"mnemonic": "BIT 6,D",          "code": "CB72",             "use": ""             },
    {"mnemonic": "BIT 6,E",          "code": "CB73",             "use": ""             },
    {"mnemonic": "BIT 6,H",          "code": "CB74",             "use": ""             },
    {"mnemonic": "BIT 6,L",          "code": "CB75",             "use": ""             },
    {"mnemonic": "BIT 7,A",          "code": "CB7F",             "use": ""             },
    {"mnemonic": "BIT 7,B",          "code": "CB78",             "use": ""             },
    {"mnemonic": "BIT 7,C",          "code": "CB79",             "use": ""             },
    {"mnemonic": "BIT 7,D",          "code": "CB7A",             "use": ""             },
    {"mnemonic": "BIT 7,E",          "code": "CB7B",             "use": ""             },
    {"mnemonic": "BIT 7,H",          "code": "CB7C",             "use": ""             },
    {"mnemonic": "BIT 7,L",          "code": "CB7D",             "use": ""             },
    {"mnemonic": "BIT 0,(HL)",       "code": "CB46",             "use": ""             },
    {"mnemonic": "BIT 1,(HL)",       "code": "CB4E",             "use": ""             },
    {"mnemonic": "BIT 2,(HL)",       "code": "CB56",             "use": ""             },
    {"mnemonic": "BIT 3,(HL)",       "code": "CB5E",             "use": ""             },
    {"mnemonic": "BIT 4,(HL)",       "code": "CB66",             "use": ""             },
    {"mnemonic": "BIT 5,(HL)",       "code": "CB6E",             "use": ""             },
    {"mnemonic": "BIT 6,(HL)",       "code": "CB76",             "use": ""             },
    {"mnemonic": "BIT 7,(HL)",       "code": "CB7E",             "use": ""             },
    {"mnemonic": "BIT 0,(IX+i)",     "code": "DDCBii46",         "use": "i=const"      },
    {"mnemonic": "BIT 0,(IY+i)",     "code": "FDCBii46",         "use": "i=const"      },
    {"mnemonic": "BIT 1,(IX+i)",     "code": "DDCBii4E",         "use": "i=const"      },
    {"mnemonic": "BIT 1,(IY+i)",     "code": "FDCBii4E",         "use": "i=const"      },
    {"mnemonic": "BIT 2,(IX+i)",     "code": "DDCBii56",         "use": "i=const"      },
    {"mnemonic": "BIT 2,(IY+i)",     "code": "FDCBii56",         "use": "i=const"      },
    {"mnemonic": "BIT 3,(IX+i)",     "code": "DDCBii5E",         "use": "i=const"      },
    {"mnemonic": "BIT 3,(IY+i)",     "code": "FDCBii5E",         "use": "i=const"      },
    {"mnemonic": "BIT 4,(IX+i)",     "code": "DDCBii66",         "use": "i=const"      },
    {"mnemonic": "BIT 4,(IY+i)",     "code": "FDCBii66",         "use": "i=const"      },
    {"mnemonic": "BIT 5,(IX+i)",     "code": "DDCBii6E",         "use": "i=const"      },
    {"mnemonic": "BIT 5,(IY+i)",     "code": "FDCBii6E",         "use": "i=const"      },
    {"mnemonic": "BIT 6,(IX+i)",     "code": "DDCBii76",         "use": "i=const"      },
    {"mnemonic": "BIT 6,(IY+i)",     "code": "FDCBii76",         "use": "i=const"      },
    {"mnemonic": "BIT 7,(IX+i)",     "code": "DDCBii7E",         "use": "i=const"      },
    {"mnemonic": "BIT 7,(IY+i)",     "code": "FDCBii7E",         "use": "i=const"      },
    {"mnemonic": "CALL t",           "code": "CDt0t1",           "use": "t=code"       },
    {"mnemonic": "CALL NZ,t",        "code": "C4t0t1",           "use": "t=code"       },
    {"mnemonic": "CALL Z,t",         "code": "CCt0t1",           "use": "t=code"       },
    {"mnemonic": "CALL NC,t",        "code": "D4t0t1",           "use": "t=code"       },
    {"mnemonic": "CALL C,t",         "code": "DCt0t1",           "use": "t=code"       },
    {"mnemonic": "CALL C,t",         "code": "FDDCt0t1",         "use": "t=code"       },
    {"mnemonic": "CALL PO,t",        "code": "E4t0t1",           "use": "t=code"       },
    {"mnemonic": "CALL PE,t",        "code": "ECt0t1",           "use": "t=code"       },
    {"mnemonic": "CALL P,t",         "code": "F4t0t1",           "use": "t=code"       },
    {"mnemonic": "CALL M,t",         "code": "FCt0t1",           "use": "t=code"       },
    {"mnemonic": "CCF",              "code": "3F",               "use": ""             },
    {"mnemonic": "CP A",             "code": "BF",               "use": ""             },
    {"mnemonic": "CP B",             "code": "B8",               "use": ""             },
    {"mnemonic": "CP C",             "code": "B9",               "use": ""             },
    {"mnemonic": "CP D",             "code": "BA",               "use": ""             },
    {"mnemonic": "CP E",             "code": "BB",               "use": ""             },
    {"mnemonic": "CP H",             "code": "BC",               "use": ""             },
    {"mnemonic": "CP L",             "code": "BD",               "use": ""             },
    {"mnemonic": "CP (HL)",          "code": "BE",               "use": ""             },
    {"mnemonic": "CP (IX+i)",        "code": "DDBEii",           "use": "i=const"      },
    {"mnemonic": "CP (IY+i)",        "code": "FDBEii",           "use": "i=const"      },
    {"mnemonic": "CP b",             "code": "FEbb",             "use": "b=const"      },
    {"mnemonic": "CPD",              "code": "EDA9",             "use": ""             },
    {"mnemonic": "CPI",              "code": "EDA1",             "use": ""             },
    {"mnemonic": "CPDR",             "code": "EDB9",             "use": ""             },
    {"mnemonic": "CPIR",             "code": "EDB1",             "use": ""             },
    {"mnemonic": "DAA",              "code": "27",               "use": ""             },
    {"mnemonic": "DI",               "code": "F3",               "use": ""             },
    {"mnemonic": "EI",               "code": "FB",               "use": ""             },
    {"mnemonic": "DJNZ r",           "code": "10rr",             "use": "r=code_pcr"   },
    {"mnemonic": "EX AF,AF'",        "code": "08",               "use": ""             },
    {"mnemonic": "EXX",              "code": "D9",               "use": ""             },
    {"mnemonic": "HALT",             "code": "76",               "use": ""             },
    {"mnemonic": "IM 0",             "code": "ED46",             "use": ""             },
    {"mnemonic": "IM 1",             "code": "ED56",             "use": ""             },
    {"mnemonic": "IM 2",             "code": "ED5E",             "use": ""             },
    {"mnemonic": "IND",              "code": "EDAA",             "use": ""             },
    {"mnemonic": "INDR",             "code": "EDBA",             "use": ""             },
    {"mnemonic": "INI",              "code": "EDA2",             "use": ""             },
    {"mnemonic": "INIR",             "code": "EDB2",             "use": ""             },
    {"mnemonic": "LDDR",             "code": "EDB8",             "use": ""             },
    {"mnemonic": "LDIR",             "code": "EDB0",             "use": ""             },
    {"mnemonic": "OTDR",             "code": "EDBB",             "use": ""             },
    {"mnemonic": "OTIR",             "code": "EDB3",             "use": ""             },
    {"mnemonic": "OUTD",             "code": "EDAB",             "use": ""             },
    {"mnemonic": "OUTI",             "code": "EDA3",             "use": ""             },
    {"mnemonic": "RETI",             "code": "ED4D",             "use": ""             },
    {"mnemonic": "RETN",             "code": "ED45",             "use": ""             },
    {"mnemonic": "RLD",              "code": "ED6F",             "use": ""             },
    {"mnemonic": "RRD",              "code": "ED67",             "use": ""             },
    {"mnemonic": "CPL",              "code": "2F",               "use": ""             },
    {"mnemonic": "DEC A",            "code": "3D",               "use": ""             },
    {"mnemonic": "DEC B",            "code": "05",               "use": ""             },
    {"mnemonic": "DEC C",            "code": "0D",               "use": ""             },
    {"mnemonic": "DEC D",            "code": "15",               "use": ""             },
    {"mnemonic": "DEC E",            "code": "1D",               "use": ""             },
    {"mnemonic": "DEC H",            "code": "25",               "use": ""             },
    {"mnemonic": "DEC L",            "code": "2D",               "use": ""             },
    {"mnemonic": "DEC (HL)",         "code": "35",               "use": ""             },
    {"mnemonic": "DEC (IX+i)",       "code": "DD35ii",           "use": "i=constw"     },
    {"mnemonic": "DEC (IY+i)",       "code": "FD35ii",           "use": "i=constw"     },
    {"mnemonic": "DEC BC",           "code": "0B",               "use": ""             },
    {"mnemonic": "DEC DE",           "code": "1B",               "use": ""             },
    {"mnemonic": "DEC HL",           "code": "2B",               "use": ""             },
    {"mnemonic": "DEC SP",           "code": "3B",               "use": ""             },
    {"mnemonic": "DEC IX",           "code": "DD2B",             "use": ""             },
    {"mnemonic": "DEC IY",           "code": "FD2B",             "use": ""             },
    {"mnemonic": "EX DE,HL",         "code": "EB",               "use": ""             },
    {"mnemonic": "EX (SP),HL",       "code": "E3",               "use": ""             },
    {"mnemonic": "EX (SP),IX",       "code": "DDE3",             "use": ""             },
    {"mnemonic": "EX (SP),IY",       "code": "FDE3",             "use": ""             },
    {"mnemonic": "IN A,(C)",         "code": "ED78",             "use": ""             },
    {"mnemonic": "IN B,(C)",         "code": "ED40",             "use": ""             },
    {"mnemonic": "IN C,(C)",         "code": "ED48",             "use": ""             },
    {"mnemonic": "IN D,(C)",         "code": "ED50",             "use": ""             },
    {"mnemonic": "IN E,(C)",         "code": "ED58",             "use": ""             },
    {"mnemonic": "IN H,(C)",         "code": "ED60",             "use": ""             },
    {"mnemonic": "IN L,(C)",         "code": "ED68",             "use": ""             },
    {"mnemonic": "IN A,(o)",         "code": "DBoo",             "use": "o=port_r"     },
    {"mnemonic": "INC A",            "code": "3C",               "use": ""             },
    {"mnemonic": "INC B",            "code": "04",               "use": ""             },
    {"mnemonic": "INC C",            "code": "0C",               "use": ""             },
    {"mnemonic": "INC D",            "code": "14",               "use": ""             },
    {"mnemonic": "INC E",            "code": "1C",               "use": ""             },
    {"mnemonic": "INC H",            "code": "24",               "use": ""             },
    {"mnemonic": "INC L",            "code": "2C",               "use": ""             },
    {"mnemonic": "INC (HL)",         "code": "34",               "use": ""             },
    {"mnemonic": "INC (IX+i)",       "code": "DD34ii",           "use": "i=constw"     },
    {"mnemonic": "INC (IY+i)",       "code": "FD34ii",           "use": "i=constw"     },
    {"mnemonic": "INC BC",           "code": "03",               "use": ""             },
    {"mnemonic": "INC DE",           "code": "13",               "use": ""             },
    {"mnemonic": "INC HL",           "code": "23",               "use": ""             },
    {"mnemonic": "INC SP",           "code": "33",               "use": ""             },
    {"mnemonic": "INC IX",           "code": "DD23",             "use": ""             },
    {"mnemonic": "INC IY",           "code": "FD23",             "use": ""             },
    {"mnemonic": "JP (HL)",          "code": "E9",               "use": ""             },
    {"mnemonic": "JP (IX)",          "code": "DDE9",             "use": ""             },
    {"mnemonic": "JP (IY)",          "code": "FDE9",             "use": ""             },
    {"mnemonic": "JP t",             "code": "C3t0t1",           "use": "t=code"       },
    {"mnemonic": "JP NZ,t",          "code": "C2t0t1",           "use": "t=code"       },
    {"mnemonic": "JP Z,t",           "code": "CAt0t1",           "use": "t=code"       },
    {"mnemonic": "JP NC,t",          "code": "D2t0t1",           "use": "t=code"       },
    {"mnemonic": "JP C,t",           "code": "DAt0t1",           "use": "t=code"       },
    {"mnemonic": "JP PO,t",          "code": "E2t0t1",           "use": "t=code"       },
    {"mnemonic": "JP PE,t",          "code": "EAt0t1",           "use": "t=code"       },
    {"mnemonic": "JP P,t",           "code": "F2t0t1",           "use": "t=code"       },
    {"mnemonic": "JP M,t",           "code": "FAt0t1",           "use": "t=code"       },
    {"mnemonic": "JR r",             "code": "18rr",             "use": "r=code_pcr"   },
    {"mnemonic": "JR NZ,r",          "code": "20rr",             "use": "r=code_pcr"   },
    {"mnemonic": "JR Z,r",           "code": "28rr",             "use": "r=code_pcr"   },
    {"mnemonic": "JR NC,r",          "code": "30rr",             "use": "r=code_pcr"   },
    {"mnemonic": "JR C,r",           "code": "38rr",             "use": "r=code_pcr"   },
    {"mnemonic": "LD A,A",           "code": "7F",               "use": ""             },
    {"mnemonic": "LD A,B",           "code": "78",               "use": ""             },
    {"mnemonic": "LD A,C",           "code": "79",               "use": ""             },
    {"mnemonic": "LD A,D",           "code": "7A",               "use": ""             },
    {"mnemonic": "LD A,E",           "code": "7B",               "use": ""             },
    {"mnemonic": "LD A,H",           "code": "7C",               "use": ""             },
    {"mnemonic": "LD A,L",           "code": "7D",               "use": ""             },
    {"mnemonic": "LD A,IXL",         "code": "DD7D",             "use": ""             },
    {"mnemonic": "LD IXH,A",         "code": "FD6F",             "use": ""             },
    {"mnemonic": "LD A,(HL)",        "code": "7E",               "use": ""             },
    {"mnemonic": "LD A,(BC)",        "code": "0A",               "use": ""             },
    {"mnemonic": "LD A,(DE)",        "code": "1A",               "use": ""             },
    {"mnemonic": "LD A,(IX+i)",      "code": "DD7Eii",           "use": "i=const"      },
    {"mnemonic": "LD A,(IY+i)",      "code": "FD7Eii",           "use": "i=const"      },
    {"mnemonic": "LD B,A",           "code": "47",               "use": ""             },
    {"mnemonic": "LD B,B",           "code": "40",               "use": ""             },
    {"mnemonic": "LD B,C",           "code": "41",               "use": ""             },
    {"mnemonic": "LD B,D",           "code": "42",               "use": ""             },
    {"mnemonic": "LD B,E",           "code": "43",               "use": ""             },
    {"mnemonic": "LD B,H",           "code": "44",               "use": ""             },
    {"mnemonic": "LD B,L",           "code": "45",               "use": ""             },
    {"mnemonic": "LD B,(HL)",        "code": "46",               "use": ""             },
    {"mnemonic": "LD B,(IX+i)",      "code": "DD46ii",           "use": "i=const"      },
    {"mnemonic": "LD B,(IY+i)",      "code": "FD46ii",           "use": "i=const"      },
    {"mnemonic": "LD C,A",           "code": "4F",               "use": ""             },
    {"mnemonic": "LD C,B",           "code": "48",               "use": ""             },
    {"mnemonic": "LD C,C",           "code": "49",               "use": ""             },
    {"mnemonic": "LD C,D",           "code": "4A",               "use": ""             },
    {"mnemonic": "LD C,E",           "code": "4B",               "use": ""             },
    {"mnemonic": "LD C,H",           "code": "4C",               "use": ""             },
    {"mnemonic": "LD C,L",           "code": "4D",               "use": ""             },
    {"mnemonic": "LD C,(HL)",        "code": "4E",               "use": ""             },
    {"mnemonic": "LD C,(IX+i)",      "code": "DD4Eii",           "use": "i=const"      },
    {"mnemonic": "LD C,(IY+i)",      "code": "FD4Eii",           "use": "i=const"      },
    {"mnemonic": "LD D,A",           "code": "57",               "use": ""             },
    {"mnemonic": "LD D,B",           "code": "50",               "use": ""             },
    {"mnemonic": "LD D,C",           "code": "51",               "use": ""             },
    {"mnemonic": "LD D,D",           "code": "52",               "use": ""             },
    {"mnemonic": "LD D,E",           "code": "53",               "use": ""             },
    {"mnemonic": "LD D,H",           "code": "54",               "use": ""             },
    {"mnemonic": "LD D,L",           "code": "55",               "use": ""             },
    {"mnemonic": "LD D,(HL)",        "code": "56",               "use": ""             },
    {"mnemonic": "LD D,(IX+i)",      "code": "DD56ii",           "use": "i=const"      },
    {"mnemonic": "LD D,(IY+i)",      "code": "FD56ii",           "use": "i=const"      },
    {"mnemonic": "LD E,A",           "code": "5F",               "use": ""             },
    {"mnemonic": "LD E,B",           "code": "58",               "use": ""             },
    {"mnemonic": "LD E,C",           "code": "59",               "use": ""             },
    {"mnemonic": "LD E,D",           "code": "5A",               "use": ""             },
    {"mnemonic": "LD E,E",           "code": "5B",               "use": ""             },
    {"mnemonic": "LD E,H",           "code": "5C",               "use": ""             },
    {"mnemonic": "LD E,L",           "code": "5D",               "use": ""             },
    {"mnemonic": "LD E,(HL)",        "code": "5E",               "use": ""             },
    {"mnemonic": "LD E,(IX+i)",      "code": "DD5Eii",           "use": "i=const"      },
    {"mnemonic": "LD E,(IY+i)",      "code": "FD5Eii",           "use": "i=const"      },
    {"mnemonic": "LD H,A",           "code": "67",               "use": ""             },
    {"mnemonic": "LD H,B",           "code": "60",               "use": ""             },
    {"mnemonic": "LD H,C",           "code": "61",               "use": ""             },
    {"mnemonic": "LD H,D",           "code": "62",               "use": ""             },
    {"mnemonic": "LD IYH,D",         "code": "FD62",             "use": ""             },
    {"mnemonic": "LD H,E",           "code": "63",               "use": ""             },
    {"mnemonic": "LD H,H",           "code": "64",               "use": ""             },
    {"mnemonic": "LD H,L",           "code": "65",               "use": ""             },
    {"mnemonic": "LD H,(HL)",        "code": "66",               "use": ""             },
    {"mnemonic": "LD H,(IX+i)",      "code": "DD66ii",           "use": "i=const"      },
    {"mnemonic": "LD H,(IY+i)",      "code": "FD66ii",           "use": "i=const"      },
    {"mnemonic": "LD L,A",           "code": "6F",               "use": ""             },
    {"mnemonic": "LD IXL,A",         "code": "DD6F",             "use": ""             },
    {"mnemonic": "LD L,B",           "code": "68",               "use": ""             },
    {"mnemonic": "LD L,C",           "code": "69",               "use": ""             },
    {"mnemonic": "LD L,D",           "code": "6A",               "use": ""             },
    {"mnemonic": "LD L,E",           "code": "6B",               "use": ""             },
    {"mnemonic": "LD L,H",           "code": "6C",               "use": ""             },
    {"mnemonic": "LD L,L",           "code": "6D",               "use": ""             },
    {"mnemonic": "LD L,(HL)",        "code": "6E",               "use": ""             },
    {"mnemonic": "LD L,(IX+i)",      "code": "DD6Eii",           "use": "i=const"      },
    {"mnemonic": "LD L,(IY+i)",      "code": "FD6Eii",           "use": "i=const"      },
    {"mnemonic": "LD (HL),A",        "code": "77",               "use": ""             },
    {"mnemonic": "LD (HL),B",        "code": "70",               "use": ""             },
    {"mnemonic": "LD (HL),C",        "code": "71",               "use": ""             },
    {"mnemonic": "LD (HL),D",        "code": "72",               "use": ""             },
    {"mnemonic": "LD (HL),E",        "code": "73",               "use": ""             },
    {"mnemonic": "LD (HL),H",        "code": "74",               "use": ""             },
    {"mnemonic": "LD (HL),L",        "code": "75",               "use": ""             },
    {"mnemonic": "LD (IX+i),A",      "code": "DD77ii",           "use": "i=const"      },
    {"mnemonic": "LD (IX+i),B",      "code": "DD70ii",           "use": "i=const"      },
    {"mnemonic": "LD (IX+i),C",      "code": "DD71ii",           "use": "i=const"      },
    {"mnemonic": "LD (IX+i),D",      "code": "DD72ii",           "use": "i=const"      },
    {"mnemonic": "LD (IX+i),E",      "code": "DD73ii",           "use": "i=const"      },
    {"mnemonic": "LD (IX+i),H",      "code": "DD74ii",           "use": "i=const"      },
    {"mnemonic": "LD (IX+i),L",      "code": "DD75ii",           "use": "i=const"      },
    {"mnemonic": "LD (IY+i),A",      "code": "FD77ii",           "use": "i=const"      },
    {"mnemonic": "LD (IY+i),B",      "code": "FD70ii",           "use": "i=const"      },
    {"mnemonic": "LD (IY+i),C",      "code": "FD71ii",           "use": "i=const"      },
    {"mnemonic": "LD (IY+i),D",      "code": "FD72ii",           "use": "i=const"      },
    {"mnemonic": "LD (IY+i),E",      "code": "FD73ii",           "use": "i=const"      },
    {"mnemonic": "LD (IY+i),H",      "code": "FD74ii",           "use": "i=const"      },
    {"mnemonic": "LD (IY+i),L",      "code": "FD75ii",           "use": "i=const"      },
    {"mnemonic": "LD (BC),A",        "code": "02",               "use": ""             },
    {"mnemonic": "LD (DE),A",        "code": "12",               "use": ""             },
    {"mnemonic": "LD SP,HL",         "code": "F9",               "use": ""             },
    {"mnemonic": "LD SP,IX",         "code": "DDF9",             "use": ""             },
    {"mnemonic": "LD SP,IY",         "code": "FDF9",             "use": ""             },
    {"mnemonic": "LD I,A",           "code": "ED47",             "use": ""             },
    {"mnemonic": "LD A,I",           "code": "ED57",             "use": ""             },
    {"mnemonic": "LD R,A",           "code": "ED4F",             "use": ""             },
    {"mnemonic": "LD A,R",           "code": "ED5F",             "use": ""             },
    {"mnemonic": "LD A,(t)",         "code": "3At0t1",           "use": "t=data_r"     },
    {"mnemonic": "LD HL,(t)",        "code": "2At0t1",           "use": "t=data_r"     },
    {"mnemonic": "LD BC,(t)",        "code": "ED4Bt0t1",         "use": "t=data_r"     },
    {"mnemonic": "LD DE,(t)",        "code": "ED5Bt0t1",         "use": "t=data_r"     },
    {"mnemonic": "LD HL,(t)",        "code": "ED6Bt0t1",         "use": "t=data_r"     },
    {"mnemonic": "LD SP,(t)",        "code": "ED7Bt0t1",         "use": "t=data_r"     },
    {"mnemonic": "LD IX,(t)",        "code": "DD2At0t1",         "use": "t=data_r"     },
    {"mnemonic": "LD IY,(t)",        "code": "FD2At0t1",         "use": "t=data_r"     },
    {"mnemonic": "LD (t),A",         "code": "32t0t1",           "use": "t=data_w"     },
    {"mnemonic": "LD (t),HL",        "code": "22t0t1",           "use": "t=data_w"     },
    {"mnemonic": "LD (t),BC",        "code": "ED43t0t1",         "use": "t=data_w"     },
    {"mnemonic": "LD (t),DE",        "code": "ED53t0t1",         "use": "t=data_w"     },
    {"mnemonic": "LD (t),IX",        "code": "DD22t0t1",         "use": "t=data_w"     },
    {"mnemonic": "LD (t),IY",        "code": "FD22t0t1",         "use": "t=data_w"     },
    {"mnemonic": "LD (t),SP",        "code": "ED73t0t1",         "use": "t=data_w"     },
    {"mnemonic": "LD (IX+i),b",      "code": "DD36iibb",         "use": "i=const,b=const" },
    {"mnemonic": "LD (IY+i),b",      "code": "FD36iibb",         "use": "i=const,b=const" },
    {"mnemonic": "LD BC,w",          "code": "01w0w1",           "use": "w=const"      },
    {"mnemonic": "LD DE,w",          "code": "11w0w1",           "use": "w=const"      },
    {"mnemonic": "LD HL,w",          "code": "21w0w1",           "use": "w=const"      },
    {"mnemonic": "LD SP,w",          "code": "31w0w1",           "use": "w=const"      },
    {"mnemonic": "LD IX,w",          "code": "DD21w0w1",         "use": "w=const"      },
    {"mnemonic": "LD IY,w",          "code": "FD21w0w1",         "use": "w=const"      },
    {"mnemonic": "LD A,b",           "code": "3Ebb",             "use": "b=const"      },
    {"mnemonic": "LD B,b",           "code": "06bb",             "use": "b=const"      },
    {"mnemonic": "LD C,b",           "code": "0Ebb",             "use": "b=const"      },
    {"mnemonic": "LD D,b",           "code": "16bb",             "use": "b=const"      },
    {"mnemonic": "LD E,b",           "code": "1Ebb",             "use": "b=const"      },
    {"mnemonic": "LD H,b",           "code": "26bb",             "use": "b=const"      },
    {"mnemonic": "LD L,b",           "code": "2Ebb",             "use": "b=const"      },
    {"mnemonic": "LD (HL),b",        "code": "36bb",             "use": "b=const"      },
    {"mnemonic": "LDD",              "code": "EDA8",             "use": ""             },
    {"mnemonic": "LDI",              "code": "EDA0",             "use": ""             },
    {"mnemonic": "NEG",              "code": "ED44",             "use": ""             },
    {"mnemonic": "NOP",              "code": "00",               "use": ""             },
    {"mnemonic": "OUT (C),A",        "code": "ED79",             "use": ""             },
    {"mnemonic": "OUT (C),B",        "code": "ED41",             "use": ""             },
    {"mnemonic": "OUT (C),C",        "code": "ED49",             "use": ""             },
    {"mnemonic": "OUT (C),D",        "code": "ED51",             "use": ""             },
    {"mnemonic": "OUT (C),E",        "code": "ED59",             "use": ""             },
    {"mnemonic": "OUT (C),H",        "code": "ED61",             "use": ""             },
    {"mnemonic": "OUT (C),L",        "code": "ED69",             "use": ""             },
    {"mnemonic": "OUT (o),A",        "code": "D3oo",             "use": "o=port_w"     },
    {"mnemonic": "RES 0,A",          "code": "CB87",             "use": ""             },
    {"mnemonic": "RES 0,B",          "code": "CB80",             "use": ""             },
    {"mnemonic": "RES 0,C",          "code": "CB81",             "use": ""             },
    {"mnemonic": "RES 0,D",          "code": "CB82",             "use": ""             },
    {"mnemonic": "RES 0,E",          "code": "CB83",             "use": ""             },
    {"mnemonic": "RES 0,H",          "code": "CB84",             "use": ""             },
    {"mnemonic": "RES 0,L",          "code": "CB85",             "use": ""             },
    {"mnemonic": "RES 1,A",          "code": "CB8F",             "use": ""             },
    {"mnemonic": "RES 1,B",          "code": "CB88",             "use": ""             },
    {"mnemonic": "RES 1,C",          "code": "CB89",             "use": ""             },
    {"mnemonic": "RES 1,D",          "code": "CB8A",             "use": ""             },
    {"mnemonic": "RES 1,E",          "code": "CB8B",             "use": ""             },
    {"mnemonic": "RES 1,H",          "code": "CB8C",             "use": ""             },
    {"mnemonic": "RES 1,L",          "code": "CB8D",             "use": ""             },
    {"mnemonic": "RES 2,A",          "code": "CB97",             "use": ""             },
    {"mnemonic": "RES 2,B",          "code": "CB90",             "use": ""             },
    {"mnemonic": "RES 2,C",          "code": "CB91",             "use": ""             },
    {"mnemonic": "RES 2,D",          "code": "CB92",             "use": ""             },
    {"mnemonic": "RES 2,E",          "code": "CB93",             "use": ""             },
    {"mnemonic": "RES 2,H",          "code": "CB94",             "use": ""             },
    {"mnemonic": "RES 2,L",          "code": "CB95",             "use": ""             },
    {"mnemonic": "RES 3,A",          "code": "CB9F",             "use": ""             },
    {"mnemonic": "RES 3,B",          "code": "CB98",             "use": ""             },
    {"mnemonic": "RES 3,C",          "code": "CB99",             "use": ""             },
    {"mnemonic": "RES 3,D",          "code": "CB9A",             "use": ""             },
    {"mnemonic": "RES 3,E",          "code": "CB9B",             "use": ""             },
    {"mnemonic": "RES 3,H",          "code": "CB9C",             "use": ""             },
    {"mnemonic": "RES 3,L",          "code": "CB9D",             "use": ""             },
    {"mnemonic": "RES 4,A",          "code": "CBA7",             "use": ""             },
    {"mnemonic": "RES 4,B",          "code": "CBA0",             "use": ""             },
    {"mnemonic": "RES 4,C",          "code": "CBA1",             "use": ""             },
    {"mnemonic": "RES 4,D",          "code": "CBA2",             "use": ""             },
    {"mnemonic": "RES 4,E",          "code": "CBA3",             "use": ""             },
    {"mnemonic": "RES 4,H",          "code": "CBA4",             "use": ""             },
    {"mnemonic": "RES 4,L",          "code": "CBA5",             "use": ""             },
    {"mnemonic": "RES 5,A",          "code": "CBAF",             "use": ""             },
    {"mnemonic": "RES 5,B",          "code": "CBA8",             "use": ""             },
    {"mnemonic": "RES 5,C",          "code": "CBA9",             "use": ""             },
    {"mnemonic": "RES 5,D",          "code": "CBAA",             "use": ""             },
    {"mnemonic": "RES 5,E",          "code": "CBAB",             "use": ""             },
    {"mnemonic": "RES 5,H",          "code": "CBAC",             "use": ""             },
    {"mnemonic": "RES 5,L",          "code": "CBAD",             "use": ""             },
    {"mnemonic": "RES 6,A",          "code": "CBB7",             "use": ""             },
    {"mnemonic": "RES 6,B",          "code": "CBB0",             "use": ""             },
    {"mnemonic": "RES 6,C",          "code": "CBB1",             "use": ""             },
    {"mnemonic": "RES 6,D",          "code": "CBB2",             "use": ""             },
    {"mnemonic": "RES 6,E",          "code": "CBB3",             "use": ""             },
    {"mnemonic": "RES 6,H",          "code": "CBB4",             "use": ""             },
    {"mnemonic": "RES 6,L",          "code": "CBB5",             "use": ""             },
    {"mnemonic": "RES 7,A",          "code": "CBBF",             "use": ""             },
    {"mnemonic": "RES 7,B",          "code": "CBB8",             "use": ""             },
    {"mnemonic": "RES 7,C",          "code": "CBB9",             "use": ""             },
    {"mnemonic": "RES 7,D",          "code": "CBBA",             "use": ""             },
    {"mnemonic": "RES 7,E",          "code": "CBBB",             "use": ""             },
    {"mnemonic": "RES 7,H",          "code": "CBBC",             "use": ""             },
    {"mnemonic": "RES 7,L",          "code": "CBBD",             "use": ""             },
    {"mnemonic": "RES 0,(HL)",       "code": "CB86",             "use": ""             },
    {"mnemonic": "RES 1,(HL)",       "code": "CB8E",             "use": ""             },
    {"mnemonic": "RES 2,(HL)",       "code": "CB96",             "use": ""             },
    {"mnemonic": "RES 3,(HL)",       "code": "CB9E",             "use": ""             },
    {"mnemonic": "RES 4,(HL)",       "code": "CBA6",             "use": ""             },
    {"mnemonic": "RES 5,(HL)",       "code": "CBAE",             "use": ""             },
    {"mnemonic": "RES 6,(HL)",       "code": "CBB6",             "use": ""             },
    {"mnemonic": "RES 7,(HL)",       "code": "CBBE",             "use": ""             },
    {"mnemonic": "RES 0,(IX+i)",     "code": "DDCBii86",         "use": "i=const"      },
    {"mnemonic": "RES 0,(IY+i)",     "code": "FDCBii86",         "use": "i=const"      },
    {"mnemonic": "RES 1,(IX+i)",     "code": "DDCBii8E",         "use": "i=const"      },
    {"mnemonic": "RES 1,(IY+i)",     "code": "FDCBii8E",         "use": "i=const"      },
    {"mnemonic": "RES 2,(IX+i)",     "code": "DDCBii96",         "use": "i=const"      },
    {"mnemonic": "RES 2,(IY+i)",     "code": "FDCBii96",         "use": "i=const"      },
    {"mnemonic": "RES 3,(IX+i)",     "code": "DDCBii9E",         "use": "i=const"      },
    {"mnemonic": "RES 3,(IY+i)",     "code": "FDCBii9E",         "use": "i=const"      },
    {"mnemonic": "RES 4,(IX+i)",     "code": "DDCBiiA6",         "use": "i=const"      },
    {"mnemonic": "RES 4,(IY+i)",     "code": "FDCBiiA6",         "use": "i=const"      },
    {"mnemonic": "RES 5,(IX+i)",     "code": "DDCBiiAE",         "use": "i=const"      },
    {"mnemonic": "RES 5,(IY+i)",     "code": "FDCBiiAE",         "use": "i=const"      },
    {"mnemonic": "RES 6,(IX+i)",     "code": "DDCBiiB6",         "use": "i=const"      },
    {"mnemonic": "RES 6,(IY+i)",     "code": "FDCBiiB6",         "use": "i=const"      },
    {"mnemonic": "RES 7,(IX+i)",     "code": "DDCBiiBE",         "use": "i=const"      },
    {"mnemonic": "RES 7,(IY+i)",     "code": "FDCBiiBE",         "use": "i=const"      },
    {"mnemonic": "SET 0,A",          "code": "CBC7",             "use": ""             },
    {"mnemonic": "SET 0,B",          "code": "CBC0",             "use": ""             },
    {"mnemonic": "SET 0,C",          "code": "CBC1",             "use": ""             },
    {"mnemonic": "SET 0,D",          "code": "CBC2",             "use": ""             },
    {"mnemonic": "SET 0,E",          "code": "CBC3",             "use": ""             },
    {"mnemonic": "SET 0,H",          "code": "CBC4",             "use": ""             },
    {"mnemonic": "SET 0,L",          "code": "CBC5",             "use": ""             },
    {"mnemonic": "SET 1,A",          "code": "CBCF",             "use": ""             },
    {"mnemonic": "SET 1,B",          "code": "CBC8",             "use": ""             },
    {"mnemonic": "SET 1,C",          "code": "CBC9",             "use": ""             },
    {"mnemonic": "SET 1,D",          "code": "CBCA",             "use": ""             },
    {"mnemonic": "SET 1,E",          "code": "CBCB",             "use": ""             },
    {"mnemonic": "SET 1,H",          "code": "CBCC",             "use": ""             },
    {"mnemonic": "SET 1,L",          "code": "CBCD",             "use": ""             },
    {"mnemonic": "SET 2,A",          "code": "CBD7",             "use": ""             },
    {"mnemonic": "SET 2,B",          "code": "CBD0",             "use": ""             },
    {"mnemonic": "SET 2,C",          "code": "CBD1",             "use": ""             },
    {"mnemonic": "SET 2,D",          "code": "CBD2",             "use": ""             },
    {"mnemonic": "SET 2,E",          "code": "CBD3",             "use": ""             },
    {"mnemonic": "SET 2,H",          "code": "CBD4",             "use": ""             },
    {"mnemonic": "SET 2,L",          "code": "CBD5",             "use": ""             },
    {"mnemonic": "SET 3,A",          "code": "CBDF",             "use": ""             },
    {"mnemonic": "SET 3,B",          "code": "CBD8",             "use": ""             },
    {"mnemonic": "SET 3,C",          "code": "CBD9",             "use": ""             },
    {"mnemonic": "SET 3,D",          "code": "CBDA",             "use": ""             },
    {"mnemonic": "SET 3,E",          "code": "CBDB",             "use": ""             },
    {"mnemonic": "SET 3,H",          "code": "CBDC",             "use": ""             },
    {"mnemonic": "SET 3,L",          "code": "CBDD",             "use": ""             },
    {"mnemonic": "SET 4,A",          "code": "CBE7",             "use": ""             },
    {"mnemonic": "SET 4,B",          "code": "CBE0",             "use": ""             },
    {"mnemonic": "SET 4,C",          "code": "CBE1",             "use": ""             },
    {"mnemonic": "SET 4,D",          "code": "CBE2",             "use": ""             },
    {"mnemonic": "SET 4,E",          "code": "CBE3",             "use": ""             },
    {"mnemonic": "SET 4,H",          "code": "CBE4",             "use": ""             },
    {"mnemonic": "SET 4,L",          "code": "CBE5",             "use": ""             },
    {"mnemonic": "SET 5,A",          "code": "CBEF",             "use": ""             },
    {"mnemonic": "SET 5,B",          "code": "CBE8",             "use": ""             },
    {"mnemonic": "SET 5,C",          "code": "CBE9",             "use": ""             },
    {"mnemonic": "SET 5,D",          "code": "CBEA",             "use": ""             },
    {"mnemonic": "SET 5,E",          "code": "CBEB",             "use": ""             },
    {"mnemonic": "SET 5,H",          "code": "CBEC",             "use": ""             },
    {"mnemonic": "SET 5,L",          "code": "CBED",             "use": ""             },
    {"mnemonic": "SET 6,A",          "code": "CBF7",             "use": ""             },
    {"mnemonic": "SET 6,B",          "code": "CBF0",             "use": ""             },
    {"mnemonic": "SET 6,C",          "code": "CBF1",             "use": ""             },
    {"mnemonic": "SET 6,D",          "code": "CBF2",             "use": ""             },
    {"mnemonic": "SET 6,E",          "code": "CBF3",             "use": ""             },
    {"mnemonic": "SET 6,H",          "code": "CBF4",             "use": ""             },
    {"mnemonic": "SET 6,L",          "code": "CBF5",             "use": ""             },
    {"mnemonic": "SET 7,A",          "code": "CBFF",             "use": ""             },
    {"mnemonic": "SET 7,B",          "code": "CBF8",             "use": ""             },
    {"mnemonic": "SET 7,C",          "code": "CBF9",             "use": ""             },
    {"mnemonic": "SET 7,D",          "code": "CBFA",             "use": ""             },
    {"mnemonic": "SET 7,E",          "code": "CBFB",             "use": ""             },
    {"mnemonic": "SET 7,H",          "code": "CBFC",             "use": ""             },
    {"mnemonic": "SET 7,L",          "code": "CBFD",             "use": ""             },
    {"mnemonic": "SET 0,(HL)",       "code": "CBC6",             "use": ""             },
    {"mnemonic": "SET 1,(HL)",       "code": "CBCE",             "use": ""             },
    {"mnemonic": "SET 2,(HL)",       "code": "CBD6",             "use": ""             },
    {"mnemonic": "SET 3,(HL)",       "code": "CBDE",             "use": ""             },
    {"mnemonic": "SET 4,(HL)",       "code": "CBE6",             "use": ""             },
    {"mnemonic": "SET 5,(HL)",       "code": "CBEE",             "use": ""             },
    {"mnemonic": "SET 6,(HL)",       "code": "CBF6",             "use": ""             },
    {"mnemonic": "SET 7,(HL)",       "code": "CBFE",             "use": ""             },
    {"mnemonic": "SET 0,(IX+i)",     "code": "DDCBiiC6",         "use": "i=const"      },
    {"mnemonic": "SET 0,(IY+i)",     "code": "FDCBiiC6",         "use": "i=const"      },
    {"mnemonic": "SET 1,(IX+i)",     "code": "DDCBiiCE",         "use": "i=const"      },
    {"mnemonic": "SET 1,(IY+i)",     "code": "FDCBiiCE",         "use": "i=const"      },
    {"mnemonic": "SET 2,(IX+i)",     "code": "DDCBiiD6",         "use": "i=const"      },
    {"mnemonic": "SET 2,(IY+i)",     "code": "FDCBiiD6",         "use": "i=const"      },
    {"mnemonic": "SET 3,(IX+i)",     "code": "DDCBiiDE",         "use": "i=const"      },
    {"mnemonic": "SET 3,(IY+i)",     "code": "FDCBiiDE",         "use": "i=const"      },
    {"mnemonic": "SET 4,(IX+i)",     "code": "DDCBiiE6",         "use": "i=const"      },
    {"mnemonic": "SET 4,(IY+i)",     "code": "FDCBiiE6",         "use": "i=const"      },
    {"mnemonic": "SET 5,(IX+i)",     "code": "DDCBiiEE",         "use": "i=const"      },
    {"mnemonic": "SET 5,(IY+i)",     "code": "FDCBiiEE",         "use": "i=const"      },
    {"mnemonic": "SET 6,(IX+i)",     "code": "DDCBiiF6",         "use": "i=const"      },
    {"mnemonic": "SET 6,(IY+i)",     "code": "FDCBiiF6",         "use": "i=const"      },
    {"mnemonic": "SET 7,(IX+i)",     "code": "DDCBiiFE",         "use": "i=const"      },
    {"mnemonic": "SET 7,(IY+i)",     "code": "FDCBiiFE",         "use": "i=const"      },
    {"mnemonic": "RET",              "code": "C9",               "use": ""             },
    {"mnemonic": "POP BC",           "code": "C1",               "use": ""             },
    {"mnemonic": "POP DE",           "code": "D1",               "use": ""             },
    {"mnemonic": "POP HL",           "code": "E1",               "use": ""             },
    {"mnemonic": "POP AF",           "code": "F1",               "use": ""             },
    {"mnemonic": "POP IX",           "code": "DDE1",             "use": ""             },
    {"mnemonic": "POP IY",           "code": "FDE1",             "use": ""             },
    {"mnemonic": "PUSH BC",          "code": "C5",               "use": ""             },
    {"mnemonic": "PUSH DE",          "code": "D5",               "use": ""             },
    {"mnemonic": "PUSH HL",          "code": "E5",               "use": ""             },
    {"mnemonic": "PUSH AF",          "code": "F5",               "use": ""             },
    {"mnemonic": "PUSH IX",          "code": "DDE5",             "use": ""             },
    {"mnemonic": "PUSH IY",          "code": "FDE5",             "use": ""             },
    {"mnemonic": "RET NZ",           "code": "C0",               "use": ""             },
    {"mnemonic": "RET Z",            "code": "C8",               "use": ""             },
    {"mnemonic": "RET NC",           "code": "D0",               "use": ""             },
    {"mnemonic": "RET C",            "code": "D8",               "use": ""             },
    {"mnemonic": "RET PO",           "code": "E0",               "use": ""             },
    {"mnemonic": "RET PE",           "code": "E8",               "use": ""             },
    {"mnemonic": "RET P",            "code": "F0",               "use": ""             },
    {"mnemonic": "RET M",            "code": "F8",               "use": ""             },
    {"mnemonic": "RL A",             "code": "CB17",             "use": ""             },
    {"mnemonic": "RL B",             "code": "CB10",             "use": ""             },
    {"mnemonic": "RL C",             "code": "CB11",             "use": ""             },
    {"mnemonic": "RL D",             "code": "CB12",             "use": ""             },
    {"mnemonic": "RL E",             "code": "CB13",             "use": ""             },
    {"mnemonic": "RL H",             "code": "CB14",             "use": ""             },
    {"mnemonic": "RL L",             "code": "CB15",             "use": ""             },
    {"mnemonic": "RL (HL)",          "code": "CB16",             "use": ""             },
    {"mnemonic": "RL (IX+i)",        "code": "DDCBii16",         "use": "i=const"      },
    {"mnemonic": "RL (IY+i)",        "code": "FDCBii16",         "use": "i=const"      },
    {"mnemonic": "RLA",              "code": "17",               "use": ""             },
    {"mnemonic": "RLC A",            "code": "CB07",             "use": ""             },
    {"mnemonic": "RLC B",            "code": "CB00",             "use": ""             },
    {"mnemonic": "RLC C",            "code": "CB01",             "use": ""             },
    {"mnemonic": "RLC D",            "code": "CB02",             "use": ""             },
    {"mnemonic": "RLC E",            "code": "CB03",             "use": ""             },
    {"mnemonic": "RLC H",            "code": "CB04",             "use": ""             },
    {"mnemonic": "RLC L",            "code": "CB05",             "use": ""             },
    {"mnemonic": "RLC (HL)",         "code": "CB06",             "use": ""             },
    {"mnemonic": "RLC (IX+i)",       "code": "DDCBii06",         "use": "i=const"      },
    {"mnemonic": "RLC (IY+i)",       "code": "FDCBii06",         "use": "i=const"      },
    {"mnemonic": "RLCA",             "code": "07",               "use": ""             },
    {"mnemonic": "RR A",             "code": "CB1F",             "use": ""             },
    {"mnemonic": "RR B",             "code": "CB18",             "use": ""             },
    {"mnemonic": "RR C",             "code": "CB19",             "use": ""             },
    {"mnemonic": "RR D",             "code": "CB1A",             "use": ""             },
    {"mnemonic": "RR E",             "code": "CB1B",             "use": ""             },
    {"mnemonic": "RR H",             "code": "CB1C",             "use": ""             },
    {"mnemonic": "RR L",             "code": "CB1D",             "use": ""             },
    {"mnemonic": "RR (HL)",          "code": "CB1E",             "use": ""             },
    {"mnemonic": "RR (IX+i)",        "code": "DDCBii1E",         "use": "i=const"      },
    {"mnemonic": "RR (IY+i)",        "code": "FDCBii1E",         "use": "i=const"      },
    {"mnemonic": "RRA",              "code": "1F",               "use": ""             },
    {"mnemonic": "RRC A",            "code": "CB0F",             "use": ""             },
    {"mnemonic": "RRC B",            "code": "CB08",             "use": ""             },
    {"mnemonic": "RRC C",            "code": "CB09",             "use": ""             },
    {"mnemonic": "RRC D",            "code": "CB0A",             "use": ""             },
    {"mnemonic": "RRC E",            "code": "CB0B",             "use": ""             },
    {"mnemonic": "RRC H",            "code": "CB0C",             "use": ""             },
    {"mnemonic": "RRC L",            "code": "CB0D",             "use": ""             },
    {"mnemonic": "RRC (HL)",         "code": "CB0E",             "use": ""             },
    {"mnemonic": "RRC (IX+i)",       "code": "DDCBii0E",         "use": "i=const"      },
    {"mnemonic": "RRC (IY+i)",       "code": "FDCBii0E",         "use": "i=const"      },
    {"mnemonic": "RRCA",             "code": "0F",               "use": ""             },
    {"mnemonic": "SLA A",            "code": "CB27",             "use": ""             },
    {"mnemonic": "SLA B",            "code": "CB20",             "use": ""             },
    {"mnemonic": "SLA C",            "code": "CB21",             "use": ""             },
    {"mnemonic": "SLA D",            "code": "CB22",             "use": ""             },
    {"mnemonic": "SLA E",            "code": "CB23",             "use": ""             },
    {"mnemonic": "SLA H",            "code": "CB24",             "use": ""             },
    {"mnemonic": "SLA L",            "code": "CB25",             "use": ""             },
    {"mnemonic": "SLA (HL)",         "code": "CB26",             "use": ""             },
    {"mnemonic": "SLA (IX+i)",       "code": "DDCBii26",         "use": "i=const"      },
    {"mnemonic": "SLA (IY+i)",       "code": "FDCBii26",         "use": "i=const"      },
    {"mnemonic": "SRA A",            "code": "CB2F",             "use": ""             },
    {"mnemonic": "SRA B",            "code": "CB28",             "use": ""             },
    {"mnemonic": "SRA C",            "code": "CB29",             "use": ""             },
    {"mnemonic": "SRA D",            "code": "CB2A",             "use": ""             },
    {"mnemonic": "SRA E",            "code": "CB2B",             "use": ""             },
    {"mnemonic": "SRA H",            "code": "CB2C",             "use": ""             },
    {"mnemonic": "SRA L",            "code": "CB2D",             "use": ""             },
    {"mnemonic": "SRA (HL)",         "code": "CB2E",             "use": ""             },
    {"mnemonic": "SRA (IX+i)",       "code": "DDCBii2E",         "use": "i=const"      },
    {"mnemonic": "SRA (IY+i)",       "code": "FDCBii2E",         "use": "i=const"      },
    {"mnemonic": "SRL A",            "code": "CB3F",             "use": ""             },
    {"mnemonic": "SRL B",            "code": "CB38",             "use": ""             },
    {"mnemonic": "SRL C",            "code": "CB39",             "use": ""             },
    {"mnemonic": "SRL D",            "code": "CB3A",             "use": ""             },
    {"mnemonic": "SRL E",            "code": "CB3B",             "use": ""             },
    {"mnemonic": "SRL H",            "code": "CB3C",             "use": ""             },
    {"mnemonic": "SRL L",            "code": "CB3D",             "use": ""             },
    {"mnemonic": "SRL (HL)",         "code": "CB3E",             "use": ""             },
    {"mnemonic": "SRL (IX+i)",       "code": "DDCBii3E",         "use": "i=const"      },
    {"mnemonic": "SRL (IY+i)",       "code": "FDCBii3E",         "use": "i=const"      },
    {"mnemonic": "RST 0X00",         "code": "C7",               "use": ""             },
    {"mnemonic": "RST 0X08",         "code": "CF",               "use": ""             },
    {"mnemonic": "RST 0X10",         "code": "D7",               "use": ""             },
    {"mnemonic": "RST 0X18",         "code": "DF",               "use": ""             },
    {"mnemonic": "RST 0X20",         "code": "E7",               "use": ""             },
    {"mnemonic": "RST 0X28",         "code": "EF",               "use": ""             },
    {"mnemonic": "RST 0X30",         "code": "F7",               "use": ""             },
    {"mnemonic": "RST 0X38",         "code": "FF",               "use": ""             },
    {"mnemonic": "SCF",              "code": "37",               "use": ""             },
    {"mnemonic": "SBC A",            "code": "9F",               "use": ""             },
    {"mnemonic": "SBC B",            "code": "98",               "use": ""             },
    {"mnemonic": "SBC C",            "code": "99",               "use": ""             },
    {"mnemonic": "SBC D",            "code": "9A",               "use": ""             },
    {"mnemonic": "SBC E",            "code": "9B",               "use": ""             },
    {"mnemonic": "SBC H",            "code": "9C",               "use": ""             },
    {"mnemonic": "SBC L",            "code": "9D",               "use": ""             },
    {"mnemonic": "SBC (HL)",         "code": "9E",               "use": ""             },
    {"mnemonic": "SBC A,(IX+i)",     "code": "DD9Eii",           "use": "i=const"      },
    {"mnemonic": "SBC A,(IY+i)",     "code": "FD9Eii",           "use": "i=const"      },
    {"mnemonic": "SBC HL,BC",        "code": "ED42",             "use": ""             },
    {"mnemonic": "SBC HL,DE",        "code": "ED52",             "use": ""             },
    {"mnemonic": "SBC HL,HL",        "code": "ED62",             "use": ""             },
    {"mnemonic": "SBC HL,SP",        "code": "ED72",             "use": ""             },
    {"mnemonic": "SBC b",            "code": "DEbb",             "use": "b=const"      },
    {"mnemonic": "SUB A",            "code": "97",               "use": ""             },
    {"mnemonic": "SUB B",            "code": "90",               "use": ""             },
    {"mnemonic": "SUB C",            "code": "91",               "use": ""             },
    {"mnemonic": "SUB D",            "code": "92",               "use": ""             },
    {"mnemonic": "SUB E",            "code": "93",               "use": ""             },
    {"mnemonic": "SUB H",            "code": "94",               "use": ""             },
    {"mnemonic": "SUB L",            "code": "95",               "use": ""             },
    {"mnemonic": "SUB (HL)",         "code": "96",               "use": ""             },
    {"mnemonic": "SUB (IX+i)",       "code": "DD96ii",           "use": "i=const"      },
    {"mnemonic": "SUB (IY+i)",       "code": "FD96ii",           "use": "i=const"      },
    {"mnemonic": "SUB b",            "code": "D6bb",             "use": "b=const"      },
    {"mnemonic": "LD A,(BC)",        "code": "DD0A",             "use": ""             },
    {"mnemonic": "DEC DE",           "code": "DD1B",             "use": ""             },
    {"mnemonic": "LD IXH,b",         "code": "DD26bb",           "use": "b=const"      },
    {"mnemonic": "INC IXL",          "code": "DD2C",             "use": ""             },
    {"mnemonic": "DEC IXL",          "code": "DD2D",             "use": ""             },
    {"mnemonic": "LD IXL,b",         "code": "DD2Ebb",           "use": "b=const"      },
    {"mnemonic": "LD C,IXH",         "code": "DD4C",             "use": ""             },
    {"mnemonic": "LD D,IXH",         "code": "DD54",             "use": ""             },
    {"mnemonic": "LD E,IXL",         "code": "DD5D",             "use": ""             },
    {"mnemonic": "LD IXH,B",         "code": "DD60",             "use": ""             },
    {"mnemonic": "LD IXH,C",         "code": "DD61",             "use": ""             },
    {"mnemonic": "LD IXH,D",         "code": "DD62",             "use": ""             },
    {"mnemonic": "LD IXH,E",         "code": "DD63",             "use": ""             },
    {"mnemonic": "LD IXH,A",         "code": "DD67",             "use": ""             },
    {"mnemonic": "LD A,IXH",         "code": "DD7C",             "use": ""             },
    {"mnemonic": "ADD A,IXH",        "code": "DD84",             "use": ""             },
    {"mnemonic": "SUB IXH",          "code": "DD94",             "use": ""             },
    {"mnemonic": "SUB IXL",          "code": "DD95",             "use": ""             },
    {"mnemonic": "XOR IXH",          "code": "DDAC",             "use": ""             },
    {"mnemonic": "DEC BC",           "code": "FD0B",             "use": ""             },
    {"mnemonic": "DEC DE",           "code": "FD1B",             "use": ""             },
    {"mnemonic": "EI",               "code": "FDFB",             "use": ""             },
    {"mnemonic": "LD IYL,E",         "code": "FD6B",             "use": ""             },
    {"mnemonic": "LD A,IYH",         "code": "FD7C",             "use": ""             },
    {"mnemonic": "LD A,IYL",         "code": "FD7D",             "use": ""             },
    {"mnemonic": "JR NZ,r",          "code": "FD20rr",           "use": "r=code_pcr"   },
    {"mnemonic": "DEC IYH",          "code": "FD25",             "use": ""             },
    {"mnemonic": "LD C,B",           "code": "FD48",             "use": ""             },
    {"mnemonic": "LD IYH,E",         "code": "FD63",             "use": ""             },
    {"mnemonic": "XOR IYH",          "code": "FDAC",             "use": ""             },
    {"mnemonic": "CALL Z,t",         "code": "FDCCt0t1",         "use": "t=code"       },
    {"mnemonic": "RET C",            "code": "FDD8",             "use": ""             },
]


class CPU_Z80(opcodetools.cpu.base_cpu.CPU):

    def __init__(self):
        super().__init__(OPCODES)
