import cdk = require('@aws-cdk/core');
export interface SPADeployConfig {
    readonly indexDoc: string;
    readonly errorDoc?: string;
    readonly websiteFolder: string;
    readonly certificateARN?: string;
    readonly cfAliases?: string[];
    readonly exportWebsiteUrlOutput?: boolean;
    readonly exportWebsiteUrlName?: string;
}
export interface HostedZoneConfig {
    readonly indexDoc: string;
    readonly errorDoc?: string;
    readonly websiteFolder: string;
    readonly zoneName: string;
}
export interface SPAGlobalConfig {
    readonly encryptBucket?: boolean;
    readonly ipFilter?: boolean;
    readonly ipList?: string[];
}
export declare class SPADeploy extends cdk.Construct {
    globalConfig: SPAGlobalConfig;
    constructor(scope: cdk.Construct, id: string, config?: SPAGlobalConfig);
    /**
     * Helper method to provide a configured s3 bucket
     */
    private getS3Bucket;
    /**
     * Helper method to provide configuration for cloudfront
     */
    private getCFConfig;
    /**
     * Basic setup needed for a non-ssl, non vanity url, non cached s3 website
     */
    createBasicSite(config: SPADeployConfig): void;
    /**
     * This will create an s3 deployment fronted by a cloudfront distribution
     * It will also setup error forwarding and unauth forwarding back to indexDoc
     */
    createSiteWithCloudfront(config: SPADeployConfig): void;
    /**
     * S3 Deployment, cloudfront distribution, ssl cert and error forwarding auto
     * configured by using the details in the hosted zone provided
     */
    createSiteFromHostedZone(config: HostedZoneConfig): void;
}
