from hexbytes import HexBytes
from web3.datastructures import AttributeDict

log_receipts = [
    AttributeDict(
        {
            "address": "0x39C4BFa00b6edecCDd00fA9589E1BE76DE63e862",
            "topics": [
                HexBytes(
                    "0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef"
                ),
                HexBytes(
                    "0x00000000000000000000000094e01661ebaef430fe862f958c03200b0f483f27"
                ),
                HexBytes(
                    "0x00000000000000000000000094e01661ebaef430fe862f958c03200b0f483f27"
                ),
            ],
            "data": "0x000000000000000000000000000000000000000000000003aa2371d700680000",
            "blockNumber": 4357126,
            "transactionHash": HexBytes(
                "0x21381484d8f69dcd782560d1fd3cd818e743c79767985d01aec7e61c2a7f1de9"
            ),
            "transactionIndex": 14,
            "blockHash": HexBytes(
                "0x677ada1a306fc50751001bca6eeaa3f5a87a0bf2c9f6fa27899bfbaf999cca4f"
            ),
            "logIndex": 13,
            "removed": False,
        }
    ),
    AttributeDict(
        {
            "address": "0x39C4BFa00b6edecCDd00fA9589E1BE76DE63e862",
            "topics": [
                HexBytes(
                    "0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef"
                ),
                HexBytes(
                    "0x00000000000000000000000094e01661ebaef430fe862f958c03200b0f483f27"
                ),
                HexBytes(
                    "0x00000000000000000000000064da772dd84965f0ee58174941d78a9dfbccca2e"
                ),
            ],
            "data": "0x000000000000000000000000000000000000000000000001a055690d9db80000",
            "blockNumber": 4357126,
            "transactionHash": HexBytes(
                "0x21381484d8f69dcd782560d1fd3cd818e743c79767985d01aec7e61c2a7f1de9"
            ),
            "transactionIndex": 14,
            "blockHash": HexBytes(
                "0x677ada1a306fc50751001bca6eeaa3f5a87a0bf2c9f6fa27899bfbaf999cca4f"
            ),
            "logIndex": 14,
            "removed": False,
        }
    ),
    AttributeDict(
        {
            "address": "0x39C4BFa00b6edecCDd00fA9589E1BE76DE63e862",
            "topics": [
                HexBytes(
                    "0x8c5be1e5ebec7d5bd14f71427d1e84f3dd0314c0f7b2291e5b200ac8c7c3b925"
                ),
                HexBytes(
                    "0x00000000000000000000000064da772dd84965f0ee58174941d78a9dfbccca2e"
                ),
                HexBytes(
                    "0x00000000000000000000000080cdad25de6b439e866805b2dc6808d23ff57b5d"
                ),
            ],
            "data": "0x000000000000000000000000000000000000000000000001a055690d9db80000",
            "blockNumber": 4357126,
            "transactionHash": HexBytes(
                "0x21381484d8f69dcd782560d1fd3cd818e743c79767985d01aec7e61c2a7f1de9"
            ),
            "transactionIndex": 14,
            "blockHash": HexBytes(
                "0x677ada1a306fc50751001bca6eeaa3f5a87a0bf2c9f6fa27899bfbaf999cca4f"
            ),
            "logIndex": 15,
            "removed": False,
        }
    ),
    AttributeDict(
        {
            "address": "0x39C4BFa00b6edecCDd00fA9589E1BE76DE63e862",
            "topics": [
                HexBytes(
                    "0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef"
                ),
                HexBytes(
                    "0x00000000000000000000000064da772dd84965f0ee58174941d78a9dfbccca2e"
                ),
                HexBytes(
                    "0x00000000000000000000000080cdad25de6b439e866805b2dc6808d23ff57b5d"
                ),
            ],
            "data": "0x000000000000000000000000000000000000000000000001a055690d9db80000",
            "blockNumber": 4357126,
            "transactionHash": HexBytes(
                "0x21381484d8f69dcd782560d1fd3cd818e743c79767985d01aec7e61c2a7f1de9"
            ),
            "transactionIndex": 14,
            "blockHash": HexBytes(
                "0x677ada1a306fc50751001bca6eeaa3f5a87a0bf2c9f6fa27899bfbaf999cca4f"
            ),
            "logIndex": 16,
            "removed": False,
        }
    ),
    AttributeDict(
        {
            "address": "0x99b9F9BA62002a9b43aF6e540428277D5E52EF47",
            "topics": [
                HexBytes(
                    "0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef"
                ),
                HexBytes(
                    "0x00000000000000000000000099b9f9ba62002a9b43af6e540428277d5e52ef47"
                ),
                HexBytes(
                    "0x00000000000000000000000094e01661ebaef430fe862f958c03200b0f483f27"
                ),
                HexBytes(
                    "0xcc292d3dab2c0fbbf616670ac57ec51162959c2d9cbe938819b6e8bc1c757335"
                ),
            ],
            "data": "0x",
            "blockNumber": 4357126,
            "transactionHash": HexBytes(
                "0x21381484d8f69dcd782560d1fd3cd818e743c79767985d01aec7e61c2a7f1de9"
            ),
            "transactionIndex": 14,
            "blockHash": HexBytes(
                "0x677ada1a306fc50751001bca6eeaa3f5a87a0bf2c9f6fa27899bfbaf999cca4f"
            ),
            "logIndex": 17,
            "removed": False,
        }
    ),
    AttributeDict(
        {
            "address": "0x99b9F9BA62002a9b43aF6e540428277D5E52EF47",
            "topics": [
                HexBytes(
                    "0x2114851a3e2a54429989f46c1ab0743e37ded205d9bbdfd85635aed5bd595a06"
                ),
                HexBytes(
                    "0x00000000000000000000000099b9f9ba62002a9b43af6e540428277d5e52ef47"
                ),
                HexBytes(
                    "0x00000000000000000000000094e01661ebaef430fe862f958c03200b0f483f27"
                ),
                HexBytes(
                    "0xcc292d3dab2c0fbbf616670ac57ec51162959c2d9cbe938819b6e8bc1c757335"
                ),
            ],
            "data": "0x0000000000000000000000000000000000000000000000000000000000000001",
            "blockNumber": 4357126,
            "transactionHash": HexBytes(
                "0x21381484d8f69dcd782560d1fd3cd818e743c79767985d01aec7e61c2a7f1de9"
            ),
            "transactionIndex": 14,
            "blockHash": HexBytes(
                "0x677ada1a306fc50751001bca6eeaa3f5a87a0bf2c9f6fa27899bfbaf999cca4f"
            ),
            "logIndex": 18,
            "removed": False,
        }
    ),
    AttributeDict(
        {
            "address": "0x99b9F9BA62002a9b43aF6e540428277D5E52EF47",
            "topics": [
                HexBytes(
                    "0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef"
                ),
                HexBytes(
                    "0x00000000000000000000000099b9f9ba62002a9b43af6e540428277d5e52ef47"
                ),
                HexBytes(
                    "0x00000000000000000000000094e01661ebaef430fe862f958c03200b0f483f27"
                ),
                HexBytes(
                    "0xe37edda38a308a6fae15178579aab28bc7f9e46e52fde30c3a46b82b7461aa08"
                ),
            ],
            "data": "0x",
            "blockNumber": 4357126,
            "transactionHash": HexBytes(
                "0x21381484d8f69dcd782560d1fd3cd818e743c79767985d01aec7e61c2a7f1de9"
            ),
            "transactionIndex": 14,
            "blockHash": HexBytes(
                "0x677ada1a306fc50751001bca6eeaa3f5a87a0bf2c9f6fa27899bfbaf999cca4f"
            ),
            "logIndex": 19,
            "removed": False,
        }
    ),
    AttributeDict(
        {
            "address": "0x99b9F9BA62002a9b43aF6e540428277D5E52EF47",
            "topics": [
                HexBytes(
                    "0x2114851a3e2a54429989f46c1ab0743e37ded205d9bbdfd85635aed5bd595a06"
                ),
                HexBytes(
                    "0x00000000000000000000000099b9f9ba62002a9b43af6e540428277d5e52ef47"
                ),
                HexBytes(
                    "0x00000000000000000000000094e01661ebaef430fe862f958c03200b0f483f27"
                ),
                HexBytes(
                    "0xe37edda38a308a6fae15178579aab28bc7f9e46e52fde30c3a46b82b7461aa08"
                ),
            ],
            "data": "0x0000000000000000000000000000000000000000000000000000000000000001",
            "blockNumber": 4357126,
            "transactionHash": HexBytes(
                "0x21381484d8f69dcd782560d1fd3cd818e743c79767985d01aec7e61c2a7f1de9"
            ),
            "transactionIndex": 14,
            "blockHash": HexBytes(
                "0x677ada1a306fc50751001bca6eeaa3f5a87a0bf2c9f6fa27899bfbaf999cca4f"
            ),
            "logIndex": 20,
            "removed": False,
        }
    ),
    AttributeDict(
        {
            "address": "0x64DA772DD84965f0Ee58174941d78a9DfBccca2e",
            "topics": [
                HexBytes(
                    "0x3c8fbbba495ddb1296f967c80627bcca81b77be0b349ed8ae5f604365c22e9c7"
                )
            ],
            "data": "0x6e4f8d9f6517dfa28f202b2e2582943d1bd567dfb0c4a774989715c29e4aed180000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000039c4bfa00b6edeccdd00fa9589e1be76de63e862000000000000000000000000000000000000000000000003aa2371d7006800000000000000000000000000000000000000000000000000000000000000000001",
            "blockNumber": 4357126,
            "transactionHash": HexBytes(
                "0x21381484d8f69dcd782560d1fd3cd818e743c79767985d01aec7e61c2a7f1de9"
            ),
            "transactionIndex": 14,
            "blockHash": HexBytes(
                "0x677ada1a306fc50751001bca6eeaa3f5a87a0bf2c9f6fa27899bfbaf999cca4f"
            ),
            "logIndex": 21,
            "removed": False,
        }
    ),
    AttributeDict(
        {
            "address": "0xe35F3B71CA90eE2606F64b645D8F4f8DCaA914Bf",
            "topics": [
                HexBytes(
                    "0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef"
                )
            ],
            "data": "0x0000000000000000000000008683f9c4e856be65f8a38a3a768e8fd6de94d30a000000000000000000000000fd1017c3284a12ac33bc65df12d71721c85931e00000000000000000000000000000000000000000000000000000000000000001",
            "blockNumber": 7240557,
            "transactionHash": HexBytes(
                "0x1962e296457b16d5221d33623f2db5f617cb54221deb7cfd73611f761ac526a3"
            ),
            "transactionIndex": 6,
            "blockHash": HexBytes(
                "0xdf3c33d034f1b342820afdfb2612d0794d4a1c15518184d71a047ef1eb151d10"
            ),
            "logIndex": 5,
            "removed": False,
        }
    ),
]

# Real transfer log of a `Transfer(address indexed, address, uint256 indexed)` found on Rinkeby
invalid_log_receipt = AttributeDict(
    {
        "address": "0x1607a02df130c472159fAEb2BC706175B84055Fa",
        "blockHash": HexBytes(
            "0xe386d2275b6db3b1e02d5fae3f663312ecbf4f5f58fdf20c47da5fb6769dc578"
        ),
        "blockNumber": 10172601,
        "data": "0x0000000000000000000000000000000000000000000000000000000000000000",
        "logIndex": 11,
        "removed": False,
        "topics": [
            HexBytes(
                "0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef"
            ),
            HexBytes(
                "0x00000000000000000000000073c9cc436c1249394d1ea28bf1d9f2217da006f4"
            ),
            HexBytes(
                "0x4567000000000000000000000000000000000000000000000000000000000000"
            ),
        ],
        "transactionHash": HexBytes(
            "0xcbb6f53e05b3bfde1fde259f9b44d48fde73f4f633604cbe6bd4375dddbefa0f"
        ),
        "transactionIndex": 5,
        "transactionLogIndex": "0x0",
        "type": "mined",
    }
)
