/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replication.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.replication.common.ReplicationSequenceFormatter;
import org.openstreetmap.osmosis.replication.common.ReplicationState;

public class ServerStateReader {
    private static final String SERVER_STATE_FILE = "state.txt";
    private static final String SEQUENCE_STATE_FILE_SUFFIX = ".state.txt";
    private ReplicationSequenceFormatter sequenceFormatter = new ReplicationSequenceFormatter(9, 3);

    public ReplicationState getServerState(URL baseUrl) {
        return this.getServerState(baseUrl, SERVER_STATE_FILE);
    }

    public ReplicationState getServerState(URL baseUrl, long sequenceNumber) {
        return this.getServerState(baseUrl, this.sequenceFormatter.getFormattedName(sequenceNumber, SEQUENCE_STATE_FILE_SUFFIX));
    }

    private ReplicationState getServerState(URL baseUrl, String stateFile) {
        URL stateUrl;
        try {
            stateUrl = new URL(baseUrl, stateFile);
        }
        catch (MalformedURLException e) {
            throw new OsmosisRuntimeException("The server timestamp URL could not be created.", (Throwable)e);
        }
        try {
            Properties stateProperties;
            URLConnection connection = stateUrl.openConnection();
            connection.setReadTimeout(900000);
            connection.setConnectTimeout(900000);
            connection.setRequestProperty("User-Agent", "Osmosis/0.48.3");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                stateProperties = new Properties();
                stateProperties.load(reader);
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to read the state from the server.", (Throwable)e);
            }
            HashMap<String, String> stateMap = new HashMap<String, String>();
            for (Map.Entry<Object, Object> property : stateProperties.entrySet()) {
                stateMap.put((String)property.getKey(), (String)property.getValue());
            }
            ReplicationState state = new ReplicationState(stateMap);
            return state;
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to read the state from the server.", (Throwable)e);
        }
    }
}

