/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DbOrderedFeature;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.store.Storeable;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityFeatureMapper;

public class WayNodeMapper
extends EntityFeatureMapper<DbOrderedFeature<WayNode>> {
    @Override
    public String getParentEntityName() {
        return "way";
    }

    @Override
    public String getEntityName() {
        return "way_nodes";
    }

    @Override
    public String getSqlSelect(boolean filterByEntityId, boolean orderBy) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("SELECT way_id AS entity_id, node_id, sequence_id FROM ");
        resultSql.append("way_nodes f");
        if (filterByEntityId) {
            resultSql.append(" WHERE entity_id = ?");
        }
        if (orderBy) {
            resultSql.append(this.getSqlDefaultOrderBy());
        }
        return resultSql.toString();
    }

    @Override
    public String getSqlDefaultOrderBy() {
        return super.getSqlDefaultOrderBy() + ", sequence_id";
    }

    @Override
    public String getSqlInsert(int rowCount) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("INSERT INTO way_nodes (");
        resultSql.append("way_id, node_id, sequence_id) VALUES ");
        for (int row = 0; row < rowCount; ++row) {
            if (row > 0) {
                resultSql.append(", ");
            }
            resultSql.append("(?, ?, ?)");
        }
        return resultSql.toString();
    }

    @Override
    public String getSqlDelete(boolean filterByEntityId) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("DELETE FROM way_nodes");
        if (filterByEntityId) {
            resultSql.append(" WHERE ").append("way_id = ?");
        }
        return resultSql.toString();
    }

    @Override
    public DbOrderedFeature<WayNode> buildEntity(ResultSet resultSet) {
        try {
            return new DbOrderedFeature(resultSet.getLong("entity_id"), (Storeable)new WayNode(resultSet.getLong("node_id")), resultSet.getInt("sequence_id"));
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to build a way node from the current recordset row.", (Throwable)e);
        }
    }

    @Override
    public int populateEntityParameters(PreparedStatement statement, int initialIndex, DbOrderedFeature<WayNode> entityFeature) {
        try {
            WayNode wayNode = (WayNode)entityFeature.getFeature();
            int prmIndex = initialIndex;
            statement.setLong(prmIndex++, entityFeature.getEntityId());
            statement.setLong(prmIndex++, wayNode.getNodeId());
            statement.setInt(prmIndex++, entityFeature.getSequenceId());
            return prmIndex;
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to populate way node parameters for way " + entityFeature.getEntityId() + ".", (Throwable)e);
        }
    }
}

