/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DbFeature;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.store.Storeable;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityFeatureMapper;

public class TagMapper
extends EntityFeatureMapper<DbFeature<Tag>> {
    private String parentEntityName;

    public TagMapper(String parentEntityName) {
        this.parentEntityName = parentEntityName;
    }

    @Override
    public String getParentEntityName() {
        return this.parentEntityName;
    }

    @Override
    public String getEntityName() {
        return this.parentEntityName + "_tags";
    }

    @Override
    public String getSqlSelect(boolean filterByEntityId, boolean orderBy) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("SELECT ").append(this.parentEntityName).append("_id AS entity_id, k, v FROM ");
        resultSql.append(this.parentEntityName).append("_tags f");
        if (filterByEntityId) {
            resultSql.append(" WHERE ").append(this.parentEntityName).append("_id = ?");
        }
        if (orderBy) {
            resultSql.append(this.getSqlDefaultOrderBy());
        }
        return resultSql.toString();
    }

    @Override
    public String getSqlInsert(int rowCount) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("INSERT INTO ").append(this.parentEntityName).append("_tags (");
        resultSql.append(this.parentEntityName).append("_id, k, v) VALUES ");
        for (int row = 0; row < rowCount; ++row) {
            if (row > 0) {
                resultSql.append(", ");
            }
            resultSql.append("(?, ?, ?)");
        }
        return resultSql.toString();
    }

    @Override
    public String getSqlDelete(boolean filterByEntityId) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("DELETE FROM ").append(this.parentEntityName).append("_tags");
        if (filterByEntityId) {
            resultSql.append(" WHERE ").append(this.parentEntityName).append("_id = ?");
        }
        return resultSql.toString();
    }

    @Override
    public DbFeature<Tag> buildEntity(ResultSet resultSet) {
        try {
            return new DbFeature(resultSet.getLong("entity_id"), (Storeable)new Tag(resultSet.getString("k"), resultSet.getString("v")));
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to build a tag from the current recordset row.", (Throwable)e);
        }
    }

    @Override
    public int populateEntityParameters(PreparedStatement statement, int initialIndex, DbFeature<Tag> entityFeature) {
        try {
            Tag tag = (Tag)entityFeature.getFeature();
            int prmIndex = initialIndex;
            statement.setLong(prmIndex++, entityFeature.getEntityId());
            statement.setString(prmIndex++, tag.getKey());
            statement.setString(prmIndex++, tag.getValue());
            return prmIndex;
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to populate tag parameters for entity " + this.parentEntityName + " " + entityFeature.getEntityId() + ".");
        }
    }
}

