/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.common;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.openstreetmap.osmosis.apidb.common.DatabaseContext;
import org.openstreetmap.osmosis.apidb.common.IdentityValueLoader;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.ReleasableStatementContainer;

public class PostgresqlIdentityValueLoader
implements IdentityValueLoader {
    private static final String SQL_SELECT_LAST_INSERT_ID = "SELECT lastval() AS lastInsertId";
    private static final String SQL_SELECT_LAST_SEQUENCE_ID = "SELECT currval(?) AS lastSequenceId";
    private DatabaseContext dbCtx;
    private ReleasableStatementContainer statementContainer;
    private PreparedStatement selectInsertIdStatement;
    private PreparedStatement selectSequenceIdStatement;

    public PostgresqlIdentityValueLoader(DatabaseContext dbCtx) {
        this.dbCtx = dbCtx;
        this.statementContainer = new ReleasableStatementContainer();
    }

    @Override
    public long getLastInsertId() {
        long l;
        block9: {
            if (this.selectInsertIdStatement == null) {
                this.selectInsertIdStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatementForStreaming(SQL_SELECT_LAST_INSERT_ID));
            }
            ResultSet lastInsertQuery = this.selectInsertIdStatement.executeQuery();
            try {
                lastInsertQuery.next();
                l = lastInsertQuery.getLong("lastInsertId");
                if (lastInsertQuery == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (lastInsertQuery != null) {
                        try {
                            lastInsertQuery.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to retrieve the id of the newly inserted record.", (Throwable)e);
                }
            }
            lastInsertQuery.close();
        }
        return l;
    }

    @Override
    public long getLastSequenceId(String sequenceName) {
        long l;
        block9: {
            if (this.selectSequenceIdStatement == null) {
                this.selectSequenceIdStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatementForStreaming(SQL_SELECT_LAST_SEQUENCE_ID));
            }
            this.selectSequenceIdStatement.setString(1, sequenceName);
            ResultSet lastSequenceQuery = this.selectSequenceIdStatement.executeQuery();
            try {
                lastSequenceQuery.next();
                l = lastSequenceQuery.getLong("lastSequenceId");
                if (lastSequenceQuery == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (lastSequenceQuery != null) {
                        try {
                            lastSequenceQuery.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to retrieve the last sequence id.", (Throwable)e);
                }
            }
            lastSequenceQuery.close();
        }
        return l;
    }

    public void close() {
        this.statementContainer.close();
    }
}

