# -*- coding: utf-8 -*-

"""
    aws_apimatic

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

import aws_apimatic.models.price
import aws_apimatic.models.availability_attributes

class OfferListing(object):

    """Implementation of the 'OfferListing' model.

    TODO: type model description here.

    Attributes:
        offer_listing_id (string): TODO: type description here.
        price (Price): TODO: type description here.
        sale_price (Price): TODO: type description here.
        amount_saved (Price): TODO: type description here.
        percentage_saved (int): TODO: type description here.
        availability (string): TODO: type description here.
        availability_attributes (AvailabilityAttributes): TODO: type
            description here.
        is_eligible_for_super_saver_shipping (bool): TODO: type description
            here.
        is_eligible_for_prime (bool): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "offer_listing_id":'OfferListingId',
        "price":'Price',
        "sale_price":'SalePrice',
        "amount_saved":'AmountSaved',
        "percentage_saved":'PercentageSaved',
        "availability":'Availability',
        "availability_attributes":'AvailabilityAttributes',
        "is_eligible_for_super_saver_shipping":'IsEligibleForSuperSaverShipping',
        "is_eligible_for_prime":'IsEligibleForPrime'
    }

    def __init__(self,
                 offer_listing_id=None,
                 price=None,
                 sale_price=None,
                 amount_saved=None,
                 percentage_saved=None,
                 availability=None,
                 availability_attributes=None,
                 is_eligible_for_super_saver_shipping=None,
                 is_eligible_for_prime=None):
        """Constructor for the OfferListing class"""

        # Initialize members of the class
        self.offer_listing_id = offer_listing_id
        self.price = price
        self.sale_price = sale_price
        self.amount_saved = amount_saved
        self.percentage_saved = percentage_saved
        self.availability = availability
        self.availability_attributes = availability_attributes
        self.is_eligible_for_super_saver_shipping = is_eligible_for_super_saver_shipping
        self.is_eligible_for_prime = is_eligible_for_prime


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        offer_listing_id = dictionary.get('OfferListingId')
        price = aws_apimatic.models.price.Price.from_dictionary(dictionary.get('Price')) if dictionary.get('Price') else None
        sale_price = aws_apimatic.models.price.Price.from_dictionary(dictionary.get('SalePrice')) if dictionary.get('SalePrice') else None
        amount_saved = aws_apimatic.models.price.Price.from_dictionary(dictionary.get('AmountSaved')) if dictionary.get('AmountSaved') else None
        percentage_saved = dictionary.get('PercentageSaved')
        availability = dictionary.get('Availability')
        availability_attributes = aws_apimatic.models.availability_attributes.AvailabilityAttributes.from_dictionary(dictionary.get('AvailabilityAttributes')) if dictionary.get('AvailabilityAttributes') else None
        is_eligible_for_super_saver_shipping = dictionary.get('IsEligibleForSuperSaverShipping')
        is_eligible_for_prime = dictionary.get('IsEligibleForPrime')

        # Return an object of this model
        return cls(offer_listing_id,
                   price,
                   sale_price,
                   amount_saved,
                   percentage_saved,
                   availability,
                   availability_attributes,
                   is_eligible_for_super_saver_shipping,
                   is_eligible_for_prime)


