# -*- coding: utf-8 -*-

"""
    aws_apimatic

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

import aws_apimatic.models.catalog_number_list
import aws_apimatic.models.creator
import aws_apimatic.models.ean_list
import aws_apimatic.models.item_dimensions
import aws_apimatic.models.languages
import aws_apimatic.models.price
import aws_apimatic.models.decimal_with_units
import aws_apimatic.models.package_dimensions
import aws_apimatic.models.non_negative_integer_with_units
import aws_apimatic.models.upc_list

class ItemAttributes(object):

    """Implementation of the 'ItemAttributes' model.

    TODO: type model description here.

    Attributes:
        actor (list of string): TODO: type description here.
        artist (list of string): TODO: type description here.
        aspect_ratio (string): TODO: type description here.
        audience_rating (string): TODO: type description here.
        audio_format (list of string): TODO: type description here.
        author (list of string): TODO: type description here.
        binding (string): TODO: type description here.
        brand (string): TODO: type description here.
        catalog_number_list (CatalogNumberList): TODO: type description here.
        category (list of string): TODO: type description here.
        cero_age_rating (string): TODO: type description here.
        clothing_size (string): TODO: type description here.
        color (string): TODO: type description here.
        creator (list of Creator): TODO: type description here.
        department (string): TODO: type description here.
        director (list of string): TODO: type description here.
        ean (string): TODO: type description here.
        ean_list (EANList): TODO: type description here.
        edition (string): TODO: type description here.
        eisbn (list of string): TODO: type description here.
        episode_sequence (string): TODO: type description here.
        esrb_age_rating (string): TODO: type description here.
        feature (list of string): TODO: type description here.
        format (list of string): TODO: type description here.
        genre (string): TODO: type description here.
        hardware_platform (string): TODO: type description here.
        hazardous_material_type (string): TODO: type description here.
        is_adult_product (bool): TODO: type description here.
        is_autographed (bool): TODO: type description here.
        isbn (string): TODO: type description here.
        is_eligible_for_trade_in (bool): TODO: type description here.
        is_memorabilia (bool): TODO: type description here.
        issues_per_year (string): TODO: type description here.
        item_dimensions (ItemDimensions): TODO: type description here.
        item_part_number (string): TODO: type description here.
        label (string): TODO: type description here.
        languages (Languages): TODO: type description here.
        legal_disclaimer (string): TODO: type description here.
        list_price (Price): TODO: type description here.
        magazine_type (string): TODO: type description here.
        manufacturer (string): TODO: type description here.
        manufacturer_maximum_age (DecimalWithUnits): TODO: type description
            here.
        manufacturer_minimum_age (DecimalWithUnits): TODO: type description
            here.
        manufacturer_parts_warranty_description (string): TODO: type
            description here.
        media_type (string): TODO: type description here.
        model (string): TODO: type description here.
        model_year (int): TODO: type description here.
        mpn (string): TODO: type description here.
        number_of_discs (int): TODO: type description here.
        number_of_issues (int): TODO: type description here.
        number_of_items (int): TODO: type description here.
        number_of_pages (int): TODO: type description here.
        number_of_tracks (int): TODO: type description here.
        operating_system (string): TODO: type description here.
        package_dimensions (PackageDimensions): TODO: type description here.
        package_quantity (int): TODO: type description here.
        part_number (string): TODO: type description here.
        picture_format (list of string): TODO: type description here.
        platform (list of string): TODO: type description here.
        product_group (string): TODO: type description here.
        product_type_name (string): TODO: type description here.
        product_type_subcategory (string): TODO: type description here.
        publication_date (string): TODO: type description here.
        publisher (string): TODO: type description here.
        region_code (string): TODO: type description here.
        release_date (string): TODO: type description here.
        running_time (DecimalWithUnits): TODO: type description here.
        seikodo_product_code (string): TODO: type description here.
        size (string): TODO: type description here.
        sku (string): TODO: type description here.
        studio (string): TODO: type description here.
        subscription_length (NonNegativeIntegerWithUnits): TODO: type
            description here.
        title (string): TODO: type description here.
        track_sequence (string): TODO: type description here.
        trade_in_value (Price): TODO: type description here.
        upc (string): TODO: type description here.
        upc_list (UPCList): TODO: type description here.
        warranty (string): TODO: type description here.
        weee_tax_value (Price): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "actor":'Actor',
        "artist":'Artist',
        "aspect_ratio":'AspectRatio',
        "audience_rating":'AudienceRating',
        "audio_format":'AudioFormat',
        "author":'Author',
        "binding":'Binding',
        "brand":'Brand',
        "catalog_number_list":'CatalogNumberList',
        "category":'Category',
        "cero_age_rating":'CEROAgeRating',
        "clothing_size":'ClothingSize',
        "color":'Color',
        "creator":'Creator',
        "department":'Department',
        "director":'Director',
        "ean":'EAN',
        "ean_list":'EANList',
        "edition":'Edition',
        "eisbn":'EISBN',
        "episode_sequence":'EpisodeSequence',
        "esrb_age_rating":'ESRBAgeRating',
        "feature":'Feature',
        "format":'Format',
        "genre":'Genre',
        "hardware_platform":'HardwarePlatform',
        "hazardous_material_type":'HazardousMaterialType',
        "is_adult_product":'IsAdultProduct',
        "is_autographed":'IsAutographed',
        "isbn":'ISBN',
        "is_eligible_for_trade_in":'IsEligibleForTradeIn',
        "is_memorabilia":'IsMemorabilia',
        "issues_per_year":'IssuesPerYear',
        "item_dimensions":'ItemDimensions',
        "item_part_number":'ItemPartNumber',
        "label":'Label',
        "languages":'Languages',
        "legal_disclaimer":'LegalDisclaimer',
        "list_price":'ListPrice',
        "magazine_type":'MagazineType',
        "manufacturer":'Manufacturer',
        "manufacturer_maximum_age":'ManufacturerMaximumAge',
        "manufacturer_minimum_age":'ManufacturerMinimumAge',
        "manufacturer_parts_warranty_description":'ManufacturerPartsWarrantyDescription',
        "media_type":'MediaType',
        "model":'Model',
        "model_year":'ModelYear',
        "mpn":'MPN',
        "number_of_discs":'NumberOfDiscs',
        "number_of_issues":'NumberOfIssues',
        "number_of_items":'NumberOfItems',
        "number_of_pages":'NumberOfPages',
        "number_of_tracks":'NumberOfTracks',
        "operating_system":'OperatingSystem',
        "package_dimensions":'PackageDimensions',
        "package_quantity":'PackageQuantity',
        "part_number":'PartNumber',
        "picture_format":'PictureFormat',
        "platform":'Platform',
        "product_group":'ProductGroup',
        "product_type_name":'ProductTypeName',
        "product_type_subcategory":'ProductTypeSubcategory',
        "publication_date":'PublicationDate',
        "publisher":'Publisher',
        "region_code":'RegionCode',
        "release_date":'ReleaseDate',
        "running_time":'RunningTime',
        "seikodo_product_code":'SeikodoProductCode',
        "size":'Size',
        "sku":'SKU',
        "studio":'Studio',
        "subscription_length":'SubscriptionLength',
        "title":'Title',
        "track_sequence":'TrackSequence',
        "trade_in_value":'TradeInValue',
        "upc":'UPC',
        "upc_list":'UPCList',
        "warranty":'Warranty',
        "weee_tax_value":'WEEETaxValue'
    }

    def __init__(self,
                 actor=None,
                 artist=None,
                 aspect_ratio=None,
                 audience_rating=None,
                 audio_format=None,
                 author=None,
                 binding=None,
                 brand=None,
                 catalog_number_list=None,
                 category=None,
                 cero_age_rating=None,
                 clothing_size=None,
                 color=None,
                 creator=None,
                 department=None,
                 director=None,
                 ean=None,
                 ean_list=None,
                 edition=None,
                 eisbn=None,
                 episode_sequence=None,
                 esrb_age_rating=None,
                 feature=None,
                 format=None,
                 genre=None,
                 hardware_platform=None,
                 hazardous_material_type=None,
                 is_adult_product=None,
                 is_autographed=None,
                 isbn=None,
                 is_eligible_for_trade_in=None,
                 is_memorabilia=None,
                 issues_per_year=None,
                 item_dimensions=None,
                 item_part_number=None,
                 label=None,
                 languages=None,
                 legal_disclaimer=None,
                 list_price=None,
                 magazine_type=None,
                 manufacturer=None,
                 manufacturer_maximum_age=None,
                 manufacturer_minimum_age=None,
                 manufacturer_parts_warranty_description=None,
                 media_type=None,
                 model=None,
                 model_year=None,
                 mpn=None,
                 number_of_discs=None,
                 number_of_issues=None,
                 number_of_items=None,
                 number_of_pages=None,
                 number_of_tracks=None,
                 operating_system=None,
                 package_dimensions=None,
                 package_quantity=None,
                 part_number=None,
                 picture_format=None,
                 platform=None,
                 product_group=None,
                 product_type_name=None,
                 product_type_subcategory=None,
                 publication_date=None,
                 publisher=None,
                 region_code=None,
                 release_date=None,
                 running_time=None,
                 seikodo_product_code=None,
                 size=None,
                 sku=None,
                 studio=None,
                 subscription_length=None,
                 title=None,
                 track_sequence=None,
                 trade_in_value=None,
                 upc=None,
                 upc_list=None,
                 warranty=None,
                 weee_tax_value=None):
        """Constructor for the ItemAttributes class"""

        # Initialize members of the class
        self.actor = actor
        self.artist = artist
        self.aspect_ratio = aspect_ratio
        self.audience_rating = audience_rating
        self.audio_format = audio_format
        self.author = author
        self.binding = binding
        self.brand = brand
        self.catalog_number_list = catalog_number_list
        self.category = category
        self.cero_age_rating = cero_age_rating
        self.clothing_size = clothing_size
        self.color = color
        self.creator = creator
        self.department = department
        self.director = director
        self.ean = ean
        self.ean_list = ean_list
        self.edition = edition
        self.eisbn = eisbn
        self.episode_sequence = episode_sequence
        self.esrb_age_rating = esrb_age_rating
        self.feature = feature
        self.format = format
        self.genre = genre
        self.hardware_platform = hardware_platform
        self.hazardous_material_type = hazardous_material_type
        self.is_adult_product = is_adult_product
        self.is_autographed = is_autographed
        self.isbn = isbn
        self.is_eligible_for_trade_in = is_eligible_for_trade_in
        self.is_memorabilia = is_memorabilia
        self.issues_per_year = issues_per_year
        self.item_dimensions = item_dimensions
        self.item_part_number = item_part_number
        self.label = label
        self.languages = languages
        self.legal_disclaimer = legal_disclaimer
        self.list_price = list_price
        self.magazine_type = magazine_type
        self.manufacturer = manufacturer
        self.manufacturer_maximum_age = manufacturer_maximum_age
        self.manufacturer_minimum_age = manufacturer_minimum_age
        self.manufacturer_parts_warranty_description = manufacturer_parts_warranty_description
        self.media_type = media_type
        self.model = model
        self.model_year = model_year
        self.mpn = mpn
        self.number_of_discs = number_of_discs
        self.number_of_issues = number_of_issues
        self.number_of_items = number_of_items
        self.number_of_pages = number_of_pages
        self.number_of_tracks = number_of_tracks
        self.operating_system = operating_system
        self.package_dimensions = package_dimensions
        self.package_quantity = package_quantity
        self.part_number = part_number
        self.picture_format = picture_format
        self.platform = platform
        self.product_group = product_group
        self.product_type_name = product_type_name
        self.product_type_subcategory = product_type_subcategory
        self.publication_date = publication_date
        self.publisher = publisher
        self.region_code = region_code
        self.release_date = release_date
        self.running_time = running_time
        self.seikodo_product_code = seikodo_product_code
        self.size = size
        self.sku = sku
        self.studio = studio
        self.subscription_length = subscription_length
        self.title = title
        self.track_sequence = track_sequence
        self.trade_in_value = trade_in_value
        self.upc = upc
        self.upc_list = upc_list
        self.warranty = warranty
        self.weee_tax_value = weee_tax_value


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        actor = dictionary.get('Actor')
        artist = dictionary.get('Artist')
        aspect_ratio = dictionary.get('AspectRatio')
        audience_rating = dictionary.get('AudienceRating')
        audio_format = dictionary.get('AudioFormat')
        author = dictionary.get('Author')
        binding = dictionary.get('Binding')
        brand = dictionary.get('Brand')
        catalog_number_list = aws_apimatic.models.catalog_number_list.CatalogNumberList.from_dictionary(dictionary.get('CatalogNumberList')) if dictionary.get('CatalogNumberList') else None
        category = dictionary.get('Category')
        cero_age_rating = dictionary.get('CEROAgeRating')
        clothing_size = dictionary.get('ClothingSize')
        color = dictionary.get('Color')
        creator = None
        if dictionary.get('Creator') != None:
            creator = list()
            for structure in dictionary.get('Creator'):
                creator.append(aws_apimatic.models.creator.Creator.from_dictionary(structure))
        department = dictionary.get('Department')
        director = dictionary.get('Director')
        ean = dictionary.get('EAN')
        ean_list = aws_apimatic.models.ean_list.EANList.from_dictionary(dictionary.get('EANList')) if dictionary.get('EANList') else None
        edition = dictionary.get('Edition')
        eisbn = dictionary.get('EISBN')
        episode_sequence = dictionary.get('EpisodeSequence')
        esrb_age_rating = dictionary.get('ESRBAgeRating')
        feature = dictionary.get('Feature')
        format = dictionary.get('Format')
        genre = dictionary.get('Genre')
        hardware_platform = dictionary.get('HardwarePlatform')
        hazardous_material_type = dictionary.get('HazardousMaterialType')
        is_adult_product = dictionary.get('IsAdultProduct')
        is_autographed = dictionary.get('IsAutographed')
        isbn = dictionary.get('ISBN')
        is_eligible_for_trade_in = dictionary.get('IsEligibleForTradeIn')
        is_memorabilia = dictionary.get('IsMemorabilia')
        issues_per_year = dictionary.get('IssuesPerYear')
        item_dimensions = aws_apimatic.models.item_dimensions.ItemDimensions.from_dictionary(dictionary.get('ItemDimensions')) if dictionary.get('ItemDimensions') else None
        item_part_number = dictionary.get('ItemPartNumber')
        label = dictionary.get('Label')
        languages = aws_apimatic.models.languages.Languages.from_dictionary(dictionary.get('Languages')) if dictionary.get('Languages') else None
        legal_disclaimer = dictionary.get('LegalDisclaimer')
        list_price = aws_apimatic.models.price.Price.from_dictionary(dictionary.get('ListPrice')) if dictionary.get('ListPrice') else None
        magazine_type = dictionary.get('MagazineType')
        manufacturer = dictionary.get('Manufacturer')
        manufacturer_maximum_age = aws_apimatic.models.decimal_with_units.DecimalWithUnits.from_dictionary(dictionary.get('ManufacturerMaximumAge')) if dictionary.get('ManufacturerMaximumAge') else None
        manufacturer_minimum_age = aws_apimatic.models.decimal_with_units.DecimalWithUnits.from_dictionary(dictionary.get('ManufacturerMinimumAge')) if dictionary.get('ManufacturerMinimumAge') else None
        manufacturer_parts_warranty_description = dictionary.get('ManufacturerPartsWarrantyDescription')
        media_type = dictionary.get('MediaType')
        model = dictionary.get('Model')
        model_year = dictionary.get('ModelYear')
        mpn = dictionary.get('MPN')
        number_of_discs = dictionary.get('NumberOfDiscs')
        number_of_issues = dictionary.get('NumberOfIssues')
        number_of_items = dictionary.get('NumberOfItems')
        number_of_pages = dictionary.get('NumberOfPages')
        number_of_tracks = dictionary.get('NumberOfTracks')
        operating_system = dictionary.get('OperatingSystem')
        package_dimensions = aws_apimatic.models.package_dimensions.PackageDimensions.from_dictionary(dictionary.get('PackageDimensions')) if dictionary.get('PackageDimensions') else None
        package_quantity = dictionary.get('PackageQuantity')
        part_number = dictionary.get('PartNumber')
        picture_format = dictionary.get('PictureFormat')
        platform = dictionary.get('Platform')
        product_group = dictionary.get('ProductGroup')
        product_type_name = dictionary.get('ProductTypeName')
        product_type_subcategory = dictionary.get('ProductTypeSubcategory')
        publication_date = dictionary.get('PublicationDate')
        publisher = dictionary.get('Publisher')
        region_code = dictionary.get('RegionCode')
        release_date = dictionary.get('ReleaseDate')
        running_time = aws_apimatic.models.decimal_with_units.DecimalWithUnits.from_dictionary(dictionary.get('RunningTime')) if dictionary.get('RunningTime') else None
        seikodo_product_code = dictionary.get('SeikodoProductCode')
        size = dictionary.get('Size')
        sku = dictionary.get('SKU')
        studio = dictionary.get('Studio')
        subscription_length = aws_apimatic.models.non_negative_integer_with_units.NonNegativeIntegerWithUnits.from_dictionary(dictionary.get('SubscriptionLength')) if dictionary.get('SubscriptionLength') else None
        title = dictionary.get('Title')
        track_sequence = dictionary.get('TrackSequence')
        trade_in_value = aws_apimatic.models.price.Price.from_dictionary(dictionary.get('TradeInValue')) if dictionary.get('TradeInValue') else None
        upc = dictionary.get('UPC')
        upc_list = aws_apimatic.models.upc_list.UPCList.from_dictionary(dictionary.get('UPCList')) if dictionary.get('UPCList') else None
        warranty = dictionary.get('Warranty')
        weee_tax_value = aws_apimatic.models.price.Price.from_dictionary(dictionary.get('WEEETaxValue')) if dictionary.get('WEEETaxValue') else None

        # Return an object of this model
        return cls(actor,
                   artist,
                   aspect_ratio,
                   audience_rating,
                   audio_format,
                   author,
                   binding,
                   brand,
                   catalog_number_list,
                   category,
                   cero_age_rating,
                   clothing_size,
                   color,
                   creator,
                   department,
                   director,
                   ean,
                   ean_list,
                   edition,
                   eisbn,
                   episode_sequence,
                   esrb_age_rating,
                   feature,
                   format,
                   genre,
                   hardware_platform,
                   hazardous_material_type,
                   is_adult_product,
                   is_autographed,
                   isbn,
                   is_eligible_for_trade_in,
                   is_memorabilia,
                   issues_per_year,
                   item_dimensions,
                   item_part_number,
                   label,
                   languages,
                   legal_disclaimer,
                   list_price,
                   magazine_type,
                   manufacturer,
                   manufacturer_maximum_age,
                   manufacturer_minimum_age,
                   manufacturer_parts_warranty_description,
                   media_type,
                   model,
                   model_year,
                   mpn,
                   number_of_discs,
                   number_of_issues,
                   number_of_items,
                   number_of_pages,
                   number_of_tracks,
                   operating_system,
                   package_dimensions,
                   package_quantity,
                   part_number,
                   picture_format,
                   platform,
                   product_group,
                   product_type_name,
                   product_type_subcategory,
                   publication_date,
                   publisher,
                   region_code,
                   release_date,
                   running_time,
                   seikodo_product_code,
                   size,
                   sku,
                   studio,
                   subscription_length,
                   title,
                   track_sequence,
                   trade_in_value,
                   upc,
                   upc_list,
                   warranty,
                   weee_tax_value)


