# -*- coding: utf-8 -*-

"""
    aws_apimatic

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

import aws_apimatic.models.errors
import aws_apimatic.models.item_links
import aws_apimatic.models.image
import aws_apimatic.models.image_sets
import aws_apimatic.models.item_attributes
import aws_apimatic.models.variation_attributes
import aws_apimatic.models.related_items_3
import aws_apimatic.models.collections
import aws_apimatic.models.subjects
import aws_apimatic.models.offer_summary
import aws_apimatic.models.offers
import aws_apimatic.models.variation_summary
import aws_apimatic.models.variations_3
import aws_apimatic.models.customer_reviews
import aws_apimatic.models.editorial_reviews
import aws_apimatic.models.similar_products
import aws_apimatic.models.accessories
import aws_apimatic.models.tracks
import aws_apimatic.models.browse_nodes
import aws_apimatic.models.alternate_versions

class Item3(object):

    """Implementation of the 'Item3' model.

    TODO: type model description here.

    Attributes:
        asin (string): TODO: type description here.
        parent_asin (string): TODO: type description here.
        errors (Errors): TODO: type description here.
        detail_page_url (string): TODO: type description here.
        item_links (ItemLinks): TODO: type description here.
        sales_rank (string): TODO: type description here.
        small_image (Image): TODO: type description here.
        medium_image (Image): TODO: type description here.
        large_image (Image): TODO: type description here.
        image_sets (list of ImageSets): TODO: type description here.
        item_attributes (ItemAttributes): TODO: type description here.
        variation_attributes (VariationAttributes): TODO: type description
            here.
        related_items (list of RelatedItems3): TODO: type description here.
        collections (Collections): TODO: type description here.
        subjects (Subjects): TODO: type description here.
        offer_summary (OfferSummary): TODO: type description here.
        offers (Offers): TODO: type description here.
        variation_summary (VariationSummary): TODO: type description here.
        variations (Variations3): TODO: type description here.
        customer_reviews (CustomerReviews): TODO: type description here.
        editorial_reviews (EditorialReviews): TODO: type description here.
        similar_products (SimilarProducts): TODO: type description here.
        accessories (Accessories): TODO: type description here.
        tracks (Tracks): TODO: type description here.
        browse_nodes (BrowseNodes): TODO: type description here.
        alternate_versions (AlternateVersions): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "asin":'ASIN',
        "parent_asin":'ParentASIN',
        "errors":'Errors',
        "detail_page_url":'DetailPageURL',
        "item_links":'ItemLinks',
        "sales_rank":'SalesRank',
        "small_image":'SmallImage',
        "medium_image":'MediumImage',
        "large_image":'LargeImage',
        "image_sets":'ImageSets',
        "item_attributes":'ItemAttributes',
        "variation_attributes":'VariationAttributes',
        "related_items":'RelatedItems',
        "collections":'Collections',
        "subjects":'Subjects',
        "offer_summary":'OfferSummary',
        "offers":'Offers',
        "variation_summary":'VariationSummary',
        "variations":'Variations',
        "customer_reviews":'CustomerReviews',
        "editorial_reviews":'EditorialReviews',
        "similar_products":'SimilarProducts',
        "accessories":'Accessories',
        "tracks":'Tracks',
        "browse_nodes":'BrowseNodes',
        "alternate_versions":'AlternateVersions'
    }

    def __init__(self,
                 asin=None,
                 parent_asin=None,
                 errors=None,
                 detail_page_url=None,
                 item_links=None,
                 sales_rank=None,
                 small_image=None,
                 medium_image=None,
                 large_image=None,
                 image_sets=None,
                 item_attributes=None,
                 variation_attributes=None,
                 related_items=None,
                 collections=None,
                 subjects=None,
                 offer_summary=None,
                 offers=None,
                 variation_summary=None,
                 variations=None,
                 customer_reviews=None,
                 editorial_reviews=None,
                 similar_products=None,
                 accessories=None,
                 tracks=None,
                 browse_nodes=None,
                 alternate_versions=None):
        """Constructor for the Item3 class"""

        # Initialize members of the class
        self.asin = asin
        self.parent_asin = parent_asin
        self.errors = errors
        self.detail_page_url = detail_page_url
        self.item_links = item_links
        self.sales_rank = sales_rank
        self.small_image = small_image
        self.medium_image = medium_image
        self.large_image = large_image
        self.image_sets = image_sets
        self.item_attributes = item_attributes
        self.variation_attributes = variation_attributes
        self.related_items = related_items
        self.collections = collections
        self.subjects = subjects
        self.offer_summary = offer_summary
        self.offers = offers
        self.variation_summary = variation_summary
        self.variations = variations
        self.customer_reviews = customer_reviews
        self.editorial_reviews = editorial_reviews
        self.similar_products = similar_products
        self.accessories = accessories
        self.tracks = tracks
        self.browse_nodes = browse_nodes
        self.alternate_versions = alternate_versions


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        asin = dictionary.get('ASIN')
        parent_asin = dictionary.get('ParentASIN')
        errors = aws_apimatic.models.errors.Errors.from_dictionary(dictionary.get('Errors')) if dictionary.get('Errors') else None
        detail_page_url = dictionary.get('DetailPageURL')
        item_links = aws_apimatic.models.item_links.ItemLinks.from_dictionary(dictionary.get('ItemLinks')) if dictionary.get('ItemLinks') else None
        sales_rank = dictionary.get('SalesRank')
        small_image = aws_apimatic.models.image.Image.from_dictionary(dictionary.get('SmallImage')) if dictionary.get('SmallImage') else None
        medium_image = aws_apimatic.models.image.Image.from_dictionary(dictionary.get('MediumImage')) if dictionary.get('MediumImage') else None
        large_image = aws_apimatic.models.image.Image.from_dictionary(dictionary.get('LargeImage')) if dictionary.get('LargeImage') else None
        image_sets = None
        if dictionary.get('ImageSets') != None:
            image_sets = list()
            for structure in dictionary.get('ImageSets'):
                image_sets.append(aws_apimatic.models.image_sets.ImageSets.from_dictionary(structure))
        item_attributes = aws_apimatic.models.item_attributes.ItemAttributes.from_dictionary(dictionary.get('ItemAttributes')) if dictionary.get('ItemAttributes') else None
        variation_attributes = aws_apimatic.models.variation_attributes.VariationAttributes.from_dictionary(dictionary.get('VariationAttributes')) if dictionary.get('VariationAttributes') else None
        related_items = None
        if dictionary.get('RelatedItems') != None:
            related_items = list()
            for structure in dictionary.get('RelatedItems'):
                related_items.append(aws_apimatic.models.related_items_3.RelatedItems3.from_dictionary(structure))
        collections = aws_apimatic.models.collections.Collections.from_dictionary(dictionary.get('Collections')) if dictionary.get('Collections') else None
        subjects = aws_apimatic.models.subjects.Subjects.from_dictionary(dictionary.get('Subjects')) if dictionary.get('Subjects') else None
        offer_summary = aws_apimatic.models.offer_summary.OfferSummary.from_dictionary(dictionary.get('OfferSummary')) if dictionary.get('OfferSummary') else None
        offers = aws_apimatic.models.offers.Offers.from_dictionary(dictionary.get('Offers')) if dictionary.get('Offers') else None
        variation_summary = aws_apimatic.models.variation_summary.VariationSummary.from_dictionary(dictionary.get('VariationSummary')) if dictionary.get('VariationSummary') else None
        variations = aws_apimatic.models.variations_3.Variations3.from_dictionary(dictionary.get('Variations')) if dictionary.get('Variations') else None
        customer_reviews = aws_apimatic.models.customer_reviews.CustomerReviews.from_dictionary(dictionary.get('CustomerReviews')) if dictionary.get('CustomerReviews') else None
        editorial_reviews = aws_apimatic.models.editorial_reviews.EditorialReviews.from_dictionary(dictionary.get('EditorialReviews')) if dictionary.get('EditorialReviews') else None
        similar_products = aws_apimatic.models.similar_products.SimilarProducts.from_dictionary(dictionary.get('SimilarProducts')) if dictionary.get('SimilarProducts') else None
        accessories = aws_apimatic.models.accessories.Accessories.from_dictionary(dictionary.get('Accessories')) if dictionary.get('Accessories') else None
        tracks = aws_apimatic.models.tracks.Tracks.from_dictionary(dictionary.get('Tracks')) if dictionary.get('Tracks') else None
        browse_nodes = aws_apimatic.models.browse_nodes.BrowseNodes.from_dictionary(dictionary.get('BrowseNodes')) if dictionary.get('BrowseNodes') else None
        alternate_versions = aws_apimatic.models.alternate_versions.AlternateVersions.from_dictionary(dictionary.get('AlternateVersions')) if dictionary.get('AlternateVersions') else None

        # Return an object of this model
        return cls(asin,
                   parent_asin,
                   errors,
                   detail_page_url,
                   item_links,
                   sales_rank,
                   small_image,
                   medium_image,
                   large_image,
                   image_sets,
                   item_attributes,
                   variation_attributes,
                   related_items,
                   collections,
                   subjects,
                   offer_summary,
                   offers,
                   variation_summary,
                   variations,
                   customer_reviews,
                   editorial_reviews,
                   similar_products,
                   accessories,
                   tracks,
                   browse_nodes,
                   alternate_versions)


