'''Hard coded sensitivity map coefficients.'''

import numpy as np

def _sens_info():
    '''Gives back max coil number of coefficient number.'''
    return (8, 36)

def _sens_coeffs(coil): # pylint: disable=R0911
    '''Get coefficients for a specified coil.

    Notes
    -----
    36 coefficients per coil for the sinusoidal model generated
    from MRIPhantomv0-8, the publicly available software implementing
    the simulations described in [1]_.

    References
    ----------
    .. [1] Guerquin-Kern, Matthieu, et al. "Realistic analytical
           phantoms for parallel magnetic resonance imaging." IEEE
           Transactions on Medical Imaging 31.3 (2011): 626-636.
    '''

    if coil == 0: # pylint: disable=R1705
        return np.array([
            -0.000492664219250141 + 1j*0.00243037030094894,
            0.00288946657806461 - 1j*0.0191953858873134,
            -0.0105363006844095 + 1j*0.0604610659193525,
            0.0123853502735897 - 1j*0.0498374567765950,
            -0.00920408874684275 + 1j*0.0632845329625142,
            0.000358598059238050 + 1j*0.00886701389084563,
            0.00645262995711814 - 1j*0.0182997469567540,
            -0.0328076839647385 + 1j*0.116198254053013,
            0.0970803563718276 - 1j*0.321177633203026,
            -0.0924917219105432 + 1j*0.268528368797592,
            0.0994252928740797 - 1j*0.364066053176325,
            0.00565798833135565 - 1j*0.0205519023643655,
            -0.0206307938009781 + 1j*0.0391029102728882,
            0.0968133297287673 - 1j*0.233376312887876,
            -0.284306917206684 + 1j*0.617834442330665,
            0.183831538361748 - 1j*0.479067748004636,
            -0.382566338838651 + 1j*0.784963238439850,
            -0.0539076836006006 + 1j*0.0145083005519064,
            0.0264749266590882 - 1j*0.0384068553572631,
            -0.119075268977974 + 1j*0.225947079198774,
            0.366353467253556 - 1j*0.563603308160651,
            -0.00358007731333339 + 1j*0.560884763756737,
            0.698932486022485 - 1j*0.628501321493744,
            0.106334123825640 + 1j*0.0453847095309302,
            -0.0181759737892232 + 1j*0.0192041302884170,
            0.0791973819444809 - 1j*0.113540172966128,
            -0.232144207338682 + 1j*0.256828009838755,
            0.119777704004100 - 1j*0.382440894863609,
            -0.335998743363731 + 1j*0.178143558404030,
            -0.0616998473985501 - 1j*0.0723375921161177,
            0.00455184937485216 - 1j*0.00434890477621278,
            -0.0188662948731477 + 1j*0.0250391414594276,
            0.0536330339773302 - 1j*0.0520265897786916,
            -0.0393352758692265 + 1j*0.0839873355700759,
            0.0605138699329783 - 1j*0.0350950211228288,
            0.0112409538079848 + 1j*0.0248312140327601,
        ])
    elif coil == 1:
        return np.array([
            -0.00956241130456954 + 1j*0.00156653946533055,
            0.0309876036478494 - 1j*0.0205537278839346,
            -0.0187025845774524 + 1j*0.0371122302331996,
            -0.0139635648497960 - 1j*0.0193195637543548,
            -0.000672592100132901 + 1j*0.00376658834549303,
            0.00676889199178495 - 1j*0.0109424244569291,
            0.0449221837319027 - 1j*0.00872466326237302,
            -0.117816950962886 + 1j*0.100274149950925,
            -0.0138255225943290 - 1j*0.178315396712702,
            0.212523607922321 + 1j*0.0575554027425233,
            -0.0768665496990723 + 1j*0.0345949928216433,
            -0.0170620894139730 + 1j*0.0298358291038496,
            -0.0871169636851187 + 1j*0.0219924239679595,
            0.175267041701270 - 1j*0.259147827329896,
            0.275520926541241 + 1j*0.524633185340085,
            -0.852803286090846 - 1j*0.198300146035270,
            0.378030617825268 - 1j*0.135819863784762,
            0.00158685630296146 - 1j*0.0301218740420805,
            0.0968306549224374 - 1j*0.0400045025082063,
            -0.191284555591676 + 1j*0.429499256284854,
            -0.391254852281794 - 1j*1.07024972547781,
            1.51244620022761 + 1j*0.868098205325410,
            -0.834183357983501 + 1j*0.0975486177329785,
            0.0591784640092833 + 1j*0.00212442281335914,
            -0.0813687496323747 + 1j*0.0216356982383484,
            0.251058630937784 - 1j*0.296589840112616,
            -0.121414047923431 + 1j*0.864446412910811,
            -0.478396817102735 - 1j*1.15506630687338,
            0.637346705849207 + 1j*0.397653892480676,
            -0.0913916719660970 - 1j*0.0512956421003186,
            0.0244081296919280 + 1j*0.00531803728592769,
            -0.0985216638249861 + 1j*0.0397381167163568,
            0.138844236631109 - 1j*0.169201850198652,
            -0.0605317236107568 + 1j*0.283182228648837,
            -0.0485786826782856 - 1j*0.175242218900577,
            0.00764248775044418 + 1j*0.0365820512112688,
        ])
    elif coil == 2:
        return np.array([
            0.00182964949080146 + 1j*0.00634280011056676,
            -0.0236571454535515 - 1j*0.0460034167856479,
            0.0649111173166638 + 1j*0.0801406567470431,
            -0.0839405140172278 - 1j*0.0674690964470661,
            0.0526464364531807 + 1j*0.0334011103286731,
            -0.0131122925390921 - 1j*0.0140148125918288,
            -0.0108470489285766 - 1j*0.0546074518504042,
            0.122297044963639 + 1j*0.238343922849233,
            -0.346071087907648 - 1j*0.352355088805956,
            0.464546944615375 + 1j*0.215736287810939,
            -0.294415318790948 - 1j*0.0391020226281802,
            0.0762510493711607 + 1j*0.0112557389789623,
            0.0146588584243108 + 1j*0.0472516893589518,
            -0.144142565408624 - 1j*0.173966924451543,
            0.287650576268683 + 1j*0.146083125949715,
            -0.221265951461023 - 1j*0.0934083372850617,
            0.212326116200546 + 1j*0.0721585919708100,
            -0.0773691167160281 - 1j*0.0293954893378785,
            -0.0121635998535979 - 1j*0.0623477129110375,
            0.148512759914936 + 1j*0.256876864118714,
            -0.406752295834236 - 1j*0.395070052850959,
            0.643713528422027 + 1j*0.202856716250801,
            -0.338000004156961 + 1j*0.0230342748379312,
            0.0897533091067249 + 1j*0.000146570284552863,
            0.00266267135168796 + 1j*0.0123521571035339,
            -0.0481296074337264 - 1j*0.0470811072221052,
            0.0989601105919374 + 1j*0.0540540807050666,
            -0.108351337955726 - 1j*0.0356150392400832,
            0.0710961794021488 + 1j*0.0123359044112088,
            -0.0265020996137060 - 1j*0.00962193297388208,
            0.000279287662942785 - 1j*0.00637415546722498,
            0.0113964373954515 + 1j*0.0164494585503361,
            -0.0277430437937575 - 1j*0.0170186173682405,
            0.0360210330739931 + 1j*0.00587950010995889,
            -0.0241218043632039 + 1j*0.00512465030060340,
            0.00922602084033458 - 1j*0.00197821375017963,
        ])
    elif coil == 3:
        return np.array([
            0.0133278231763469 - 1j*0.00268387665373212,
            -0.0361790055917619 + 1j*0.00322439975914316,
            0.0478819391238289 + 1j*0.00507406846518691,
            -0.0540770846244794 + 1j*0.0107758025647362,
            0.0210931533129256 - 1j*0.0240584226351045,
            -0.00208397701904645 + 1j*0.00640399043936871,
            -0.0605176949094432 + 1j*0.0105080861124508,
            0.152736040369551 + 1j*0.00885712397172033,
            -0.215013653439257 - 1j*0.100593671268943,
            0.277381073095847 + 1j*0.0189348122847337,
            -0.114171276037050 + 1j*0.0940674723927208,
            0.00993066572602463 - 1j*0.0322639933212860,
            0.116592464794968 - 1j*0.0178744245578906,
            -0.283957268737453 - 1j*0.101015118685997,
            0.504885112210998 + 1j*0.453032318179049,
            -0.777208718364775 - 1j*0.216094258151972,
            0.326763454152545 - 1j*0.170779571550180,
            -0.0280976428636542 + 1j*0.0669682582817938,
            -0.127047085414481 + 1j*0.00586455162503473,
            0.375126091642891 + 1j*0.262704299547718,
            -0.986642654153836 - 1j*0.791299301192777,
            1.44693679707643 + 1j*0.0596071246997835,
            -0.458437929880372 + 1j*0.333616831997079,
            0.0352226532399997 - 1j*0.0931017146764022,
            0.0989707627419695 - 1j*0.00965562261393664,
            -0.400312961011323 - 1j*0.126339033818257,
            1.00164538332138 + 1j*0.120385712066303,
            -0.788774007435258 + 1j*0.441442448595346,
            0.187306701370282 - 1j*0.312675644689304,
            -0.00210247202720447 + 1j*0.0669395226024561,
            -0.0274941802102616 + 1j*0.0155267078625751,
            0.112523495315657 - 1j*0.0302934461541403,
            -0.211169706794697 + 1j*0.103875066327042,
            0.112311391758900 - 1j*0.166874208290763,
            -0.0102259485335030 + 1j*0.0841673577847456,
            -0.00617681909630503 - 1j*0.0148305402957110,
        ])
    elif coil == 4:
        return np.array([
            -7.48185149265112e-05 + 1j*0.00516275762824330,
            -0.00174176889829958 - 1j*0.0386841729120963,
            0.00227325485786134 + 1j*0.00886207938571848,
            -0.00157377595568348 - 1j*0.0399577936602698,
            -0.00121681784740104 + 1j*0.00294550326058959,
            0.00136548857244975 - 1j*0.00271345398997286,
            -0.00644560839550136 - 1j*0.0314364447742250,
            0.0510286831168461 + 1j*0.182224226170464,
            -0.0226310144554702 - 1j*0.00765301953272419,
            0.0539116031788077 + 1j*0.192874937342349,
            -0.00447357809220591 - 1j*0.0131662356717206,
            0.000255277926404633 + 1j*0.0105198860447555,
            0.0259440755300810 + 1j*0.0630993051192669,
            -0.200072778385486 - 1j*0.323647902076471,
            -0.0352860502894476 - 1j*0.0873006211931750,
            -0.227045971878928 - 1j*0.387104146009519,
            0.00425064194024299 + 1j*0.0181421078719024,
            -0.00835457486455963 - 1j*0.0161942500361693,
            -0.0355138461880176 - 1j*0.0615973501412102,
            0.294924523061690 + 1j*0.244866127079113,
            0.267851909082306 - 1j*0.0179606046977520,
            0.503836601346264 + 1j*0.240683771272753,
            0.00890330080357206 - 1j*0.0297907364944420,
            0.0156649309408487 + 1j*0.0106936614844816,
            0.0236353215507186 + 1j*0.0323757023780619,
            -0.183273278226507 - 1j*0.0719650831332364,
            -0.0625238254529838 + 1j*0.136285271616059,
            -0.202349821363512 - 1j*0.00438237746826400,
            -0.00200482849351820 + 1j*0.0307330947304155,
            -0.0105982782144391 - 1j*0.00204813087074893,
            -0.00569955758829129 - 1j*0.00776882805530411,
            0.0406587479295316 + 1j*0.00723427662396940,
            -0.00644858672247965 - 1j*0.0325118219871750,
            0.0398510064579053 - 1j*0.00214005272268495,
            -0.00346530858531124 - 1j*0.00899155846117303,
            0.00346192946646295 - 1j*0.000316839969664702,
        ])
    elif coil == 5:
        return np.array([
            -0.0160436399601781 - 1j*0.00104568099797589,
            0.0437681440818303 - 1j*0.00135413597126129,
            -0.0606790378083159 + 1j*0.0104224382405287,
            0.0658680388017238 + 1j*0.0104906730793231,
            -0.0250944940095110 - 1j*0.0271575428531017,
            0.000905819792192147 + 1j*0.00818660451321801,
            0.0479286905838672 - 1j*0.0144720645149328,
            -0.0945300981234173 + 1j*0.0654656490063275,
            0.0890528652650546 - 1j*0.208799492691168,
            -0.227532709427610 + 1j*0.162445029665056,
            0.132478026911858 + 1j*0.0325218660911599,
            -0.0175790162069052 - 1j*0.0258266066287878,
            -0.0612309396294614 + 1j*0.0152696817161254,
            0.0393777652002046 + 1j*0.00231588652381684,
            0.350264192960412 + 1j*0.198867429404195,
            -0.0311132691571883 - 1j*0.512506556761069,
            -0.146048479102237 + 1j*0.0891726717967961,
            0.0314592860534535 + 1j*0.0192986880547117,
            0.0701302082110552 - 1j*0.0139756568660155,
            -0.162839851445794 - 1j*0.0918127009799334,
            -0.189197214922133 + 1j*0.354377582713428,
            0.505854522355892 + 1j*0.0645668553171148,
            -0.0392335748419662 - 1j*0.0669033593175451,
            -0.0103178654052772 - 1j*0.0129043089022545,
            -0.0329914269759634 + 1j*0.0163337567849540,
            0.120469210285592 - 5.1j*38973136552594e-05,
            -0.0818817274792120 - 1j*0.164052371970252,
            -0.0859691377456902 + 1j*0.156905489531291,
            0.0241553557164762 - 1j*0.0462939939177741,
            0.00447435192325276 + 1j*0.0139180104134927,
            0.00585321797708395 - 1j*0.00366152248863734,
            -0.0259093278622887 + 1j*0.00817379906179217,
            0.0340619674250851 + 1j*0.0188691897172660,
            -0.0113361181904970 - 1j*0.0300532316472320,
            0.00665190286763589 + 1j*0.0150268021974821,
            -0.00240479967680472 - 1j*0.00317188836775697,
        ])
    elif coil == 6:
        return np.array([
            0.00120076488633541 + 1j*0.00130858181936933,
            0.00966408064730096 - 1j*0.0380021190452644,
            -0.0376652800791503 + 1j*0.0672578967185648,
            0.0510074999957827 - 1j*0.0589685214468620,
            -0.0283333538083088 + 1j*0.0299161871606381,
            0.00410424334316105 - 1j*0.0145171158607599,
            -0.000193235340387554 - 1j*0.0163908540804776,
            -0.0695543364086853 + 1j*0.209092909264309,
            0.231779975487885 - 1j*0.361059542026406,
            -0.300844560986952 + 1j*0.303549300463308,
            0.169135105178492 - 1j*0.147401412450277,
            -0.0260014373776601 + 1j*0.0654567010502466,
            -0.00844854093068747 + 1j*0.0618139355140194,
            0.194505727535588 - 1j*0.512992843403704,
            -0.608945064692439 + 1j*0.864851687755415,
            0.790714466939134 - 1j*0.693610547623309,
            -0.454541038199568 + 1j*0.306192220765383,
            0.0802466397144239 - 1j*0.123120483561329,
            0.0108434785453622 - 1j*0.0483595178429987,
            -0.205266962769157 + 1j*0.498133951546037,
            0.587623592193998 - 1j*0.839170483023760,
            -0.611989071464440 + 1j*0.768743442446836,
            0.406707171080851 - 1j*0.441556274823514,
            -0.0707198034713089 + 1j*0.167363593926821,
            -0.00478233308170053 + 1j*0.0408203100939254,
            0.136615559082020 - 1j*0.411787227135876,
            -0.494615657970040 + 1j*0.819573341954082,
            0.770669909303449 - 1j*0.672222100973348,
            -0.385232920580742 + 1j*0.263030096356219,
            0.0571290113097902 - 1j*0.103454223447298,
            -0.00273054780453027 + 1j*0.0185995932818987,
            0.00210483630241570 + 1j*0.00966900353434417,
            -0.0103651074611193 - 1j*0.0651111704552546,
            0.0341709499567731 + 1j*0.122456900524562,
            -0.0304012623934560 - 1j*0.115788721987205,
            0.0142014798544930 + 1j*0.0514979040646629,
        ])
    elif coil == 7:
        return np.array([
            0.0141897389622557 + 1j*0.00265211960585702,
            -0.0382164490648410 - 1j*0.0309440514439578,
            0.0246909301200210 + 1j*0.0596178218336907,
            0.0126832496575133 - 1j*0.0429314724825608,
            -9.12659116924964e-05 + 1j*0.0189822008800494,
            -0.00507662766588601 - 1j*0.0161160442247920,
            -0.0378871877921394 - 1j*0.0243495397393709,
            0.0544302551164823 + 1j*0.123498841856736,
            0.102444167300797 - 1j*0.119319866297676,
            -0.223084151814398 - 1j*0.107128674641694,
            0.0135311850409756 + 1j*0.122961290717477,
            0.0197218191518258 + 1j*0.0231597916875118,
            0.0450279349402413 + 1j*0.0279760714811036,
            -0.0372144005275439 - 1j*0.0756141819050891,
            -0.161710435619282 - 1j*0.239394009286191,
            0.0257749953069118 + 1j*0.818486325075431,
            0.410159049551182 - 1j*0.339719746887774,
            -0.0986915452164317 - 1j*0.0547676338154865,
            -0.0556094772562616 - 1j*0.0237572278638219,
            0.151535211704801 + 1j*0.0322829483753331,
            -0.286749613633589 + 1j*0.313824097142285,
            0.807020289396881 - 1j*0.497385974496736,
            -0.506281082544214 - 1j*0.124229223643603,
            0.0620202836829129 + 1j*0.115180756836566,
            0.0275233336003843 + 1j*0.0205526349999618,
            -0.100185495165116 - 1j*0.0658719002807295,
            0.233158498809583 + 1j*0.00683985640492514,
            -0.358313490800434 - 1j*0.0455415479748965,
            0.158345844306737 + 1j*0.137205111021237,
            -0.0115454126791044 - 1j*0.0575032042187928,
            -0.00512454741937440 - 1j*0.00510749436612668,
            0.0189130375230555 + 1j*0.0239368425341332,
            -0.0413940876259703 - 1j*0.0304812484038205,
            0.0533288722764838 + 1j*0.0378973034955824,
            -0.0195106170127051 - 1j*0.0369469896007646,
            3.25757603026116e-05 + 1j*0.0133411652471853,
        ])
    else:
        raise ValueError('Coil sensitivity coefficients not found!')
