# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FirewallPolicyArgs', 'FirewallPolicy']

@pulumi.input_type
class FirewallPolicyArgs:
    def __init__(__self__, *,
                 block_icmp_ping: Optional[pulumi.Input[bool]] = None,
                 block_metadata_service: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 inbound_networks: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyInboundNetworkArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outbound_networks: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyOutboundNetworkArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FirewallPolicy resource.
        :param pulumi.Input[bool] block_icmp_ping: Indicates whether policy includes blocking incoming 'ping' requests.
        :param pulumi.Input[bool] block_metadata_service: Indicates whether policy includes blocking metadata services of the cloud.
        :param pulumi.Input[str] description: Description of the Firewall Policy.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallPolicyInboundNetworkArgs']]] inbound_networks: Information on network addresses that are allowed to pass in data or requests.
        :param pulumi.Input[str] name: Name of the policy, no longer than 128 characters and no slash characters.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallPolicyOutboundNetworkArgs']]] outbound_networks: Information on network addresses that are allowed to receive data or requests.
        :param pulumi.Input[str] type: Indicates the class of protection defined by the firewall.
        :param pulumi.Input[str] version: Aqua version functionality supported
        """
        if block_icmp_ping is not None:
            pulumi.set(__self__, "block_icmp_ping", block_icmp_ping)
        if block_metadata_service is not None:
            pulumi.set(__self__, "block_metadata_service", block_metadata_service)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if inbound_networks is not None:
            pulumi.set(__self__, "inbound_networks", inbound_networks)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outbound_networks is not None:
            pulumi.set(__self__, "outbound_networks", outbound_networks)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="blockIcmpPing")
    def block_icmp_ping(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether policy includes blocking incoming 'ping' requests.
        """
        return pulumi.get(self, "block_icmp_ping")

    @block_icmp_ping.setter
    def block_icmp_ping(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_icmp_ping", value)

    @property
    @pulumi.getter(name="blockMetadataService")
    def block_metadata_service(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether policy includes blocking metadata services of the cloud.
        """
        return pulumi.get(self, "block_metadata_service")

    @block_metadata_service.setter
    def block_metadata_service(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_metadata_service", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the Firewall Policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="inboundNetworks")
    def inbound_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyInboundNetworkArgs']]]]:
        """
        Information on network addresses that are allowed to pass in data or requests.
        """
        return pulumi.get(self, "inbound_networks")

    @inbound_networks.setter
    def inbound_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyInboundNetworkArgs']]]]):
        pulumi.set(self, "inbound_networks", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the policy, no longer than 128 characters and no slash characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outboundNetworks")
    def outbound_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyOutboundNetworkArgs']]]]:
        """
        Information on network addresses that are allowed to receive data or requests.
        """
        return pulumi.get(self, "outbound_networks")

    @outbound_networks.setter
    def outbound_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyOutboundNetworkArgs']]]]):
        pulumi.set(self, "outbound_networks", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the class of protection defined by the firewall.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Aqua version functionality supported
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _FirewallPolicyState:
    def __init__(__self__, *,
                 author: Optional[pulumi.Input[str]] = None,
                 block_icmp_ping: Optional[pulumi.Input[bool]] = None,
                 block_metadata_service: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 inbound_networks: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyInboundNetworkArgs']]]] = None,
                 lastupdate: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outbound_networks: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyOutboundNetworkArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FirewallPolicy resources.
        :param pulumi.Input[str] author: Username of the account that created the policy.
        :param pulumi.Input[bool] block_icmp_ping: Indicates whether policy includes blocking incoming 'ping' requests.
        :param pulumi.Input[bool] block_metadata_service: Indicates whether policy includes blocking metadata services of the cloud.
        :param pulumi.Input[str] description: Description of the Firewall Policy.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallPolicyInboundNetworkArgs']]] inbound_networks: Information on network addresses that are allowed to pass in data or requests.
        :param pulumi.Input[int] lastupdate: Timestamp of the last update in Unix time format.
        :param pulumi.Input[str] name: Name of the policy, no longer than 128 characters and no slash characters.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallPolicyOutboundNetworkArgs']]] outbound_networks: Information on network addresses that are allowed to receive data or requests.
        :param pulumi.Input[str] type: Indicates the class of protection defined by the firewall.
        :param pulumi.Input[str] version: Aqua version functionality supported
        """
        if author is not None:
            pulumi.set(__self__, "author", author)
        if block_icmp_ping is not None:
            pulumi.set(__self__, "block_icmp_ping", block_icmp_ping)
        if block_metadata_service is not None:
            pulumi.set(__self__, "block_metadata_service", block_metadata_service)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if inbound_networks is not None:
            pulumi.set(__self__, "inbound_networks", inbound_networks)
        if lastupdate is not None:
            pulumi.set(__self__, "lastupdate", lastupdate)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outbound_networks is not None:
            pulumi.set(__self__, "outbound_networks", outbound_networks)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def author(self) -> Optional[pulumi.Input[str]]:
        """
        Username of the account that created the policy.
        """
        return pulumi.get(self, "author")

    @author.setter
    def author(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "author", value)

    @property
    @pulumi.getter(name="blockIcmpPing")
    def block_icmp_ping(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether policy includes blocking incoming 'ping' requests.
        """
        return pulumi.get(self, "block_icmp_ping")

    @block_icmp_ping.setter
    def block_icmp_ping(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_icmp_ping", value)

    @property
    @pulumi.getter(name="blockMetadataService")
    def block_metadata_service(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether policy includes blocking metadata services of the cloud.
        """
        return pulumi.get(self, "block_metadata_service")

    @block_metadata_service.setter
    def block_metadata_service(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_metadata_service", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the Firewall Policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="inboundNetworks")
    def inbound_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyInboundNetworkArgs']]]]:
        """
        Information on network addresses that are allowed to pass in data or requests.
        """
        return pulumi.get(self, "inbound_networks")

    @inbound_networks.setter
    def inbound_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyInboundNetworkArgs']]]]):
        pulumi.set(self, "inbound_networks", value)

    @property
    @pulumi.getter
    def lastupdate(self) -> Optional[pulumi.Input[int]]:
        """
        Timestamp of the last update in Unix time format.
        """
        return pulumi.get(self, "lastupdate")

    @lastupdate.setter
    def lastupdate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "lastupdate", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the policy, no longer than 128 characters and no slash characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outboundNetworks")
    def outbound_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyOutboundNetworkArgs']]]]:
        """
        Information on network addresses that are allowed to receive data or requests.
        """
        return pulumi.get(self, "outbound_networks")

    @outbound_networks.setter
    def outbound_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyOutboundNetworkArgs']]]]):
        pulumi.set(self, "outbound_networks", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the class of protection defined by the firewall.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Aqua version functionality supported
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class FirewallPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 block_icmp_ping: Optional[pulumi.Input[bool]] = None,
                 block_metadata_service: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 inbound_networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FirewallPolicyInboundNetworkArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outbound_networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FirewallPolicyOutboundNetworkArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a FirewallPolicy resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] block_icmp_ping: Indicates whether policy includes blocking incoming 'ping' requests.
        :param pulumi.Input[bool] block_metadata_service: Indicates whether policy includes blocking metadata services of the cloud.
        :param pulumi.Input[str] description: Description of the Firewall Policy.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FirewallPolicyInboundNetworkArgs']]]] inbound_networks: Information on network addresses that are allowed to pass in data or requests.
        :param pulumi.Input[str] name: Name of the policy, no longer than 128 characters and no slash characters.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FirewallPolicyOutboundNetworkArgs']]]] outbound_networks: Information on network addresses that are allowed to receive data or requests.
        :param pulumi.Input[str] type: Indicates the class of protection defined by the firewall.
        :param pulumi.Input[str] version: Aqua version functionality supported
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FirewallPolicyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a FirewallPolicy resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param FirewallPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirewallPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 block_icmp_ping: Optional[pulumi.Input[bool]] = None,
                 block_metadata_service: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 inbound_networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FirewallPolicyInboundNetworkArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outbound_networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FirewallPolicyOutboundNetworkArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirewallPolicyArgs.__new__(FirewallPolicyArgs)

            __props__.__dict__["block_icmp_ping"] = block_icmp_ping
            __props__.__dict__["block_metadata_service"] = block_metadata_service
            __props__.__dict__["description"] = description
            __props__.__dict__["inbound_networks"] = inbound_networks
            __props__.__dict__["name"] = name
            __props__.__dict__["outbound_networks"] = outbound_networks
            __props__.__dict__["type"] = type
            __props__.__dict__["version"] = version
            __props__.__dict__["author"] = None
            __props__.__dict__["lastupdate"] = None
        super(FirewallPolicy, __self__).__init__(
            'aquasec:index/firewallPolicy:FirewallPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            author: Optional[pulumi.Input[str]] = None,
            block_icmp_ping: Optional[pulumi.Input[bool]] = None,
            block_metadata_service: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            inbound_networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FirewallPolicyInboundNetworkArgs']]]]] = None,
            lastupdate: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            outbound_networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FirewallPolicyOutboundNetworkArgs']]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'FirewallPolicy':
        """
        Get an existing FirewallPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] author: Username of the account that created the policy.
        :param pulumi.Input[bool] block_icmp_ping: Indicates whether policy includes blocking incoming 'ping' requests.
        :param pulumi.Input[bool] block_metadata_service: Indicates whether policy includes blocking metadata services of the cloud.
        :param pulumi.Input[str] description: Description of the Firewall Policy.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FirewallPolicyInboundNetworkArgs']]]] inbound_networks: Information on network addresses that are allowed to pass in data or requests.
        :param pulumi.Input[int] lastupdate: Timestamp of the last update in Unix time format.
        :param pulumi.Input[str] name: Name of the policy, no longer than 128 characters and no slash characters.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FirewallPolicyOutboundNetworkArgs']]]] outbound_networks: Information on network addresses that are allowed to receive data or requests.
        :param pulumi.Input[str] type: Indicates the class of protection defined by the firewall.
        :param pulumi.Input[str] version: Aqua version functionality supported
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirewallPolicyState.__new__(_FirewallPolicyState)

        __props__.__dict__["author"] = author
        __props__.__dict__["block_icmp_ping"] = block_icmp_ping
        __props__.__dict__["block_metadata_service"] = block_metadata_service
        __props__.__dict__["description"] = description
        __props__.__dict__["inbound_networks"] = inbound_networks
        __props__.__dict__["lastupdate"] = lastupdate
        __props__.__dict__["name"] = name
        __props__.__dict__["outbound_networks"] = outbound_networks
        __props__.__dict__["type"] = type
        __props__.__dict__["version"] = version
        return FirewallPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def author(self) -> pulumi.Output[str]:
        """
        Username of the account that created the policy.
        """
        return pulumi.get(self, "author")

    @property
    @pulumi.getter(name="blockIcmpPing")
    def block_icmp_ping(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether policy includes blocking incoming 'ping' requests.
        """
        return pulumi.get(self, "block_icmp_ping")

    @property
    @pulumi.getter(name="blockMetadataService")
    def block_metadata_service(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether policy includes blocking metadata services of the cloud.
        """
        return pulumi.get(self, "block_metadata_service")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the Firewall Policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="inboundNetworks")
    def inbound_networks(self) -> pulumi.Output[Optional[Sequence['outputs.FirewallPolicyInboundNetwork']]]:
        """
        Information on network addresses that are allowed to pass in data or requests.
        """
        return pulumi.get(self, "inbound_networks")

    @property
    @pulumi.getter
    def lastupdate(self) -> pulumi.Output[int]:
        """
        Timestamp of the last update in Unix time format.
        """
        return pulumi.get(self, "lastupdate")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the policy, no longer than 128 characters and no slash characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outboundNetworks")
    def outbound_networks(self) -> pulumi.Output[Optional[Sequence['outputs.FirewallPolicyOutboundNetwork']]]:
        """
        Information on network addresses that are allowed to receive data or requests.
        """
        return pulumi.get(self, "outbound_networks")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Indicates the class of protection defined by the firewall.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Aqua version functionality supported
        """
        return pulumi.get(self, "version")

