/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Semaphore;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import net.sourceforge.plantuml.AnimatedGifEncoder;
import net.sourceforge.plantuml.CMapData;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.CornerParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.anim.AffineTransformation;
import net.sourceforge.plantuml.anim.Animation;
import net.sourceforge.plantuml.api.ImageDataComplex;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.braille.UGraphicBraille;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.graphic.HtmlColorSimple;
import net.sourceforge.plantuml.graphic.HtmlColorTransparent;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.mjpeg.MJPEGGenerator;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.hand.UGraphicHandwritten;
import net.sourceforge.plantuml.ugraphic.html5.UGraphicHtml5;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;
import net.sourceforge.plantuml.ugraphic.tikz.UGraphicTikz;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;
import net.sourceforge.plantuml.ugraphic.visio.UGraphicVdx;

public class ImageBuilder {
    private final ColorMapper colorMapper;
    private final double dpiFactor;
    private final HtmlColor mybackcolor;
    private final String metadata;
    private final String warningOrError;
    private final double margin1;
    private final double margin2;
    private final Animation animation;
    private final boolean useHandwritten;
    private UDrawable udrawable;
    private final double externalMargin1;
    private final double externalMargin2;
    private UStroke borderStroke;
    private HtmlColor borderColor;
    private double borderCorner;
    private boolean svgDimensionStyle;
    private boolean randomPixel;
    private static Semaphore SEMAPHORE_SMALL;
    private static Semaphore SEMAPHORE_BIG;
    private static int MAX_PRICE;

    public ImageBuilder(ColorMapper colorMapper, double dpiFactor, HtmlColor mybackcolor, String metadata, String warningOrError, double margin1, double margin2, Animation animation, boolean useHandwritten) {
        this.svgDimensionStyle = true;
        this.colorMapper = colorMapper;
        this.dpiFactor = dpiFactor;
        this.mybackcolor = mybackcolor;
        this.metadata = metadata;
        this.warningOrError = warningOrError;
        this.margin1 = margin1;
        this.margin2 = margin2;
        this.animation = animation;
        this.useHandwritten = useHandwritten;
        this.externalMargin1 = 0.0;
        this.externalMargin2 = 0.0;
        this.borderStroke = null;
        this.borderColor = null;
        this.borderCorner = 0.0;
    }

    public ImageBuilder(ISkinParam skinParam, double dpiFactor, String metadata, String warningOrError, double margin1, double margin2, Animation animation) {
        this(skinParam, dpiFactor, metadata, warningOrError, margin1, margin2, animation, skinParam.getBackgroundColor());
    }

    public ImageBuilder(ISkinParam skinParam, double dpiFactor, String metadata, String warningOrError, double margin1, double margin2, Animation animation, HtmlColor backColor) {
        Rose rose = new Rose();
        this.borderColor = rose.getHtmlColor(skinParam, ColorParam.diagramBorder);
        this.borderStroke = skinParam.getThickness(LineParam.diagramBorder, null);
        this.borderCorner = skinParam.getRoundCorner(CornerParam.diagramBorder, null);
        if (this.borderStroke == null && this.borderColor != null) {
            this.borderStroke = new UStroke();
        }
        this.colorMapper = skinParam.getColorMapper();
        this.svgDimensionStyle = skinParam.svgDimensionStyle();
        this.dpiFactor = dpiFactor;
        this.mybackcolor = backColor;
        this.metadata = metadata;
        this.warningOrError = warningOrError;
        this.margin1 = margin1;
        this.margin2 = margin2;
        this.animation = animation;
        this.useHandwritten = skinParam.handwritten();
        this.externalMargin1 = 0.0;
        this.externalMargin2 = 0.0;
    }

    public void setUDrawable(UDrawable udrawable) {
        this.udrawable = udrawable;
    }

    public ImageData writeImageTOBEMOVED(FileFormatOption fileFormatOption, long seed, OutputStream os) throws IOException {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.MJPEG) {
            return this.writeImageMjpeg(os, fileFormatOption.getDefaultStringBounder());
        }
        if (fileFormat == FileFormat.ANIMATED_GIF) {
            return this.writeImageAnimatedGif(os, fileFormatOption.getDefaultStringBounder());
        }
        return this.writeImageInternal(fileFormatOption, seed, os, this.animation);
    }

    public static void setMaxPixel(int max) {
        MAX_PRICE = max / 2;
        SEMAPHORE_SMALL = new Semaphore(MAX_PRICE, true);
        SEMAPHORE_BIG = new Semaphore(MAX_PRICE, true);
    }

    private int getPrice(FileFormatOption fileFormatOption, Dimension2D dim) {
        if (MAX_PRICE == 0) {
            return 0;
        }
        int price = Math.min(MAX_PRICE, (int)(dim.getHeight() * this.dpiFactor) * (int)(dim.getWidth() * this.dpiFactor));
        return price;
    }

    private Semaphore getSemaphore(int price) {
        if (price == 0) {
            return null;
        }
        if (price == MAX_PRICE) {
            return SEMAPHORE_BIG;
        }
        return SEMAPHORE_SMALL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageData writeImageInternal(FileFormatOption fileFormatOption, long seed, OutputStream os, Animation animationArg) throws IOException {
        int price;
        Semaphore semaphore;
        Dimension2D dim = this.getFinalDimension(fileFormatOption.getDefaultStringBounder());
        double dx = 0.0;
        double dy = 0.0;
        if (animationArg != null) {
            MinMax minmax = this.animation.getMinMax(dim);
            animationArg.setDimension(dim);
            dim = minmax.getDimension();
            dx = -minmax.getMinX();
            dy = -minmax.getMinY();
        }
        if ((semaphore = this.getSemaphore(price = this.getPrice(fileFormatOption, dim))) != null) {
            try {
                semaphore.acquire(price);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new IOException(e);
            }
        }
        try {
            Set<Url> urls;
            UGraphic2 ug = this.createUGraphic(fileFormatOption, seed, dim, animationArg, dx, dy);
            UGraphic ug2 = ug;
            if (this.externalMargin1 > 0.0) {
                ug2 = ug2.apply(new UTranslate(this.externalMargin1, this.externalMargin1));
            }
            if (this.borderStroke != null) {
                HtmlColor color = this.borderColor == null ? HtmlColorUtils.BLACK : this.borderColor;
                URectangle shape = new URectangle(dim.getWidth() - this.externalMargin() - this.borderStroke.getThickness(), dim.getHeight() - this.externalMargin() - this.borderStroke.getThickness(), this.borderCorner, this.borderCorner);
                ug2.apply(new UChangeColor(color)).apply(this.borderStroke).draw(shape);
            }
            if (this.randomPixel) {
                this.drawRandomPoint(ug2);
            }
            if (this.externalMargin1 > 0.0) {
                ug2 = ug2.apply(new UTranslate(this.externalMargin2, this.externalMargin2));
            }
            ug2 = ug2.apply(new UTranslate(this.margin1, this.margin1));
            UGraphic ugDecored = this.handwritten(ug2);
            this.udrawable.drawU(ugDecored);
            ugDecored.flushUg();
            ug.writeImageTOBEMOVED(os, this.metadata, 96);
            os.flush();
            if (ug instanceof UGraphicG2d && (urls = ((UGraphicG2d)ug).getAllUrlsEncountered()).size() > 0) {
                CMapData cmap = CMapData.cmapString(urls, this.dpiFactor);
                ImageDataComplex imageDataComplex = new ImageDataComplex(dim, cmap, this.warningOrError);
                return imageDataComplex;
            }
            ImageDataSimple imageDataSimple = new ImageDataSimple(dim);
            return imageDataSimple;
        }
        finally {
            if (semaphore != null) {
                semaphore.release(price);
            }
        }
    }

    private void drawRandomPoint(UGraphic ug2) {
        Random rnd = new Random();
        int red = rnd.nextInt(40);
        int green = rnd.nextInt(40);
        int blue = rnd.nextInt(40);
        Color c = new Color(red, green, blue);
        HtmlColorSimple color = new HtmlColorSimple(c, false);
        ug2.apply(new UChangeColor(color)).apply(new UChangeBackColor(color)).draw(new URectangle(1.0, 1.0));
    }

    private double externalMargin() {
        return 2.0 * (this.externalMargin1 + this.externalMargin2);
    }

    public Dimension2D getFinalDimension(StringBounder stringBounder) {
        LimitFinder limitFinder = new LimitFinder(stringBounder, true);
        this.udrawable.drawU(limitFinder);
        Dimension2DDouble dim = new Dimension2DDouble(limitFinder.getMaxX(), limitFinder.getMaxY());
        return new Dimension2DDouble(((Dimension2D)dim).getWidth() + 1.0 + this.margin1 + this.margin2 + this.externalMargin(), ((Dimension2D)dim).getHeight() + 1.0 + this.margin1 + this.margin2 + this.externalMargin());
    }

    private UGraphic handwritten(UGraphic ug) {
        if (this.useHandwritten) {
            return new UGraphicHandwritten(ug);
        }
        return ug;
    }

    private ImageData writeImageMjpeg(OutputStream os, StringBounder stringBounder) throws IOException {
        LimitFinder limitFinder = new LimitFinder(stringBounder, true);
        this.udrawable.drawU(limitFinder);
        Dimension2DDouble dim = new Dimension2DDouble(limitFinder.getMaxX() + 1.0 + this.margin1 + this.margin2, limitFinder.getMaxY() + 1.0 + this.margin1 + this.margin2);
        File f = new File("c:/tmp.avi");
        int nbframe = 100;
        MJPEGGenerator m = new MJPEGGenerator(f, this.getAviImage(null).getWidth(null), this.getAviImage(null).getHeight(null), 12.0, 100);
        int i = 0;
        if (i < 100) {
            AffineTransform at = AffineTransform.getTranslateInstance(((Dimension2D)dim).getWidth() / 2.0, ((Dimension2D)dim).getHeight() / 2.0);
            at.rotate(1.5707963267948966 * (double)i / 100.0);
            at.translate(-((Dimension2D)dim).getWidth() / 2.0, -((Dimension2D)dim).getHeight() / 2.0);
            throw new UnsupportedOperationException();
        }
        m.finishAVI();
        FileUtils.copyToStream(f, os);
        return new ImageDataSimple(dim);
    }

    private ImageData writeImageAnimatedGif(OutputStream os, StringBounder stringBounder) throws IOException {
        LimitFinder limitFinder = new LimitFinder(stringBounder, true);
        this.udrawable.drawU(limitFinder);
        Dimension2DDouble dim = new Dimension2DDouble(limitFinder.getMaxX() + 1.0 + this.margin1 + this.margin2, limitFinder.getMaxY() + 1.0 + this.margin1 + this.margin2);
        MinMax minmax = this.animation.getMinMax(dim);
        AnimatedGifEncoder e = new AnimatedGifEncoder();
        e.setRepeat(0);
        e.start(os);
        e.setDelay(60);
        for (AffineTransformation at : this.animation.getAll()) {
            ImageIcon ii = new ImageIcon(this.getAviImage(at));
            e.addFrame((BufferedImage)ii.getImage());
        }
        e.finish();
        return new ImageDataSimple(dim);
    }

    private Image getAviImage(AffineTransformation affineTransform) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeImageInternal(new FileFormatOption(FileFormat.PNG), 42L, baos, Animation.singleton(affineTransform));
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        BufferedImage im = ImageIO.read(bais);
        bais.close();
        return im;
    }

    private UGraphic2 createUGraphic(FileFormatOption fileFormatOption, long seed, Dimension2D dim, Animation animationArg, double dx, double dy) {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        switch (fileFormat) {
            case PNG: {
                return this.createUGraphicPNG(this.colorMapper, this.dpiFactor, dim, this.mybackcolor, animationArg, dx, dy);
            }
            case SVG: {
                return this.createUGraphicSVG(this.colorMapper, this.dpiFactor, dim, this.mybackcolor, fileFormatOption.getSvgLinkTarget(), fileFormatOption.getHoverColor(), seed);
            }
            case EPS: {
                return new UGraphicEps(this.colorMapper, EpsStrategy.getDefault2());
            }
            case EPS_TEXT: {
                return new UGraphicEps(this.colorMapper, EpsStrategy.WITH_MACRO_AND_TEXT);
            }
            case HTML5: {
                return new UGraphicHtml5(this.colorMapper);
            }
            case VDX: {
                return new UGraphicVdx(this.colorMapper);
            }
            case LATEX: {
                return new UGraphicTikz(this.colorMapper, this.dpiFactor, true, fileFormatOption.getTikzFontDistortion());
            }
            case LATEX_NO_PREAMBLE: {
                return new UGraphicTikz(this.colorMapper, this.dpiFactor, false, fileFormatOption.getTikzFontDistortion());
            }
            case BRAILLE_PNG: {
                return new UGraphicBraille(this.colorMapper, fileFormat);
            }
            case UTXT: 
            case ATXT: {
                return new UGraphicTxt();
            }
        }
        throw new UnsupportedOperationException(fileFormat.toString());
    }

    private UGraphic2 createUGraphicSVG(ColorMapper colorMapper, double scale, Dimension2D dim, HtmlColor mybackcolor, String svgLinkTarget, String hover, long seed) {
        Color backColor = Color.WHITE;
        if (mybackcolor instanceof HtmlColorSimple) {
            backColor = colorMapper.getMappedColor(mybackcolor);
        }
        UGraphicSvg ug = mybackcolor instanceof HtmlColorGradient ? new UGraphicSvg(this.svgDimensionStyle, dim, colorMapper, (HtmlColorGradient)mybackcolor, false, scale, svgLinkTarget, hover, seed) : (backColor == null || backColor.equals(Color.WHITE) ? new UGraphicSvg(this.svgDimensionStyle, dim, colorMapper, false, scale, svgLinkTarget, hover, seed) : new UGraphicSvg(this.svgDimensionStyle, dim, colorMapper, StringUtils.getAsHtml(backColor), false, scale, svgLinkTarget, hover, seed));
        return ug;
    }

    private UGraphic2 createUGraphicPNG(ColorMapper colorMapper, double dpiFactor, Dimension2D dim, HtmlColor mybackcolor, Animation affineTransforms, double dx, double dy) {
        Color backColor = Color.WHITE;
        if (mybackcolor instanceof HtmlColorSimple) {
            backColor = colorMapper.getMappedColor(mybackcolor);
        } else if (mybackcolor instanceof HtmlColorTransparent) {
            backColor = null;
        }
        EmptyImageBuilder builder = new EmptyImageBuilder((int)(dim.getWidth() * dpiFactor), (int)(dim.getHeight() * dpiFactor), backColor);
        Graphics2D graphics2D = builder.getGraphics2D();
        UGraphicG2d ug = new UGraphicG2d(colorMapper, graphics2D, dpiFactor, affineTransforms == null ? null : affineTransforms.getFirst(), dx, dy);
        ug.setBufferedImage(builder.getBufferedImage());
        BufferedImage im = ug.getBufferedImage();
        if (mybackcolor instanceof HtmlColorGradient) {
            ug.apply(new UChangeBackColor(mybackcolor)).draw(new URectangle((double)im.getWidth() / dpiFactor, (double)im.getHeight() / dpiFactor));
        }
        return ug;
    }

    public void setRandomPixel(boolean randomPixel) {
        this.randomPixel = randomPixel;
    }

    static {
        MAX_PRICE = 0;
    }
}

