/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.util.Map;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cute.Cheese;
import net.sourceforge.plantuml.cute.Circle;
import net.sourceforge.plantuml.cute.CuteShape;
import net.sourceforge.plantuml.cute.Group;
import net.sourceforge.plantuml.cute.Positionned;
import net.sourceforge.plantuml.cute.PositionnedImpl;
import net.sourceforge.plantuml.cute.Rectangle;
import net.sourceforge.plantuml.cute.Stick;
import net.sourceforge.plantuml.cute.Triangle;
import net.sourceforge.plantuml.cute.VarArgs;

public class CuteShapeFactory {
    private final Map<String, Group> groups;

    public CuteShapeFactory(Map<String, Group> groups) {
        this.groups = groups;
    }

    public Positionned createCuteShapePositionned(String data) {
        VarArgs varArgs = new VarArgs(data);
        return new PositionnedImpl(this.createCuteShape(data), varArgs);
    }

    private CuteShape createCuteShape(String data) {
        data = StringUtils.trin(data.toLowerCase());
        VarArgs varArgs = new VarArgs(data);
        if (data.startsWith("circle ")) {
            return new Circle(varArgs);
        }
        if (data.startsWith("cheese ")) {
            return new Cheese(varArgs);
        }
        if (data.startsWith("stick ")) {
            return new Stick(varArgs);
        }
        if (data.startsWith("rectangle ") || data.startsWith("rect ")) {
            return new Rectangle(varArgs);
        }
        if (data.startsWith("triangle ")) {
            return new Triangle(varArgs);
        }
        String first = data.split(" ")[0];
        Group group = this.groups.get(first);
        if (group == null) {
            throw new IllegalArgumentException("Cannot find group " + first + " in " + this.groups.keySet());
        }
        return group;
    }
}

