/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.cucadiagram.Bodier;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupRoot;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.HideOrShow2;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LongCode;
import net.sourceforge.plantuml.cucadiagram.entity.EntityImpl;
import net.sourceforge.plantuml.skin.VisibilityModifier;

public class EntityFactory {
    private final Map<Code, ILeaf> leafs = new LinkedHashMap<Code, ILeaf>();
    private final List<Link> links = new ArrayList<Link>();
    private final Map<Code, IGroup> groups = new LinkedHashMap<Code, IGroup>();
    private int rawLayout;
    private final IGroup rootGroup = new GroupRoot(this);
    private final List<HideOrShow2> hides2;
    private final List<HideOrShow2> removed;

    public EntityFactory(List<HideOrShow2> hides2, List<HideOrShow2> removed) {
        this.hides2 = hides2;
        this.removed = removed;
    }

    public boolean isHidden(ILeaf leaf) {
        boolean hidden = false;
        for (HideOrShow2 hide : this.hides2) {
            hidden = hide.apply(hidden, leaf);
        }
        return hidden;
    }

    public boolean isRemoved(ILeaf leaf) {
        boolean result = false;
        for (HideOrShow2 hide : this.removed) {
            result = hide.apply(result, leaf);
        }
        return result;
    }

    public ILeaf createLeaf(Code code, Display display, LeafType entityType, IGroup parentContainer, Set<VisibilityModifier> hides, String namespaceSeparator) {
        if (entityType == null) {
            throw new IllegalArgumentException();
        }
        Bodier bodier = new Bodier(entityType, hides);
        LongCode longCode = this.getLongCode(code, namespaceSeparator);
        EntityImpl result = new EntityImpl(this, code, bodier, parentContainer, entityType, longCode, namespaceSeparator, this.rawLayout);
        bodier.setLeaf(result);
        result.setDisplay(display);
        return result;
    }

    private LongCode getLongCode(Code code, String namespaceSeparator) {
        LongCode result = LongCode.of(code.getFullName(), namespaceSeparator);
        return result;
    }

    public IGroup createGroup(Code code, Display display, Code namespace2, GroupType groupType, IGroup parentContainer, Set<VisibilityModifier> hides, String namespaceSeparator) {
        if (groupType == null) {
            throw new IllegalArgumentException();
        }
        Bodier bodier = new Bodier(null, hides);
        LongCode longCode = this.getLongCode(code, namespaceSeparator);
        EntityImpl result = new EntityImpl(this, code, bodier, parentContainer, groupType, namespace2, longCode, namespaceSeparator, this.rawLayout);
        if (!Display.isNull(display)) {
            result.setDisplay(display);
        }
        return result;
    }

    public IGroup getRootGroup() {
        return this.rootGroup;
    }

    public final ILeaf getLeafsget(Code code) {
        return this.leafs.get(code);
    }

    public final Collection<ILeaf> getLeafsvalues() {
        return Collections.unmodifiableCollection(this.leafs.values());
    }

    public void addLeaf(ILeaf entity) {
        this.leafs.put(entity.getCode(), entity);
    }

    public void incRawLayout() {
        ++this.rawLayout;
    }

    void removeLeaf(Code code) {
        IEntity removed = this.leafs.remove(code);
        if (removed == null) {
            throw new IllegalArgumentException();
        }
    }

    public void addGroup(IGroup group) {
        this.groups.put(group.getCode(), group);
    }

    void removeGroup(Code code) {
        IEntity removed = this.groups.remove(code);
        if (removed == null) {
            throw new IllegalArgumentException();
        }
    }

    public final Collection<IGroup> getGroupsvalues() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    public final IGroup getGroupsget(Code code) {
        return this.groups.get(code);
    }

    public final List<Link> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public void addLink(Link link) {
        if (link.isSingle() && this.containsSimilarLink(link)) {
            return;
        }
        this.links.add(link);
    }

    private boolean containsSimilarLink(Link other) {
        for (Link link : this.links) {
            if (!other.sameConnections(link)) continue;
            return true;
        }
        return false;
    }

    public void removeLink(Link link) {
        boolean ok = this.links.remove(link);
        if (!ok) {
            throw new IllegalArgumentException();
        }
    }

    public IGroup muteToGroup(Code code, Code namespace2, GroupType type, IGroup parent) {
        ILeaf leaf = this.leafs.get(code);
        ((EntityImpl)leaf).muteToGroup(namespace2, type, parent);
        IGroup result = (IGroup)((Object)leaf);
        this.removeLeaf(code);
        return result;
    }
}

