/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileThinSplit
extends AbstractFtile {
    private double width;
    private double first;
    private double last;
    private final double height = 1.5;
    private final HtmlColor colorBar;
    private final Swimlane swimlane;

    public FtileThinSplit(ISkinParam skinParam, HtmlColor colorBar, Swimlane swimlane) {
        super(skinParam);
        this.colorBar = colorBar;
        this.swimlane = swimlane;
    }

    public void setGeom(double first, double last, double width) {
        this.width = width;
        this.first = first;
        this.last = last;
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        return new FtileGeometry(this.width, 1.5, this.width / 2.0, 0.0, 1.5);
    }

    @Override
    public void drawU(UGraphic ug) {
        ULine rect = new ULine(this.last - this.first, 0.0);
        ug = ug.apply(new UTranslate(this.first, 0.0));
        ug.apply(new UChangeColor(this.colorBar)).apply(new UStroke(1.5)).draw(rect);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }
}

