# Other Screen Scaping Utilities & Services

## Utilities

* [Selenium](https://selenium-python.readthedocs.io/)
  * [Python Selenium Full Series](https://www.youtube.com/playlist?list=PLOkVupluCIjtdAJ7067yDWf_HGJR0Nom5)

* [Scrapy](http://scrapy.org/)
  * [Handling JavaScript in Scrapy with Splash](http://blog.scrapinghub.com/2015/03/02/handling-javascript-in-scrapy-with-splash/)
  * [Video: Python Scrapy Tutorial- 1 - Web Scraping, Spiders and Crawling](https://www.youtube.com/watch?v=ve_0h4Y8nuI)
  * [13 Sep '21 - How to Crawl the Web with Scrapy](https://www.babbling.fish/scraping-for-a-job/)
  * [18 Dec '19 - Easy web scraping with Scrapy](https://www.scrapingbee.com/blog/web-scraping-with-scrapy/)
  * [8 Oct '19 - PRICE INTELLIGENCE WITH PYTHON: SCRAPY, SQL AND PANDAS](https://blog.scrapinghub.com/price-intelligence-with-python-scrapy-sql-pandas)
  * [16 Jul '19 - The Ultimate Guide To Building Scalable Web Scrapers With Scrapy](https://www.smashingmagazine.com/2019/07/ultimate-guide-scalable-web-scrapers-scrapy/)
* [BeautifulSoup](http://www.crummy.com/software/BeautifulSoup/)
  * [Beagle Scraper - building the largest open-source Ecommerce scraper with Python and BeautifulSoup4](https://github.com/ChrisRoark/beagle_scraper)
  * [28 Jul '21 - How to Create a Price Comparison Tool With Python BeautifulSoup](https://webautomation.io/blog/how-to-create-price-comparison-tool-with-beautiful-soup/)
  * [30 Mar '21 - Tutorial: Web Scraping with Python Using Beautiful Soup](https://www.dataquest.io/blog/web-scraping-python-using-beautiful-soup/)
  * [16 Nov '20 - How to scrape Amazon.com with Python, Selenium and BeautifulSoup](https://www.youtube.com/watch?v=497Fy7CIBOk)
  * [20 Jul '19 - Intro to Scraping NBA Data with BeautifulSoup](https://medium.com/hardwood-convergence/intro-to-virtual-environments-and-scraping-nba-data-with-beautifulsoup-6ce745f8c26e)
  * [20 Apr '19 - Video: Scraping Stack Overflow Using Python Tutorial | Beautiful Soup](https://www.youtube.com/watch?v=EolFGrohtzw)
  * [10 Jun '17 - How to scrape websites with Python and BeautifulSoup](https://medium.freecodecamp.org/how-to-scrape-websites-with-python-and-beautifulsoup-5946935d93fe)
  * [7 Jan '17 - Intro to Web Scraping with Python and Beautiful Soup](https://youtu.be/XQgXKtPSzUI)
  * [6 Sep '18 - Data Science Skills: Web scraping using python](https://towardsdatascience.com/data-science-skills-web-scraping-using-python-d1a85ef607ed)
* [spider.py](https://pypi.python.org/pypi/spider.py)
* [Metascraper](https://github.com/lloydmeta/metascraper)
* [Apache Nutch](http://nutch.apache.org/)
* [Yahoo Anthelion](https://github.com/yahoo/anthelion)
* [Puppeteer](https://nemethgergely.com/puppeteer-browser-automation/)
  * [30 Sep '20 - Puppeteer Tutorial: Scraping With a Headless Browser](https://oxylabs.io/blog/puppeteer-tutorial)
  * [28 Oct '20 - Introduction to web testing and scraping](https://www.openfaas.com/blog/puppeteer-scraping/)
  * [16 Jan '19 - Web Scraping with Puppeteer…](https://blog.bitsrc.io/web-scraping-with-puppeteer-e73e5fee7474)
  * [4 Oct '18 - An Introduction to Web Scraping with Puppeteer](https://medium.com/swlh/an-introduction-to-web-scraping-with-puppeteer-3d35a51fdca0)
  * [12 Apr '18 - Pyppeteer, the snake charmer](https://medium.com/commite/pyppeteer-the-snake-charmer-f3d1843ddb19)
  * [theheadless.dev](https://theheadless.dev/)
* [Toapi](http://www.toapi.org/about/installation/)
* [ScrapedIn](https://github.com/dchrastil/ScrapedIn) - A tool to scrape LinkedIn without API restrictions for data reconnaissance
* [amazon-scraper-python](https://github.com/tducret/amazon-scraper-python)
* [Instagram-Scraper](https://github.com/meetmangukiya/instagram-scraper)
* [Ferret](https://github.com/MontFerret/ferret)
* [cheerio](https://cheerio.js.org/)
  * [25 Dec '18 - How to Perform Web-Scraping using Node.js](https://blog.bitsrc.io/https-blog-bitsrc-io-how-to-perform-web-scraping-using-node-js-5a96203cb7cb)
* [PhantomJS](http://phantomjs.org/)
* [jsdom](https://github.com/jsdom/jsdom)
* [kadnan/ScrapeGen](https://github.com/kadnan/ScrapeGen)
* [xtream1101/scraperx](https://github.com/xtream1101/scraperx)
* [Goutte (PHP)](https://github.com/FriendsOfPHP/Goutte)
  * [PHP Scraper - An opinionated web-scraper library for PHP](https://phpscraper.de/)

## Services

* [ScrapingBee](https://www.scrapingbee.com/)
  * [12 Nov '20 - Charles proxy for web scraping](https://www.scrapingbee.com/blog/charles-proxy/)
* [ScrapingNinja](https://www.scrapingninja.co/) - found this one after reading [Web Scraping 101 with Python](https://www.daolf.com/posts/web-scraping-101-python/)
* [Apify](https://www.apify.com/)
* [ParseHub](http://parsehub.com/)
* [Headless Chrome Crawler](https://github.com/yujiosaka/headless-chrome-crawler)
* [Link Fish](https://link.fish/)
* awesome list of services [here](https://www.producthunt.com/tech/crawly)
* [Yodlee](http://www.yodlee.com/)
* [Kapow](http://kapowsoftware.com/solutions/process-automation/B2B-process-automation.php)
* [ScraperWiki](https://scraperwiki.com/)
* [import.io](https://import.io/)
  * [18 Dec '18 - Import.io raises $15.5 million for AI that extracts web data](https://venturebeat.com/2018/12/18/import-io-raises-15-5-million-for-ai-that-extracts-web-data/)
* [Webhose](https://webhose.io/)
* [Common Crawl](http://commoncrawl.org/)
* [ConvExtra](http://convextra.com/)
* [Page Munch](http://www.pagemunch.com/)
* [Prompt Cloud](http://promptcloud.com/)
* [ScrapingHub](http://scrapinghub.com/)
* [screen-scraper](http://screen-scraper.com/)
* [Web Scrape Master](http://webscrapemaster.com/)
* [Kimono](https://www.kimonolabs.com/)
* [UiPath](http://www.uipath.com/)
* [Automation Anywhere](https://www.automationanywhere.com/)
* [CloudFlare ScrapeShield](https://www.cloudflare.com/apps/scrapeshield/)
* [ScrapeSentry](https://www.scrapesentry.com) acquired by [Distil Networks](http://www.distilnetworks.com) on [13 Jan '16](http://techcrunch.com/2016/01/13/distil-networks-gets-human-touch-with-scrapesentry-acquisition)
* [29 Oct '18 - Introducing reCAPTCHA v3: the new way to stop bots](https://webmasters.googleblog.com/2018/10/introducing-recaptcha-v3-new-way-to.html)
* [Plaid](https://plaid.com/)
  * [Build Your Own Mint](https://github.com/yyx990803/build-your-own-mint)
  * [Quovo](https://www.quovo.com/) - [acquired by Plaid on 8 Jan '19](https://blog.plaid.com/quovo/)
* [scraperapi](https://www.scraperapi.com/)
* [Spider Pro](https://tryspider.com/)
* [DarshanDeshpande / Scrapera](https://github.com/DarshanDeshpande/Scrapera)

## Other

* [UofT Scrapers](https://github.com/cobalt-io/uoft-scrapers)
* [Video: Automating an Insider Trading Dashboard with Python and Tableau | Part 1: Web Scraping with Selenium](https://www.youtube.com/watch?v=KVZjGFJcUic)
* [31 Aug '20 - Web Scraping 101 with Python](https://www.scrapingbee.com/blog/web-scraping-101-with-python/)

## References

* [Screen Scraping: A Hands-on Introduction](http://tutorials.iq.harvard.edu/Python/scraping/)
* [Everything You wanted to Know About Web Scraping (but were afraid to ask)](http://resources.distilnetworks.com/h/i/111901208-everything-you-wanted-to-know-about-web-scraping-but-were-afraid-to-ask/181642)
* [PerimeterX](https://www.perimeterx.com/)
* [14 Nov '17 - Ask HN: What are best tools for web scraping?'](https://news.ycombinator.com/item?id=15694118)
* [1 Nov '18 - I was looking for a house, so I built a web scraper in Python!](https://towardsdatascience.com/looking-for-a-house-build-a-web-scraper-to-help-you-5ab25badc83e)
* [11 Dec '18 - An introduction to web scraping with Python](https://towardsdatascience.com/an-introduction-to-web-scraping-with-python-a2601e8619e5)

## Books

* [Web Scraping with Python: Collecting More Data from the Modern Web](https://www.amazon.com/Web-Scraping-Python-Collecting-Modern/dp/1491985577)

## [MFA](https://en.wikipedia.org/wiki/Multi-factor_authentication) & [CAPTCHA](https://en.wikipedia.org/wiki/CAPTCHA)

* [2 Jan '19 - Automated System Bypasses Google reCAPTCHA Again](https://www.securityweek.com/automated-system-bypasses-google-recaptcha-again)
* [19 Dec '18 - Breaking CAPTCHA Using Machine Learning in 0.05 Seconds](https://medium.com/mlmemoirs/breaking-captcha-using-machine-learning-in-0-05-seconds-9feefb997694)
* [reCAPTCHA](https://www.google.com/recaptcha/intro/v3.html)
* [9 CAPTCHA Alternatives That Won’t Wreck Your UX](https://www.dtelepathy.com/blog/design/captcha-alternatives-better-ux)
